<?php namespace Halk\Core;

use Halk\Core\Exception\CoreException;

/**
 * Pool interface.
 *
 * @category   PHP
 * @package    Halk
 * @subpackage Core_Interfaces
 * @author     Kolombet Ivan <i.kolombet@hoster.ru>
 * @copyright  2011 Filanco
 * @license    Proprietary http://www.filanco.ru
 * @version    Release: 2.0
 * @link       http://halk.filanco.ru
 */
interface PoolInterface {

    /**
     * Container initialize routine.
     * Load all available objects from certain sources.
     * Called in constructor of pool.
     *
     * @return void
     */
    public function load();

    /**
     * Fetch object by ID.
     *
     * @param string $id identifier
     *
     * @return object
     * @throws CoreException if ID does not exist
     */
    public function get($id);

    /**
     * Add new object to container and assign it a certain ID.
     * Id must be unique.
     *
     * @param string          $id     identifier
     * @param PoolElement $object object instance
     *
     * @see PoolElement
     *
     * @return void
     * @throws CoreException if wrong object or not unique ID
     */
    public function add($id, PoolElement $object);
}//end interface
