<?php

namespace Halk\Core\Helper\XLSXWriter;

class XLSXWriterBuffererWriter
{
    protected $fd = NULL;
    protected $buffer='';
    protected $check_utf8 = FALSE;

    public function __construct($filename, $fd_fopen_flags = 'w', $check_utf8 = false)
    {
        $this->check_utf8 = $check_utf8;
        $this->fd = fopen($filename, $fd_fopen_flags);
    }

    public function write($string)
    {
        $this->buffer .= $string;
        if (isset($this->buffer[8191])) {
            $this->purge();
        }
    }

    protected function purge()
    {
        if ($this->fd) {
            if ($this->check_utf8 && !self::isValidUTF8($this->buffer)) {
                $this->check_utf8 = FALSE;
            }
            fwrite($this->fd, $this->buffer);
            $this->buffer='';
        }
    }

    public function close()
    {
        $this->purge();
        if ($this->fd) {
            fclose($this->fd);
            $this->fd=null;
        }
    }

    public function __destruct()
    {
        $this->close();
    }

    public function ftell()
    {
        if ($this->fd) {
            $this->purge();
            return ftell($this->fd);
        }
        return -1;
    }

    public function fseek($pos)
    {
        if ($this->fd) {
            $this->purge();
            return fseek($this->fd, $pos);
        }
        return -1;
    }

    protected static function isValidUTF8($string)
    {
        if (function_exists('mb_check_encoding'))
        {
            return mb_check_encoding($string, 'UTF-8') ? true : FALSE;
        }
        return preg_match("//u", $string) ? true : FALSE;
    }
}
