<?php
namespace Halk\Core\Helper;

class ExceptionHelper
{
    /**
     * @param \Throwable $error
     * @return string
     */
    public static function getErrorMessageFromException($error)
    {
        $file = $error->getFile();
        if (defined('HALK_DOCUMENT_ROOT')) {
            $file = str_replace(HALK_DOCUMENT_ROOT, '.', $file);
        }
        return sprintf(
            "[%s] [%s:%s] %s\n%s",
            get_class($error),
            $file,
            $error->getLine(),
            $error->getMessage(),
            $error->getTraceAsString()
        );
    }

    /**
     * @param \Throwable $error
     * @return string
     */
    public static function convertExceptionToString($error)
    {
        $previous_exception = $error->getPrevious();
        $messages[] = static::getErrorMessageFromException($error);
        while (!is_null($previous_exception)) {
            $messages[] = static::getErrorMessageFromException($previous_exception);
            $previous_exception = $previous_exception->getPrevious();
        }
        return implode(PHP_EOL, $messages);
    }
}
