<?php
namespace Halk\Core;

use Halk\Core\Exception\CoreException;

class Utils
{
    public static function ends_with($haystack, $needle, $case = true)
    {

        $haystack = strrev($haystack);
        $needle = strrev($needle);

        return static::starts_with($haystack, $needle, $case);
    }

    public static function starts_with($haystack, $needle, $case = true)
    {
        return $case ? (stripos($haystack, $needle) === 0) : (strpos($haystack, $needle) === 0);
    }

    public static function hstoreToArray($data)
    {
        if (empty($data) || $data === 'NULL') {
            return null;
        }

        @eval(sprintf("\$hstore = array(%s);", $data));

        if (!(isset($hstore) and is_array($hstore))) {
            throw new CoreException(sprintf("Could not parse hstore string '%s' to array.", $data));
        }
        return $hstore;
    }

    public static function arrayToHstore($data)
    {
        if (!is_array($data)) {
            throw new CoreException(sprintf(
                "HStore::toPg takes an associative array as parameter ('%s' given).",
                gettype($data)
            ));
        }

        $insert_values = array();

        foreach ($data as $key => $value) {
            if (is_null($value)) {
                $insert_values[] = sprintf('"%s" => NULL', $key);
            } else {
                $insert_values[] = sprintf('"%s" => "%s"', addcslashes($key, '\"'), addcslashes($value, '\"'));
            }
        }

        return sprintf("%s%s", null, join(', ', $insert_values));
    }

    public static function pgArray(
        $input_text = null,
        $delimiter = ',',
        $text_qualifier = '"',
        $array_text_start = '{',
        $array_text_end = '}',
        $text_escape = '\\'
    )
    {

        if (is_null($input_text)) {
            return array();
        }
        if ($input_text == '{}') {
            return array();
        }
        $level = -1;
        $levels = array();
        $level_i = 0;
        $flag_esc = false;
        $flag_text = false;
        $i = 0;
        $strlen = strlen($input_text);

        while ($i < $strlen) {
            if ($i == 0 && $input_text{$i} !== $array_text_start) {
                $flag_text = true;
            }
            if ($flag_esc) {
                empty($levels[$level]) && $levels[$level] = array();
                !array_key_exists($level_i, $levels[$level]) && $levels[$level][$level_i] = '';
                $levels[$level][$level_i] .= $input_text{$i++};
                $flag_esc = false;
                continue;
            }
            if ($flag_text && !in_array($input_text{$i}, array($text_escape, $text_qualifier))) {
                empty($levels[$level]) && $levels[$level] = array();
                !array_key_exists($level_i, $levels[$level]) && $levels[$level][$level_i] = '';
                $levels[$level][$level_i] .= $input_text{$i++};
                continue;
            }
            if (in_array($input_text{$i}, array($array_text_end, $delimiter))) {
                if ($levels[$level][$level_i] == 'NULL' && $input_text{$i - 1} != $text_qualifier) {
                    $levels[$level][$level_i] = null;
                }
            }

            switch ($input_text{$i}) {
                case $text_escape:
                    $flag_esc = true;
                    break;

                case $array_text_start:
                    $level++;
                    $level_i = 0;
                    $levels[$level] = array();
                    break;

                case $array_text_end:
                    $level--;
                    $level_i = 0;
                    empty($levels[$level]) && $levels[$level] = array();
                    $levels[$level][] = empty($levels[$level + 1]) ? null : $levels[$level + 1];
                    break;

                case $text_qualifier:
                    $flag_text = !$flag_text;
                    break;

                case $delimiter:
                    $level_i++;
                    break;

                default:
                    empty($levels[$level]) && $levels[$level] = array();
                    !array_key_exists($level_i, $levels[$level]) && $levels[$level][$level_i] = '';
                    $levels[$level][$level_i] .= $input_text{$i};
                    break;
            }
            $i++;
        }
        return $levels[-1][0];
    }

    public static function dump_sql_params(array $array)
    {

        return implode(
            ', ',
            array_map(
                function ($x) {
                    return is_null($x) ? 'NULL' : $x;
                },
                $array
            )
        );
    }

    public static function halk_object_to_array($obj)
    {
        return get_object_vars($obj);
    }
}
