<?php

namespace Halk\Core\Smarty;

class SmartyFilters
{
    /**
     * Фильтрует шаблон tpl перед компиляцией, добавляя метки времени модульным ссылкам css и js
     * @param $tpl_output
     * @param $template
     * @return mixed
     */
    public function addTimestampsToLinks($tpl_output, $template) {
        preg_match_all('/src="([^"]*)"/', $tpl_output, $js_matches);
        preg_match_all('/href="([^"]*)"/', $tpl_output, $css_matches);

        $links = [];
        $links = isset($js_matches[1])
            ? array_merge($links, $js_matches[1])
            : $links;
        $links = isset($css_matches[1])
            ? array_merge($links, $css_matches[1])
            : $links;

        foreach ($links as $link) {
            // Исключаем ссылки обрабатываемые функцией asset_mtime
            if (strpos('{asset_mtime', $link) !== false) {
                continue;
            }

            $change_link = false;
            $dir = null;
            $link = trim($link);
            $exploded_link = explode('/', $link);

            if (empty($exploded_link)) {
                continue;
            }

            // Проверям, что формат файл ссылки либо css либо js, иначе пропускаем
            $exploded_link_last_part = $exploded_link[count($exploded_link) - 1];
            $exploded_link_last_part = explode('.', $exploded_link_last_part);
            $link_format = empty($exploded_link_last_part[count($exploded_link_last_part) - 1])
                ? null
                : $exploded_link_last_part[count($exploded_link_last_part) - 1];
            if (!in_array($link_format, ['css', 'js'])) {
                continue;
            }

            // Проверяем, указывает ли ссылка на файл в папке html или на файл в папке Modules,
            // если да, отмечаем, что надо обработать
            $html_dir = HALK_ROOT . '/html' . $link;
            if (file_exists($html_dir)) {
                $change_link = true;
                $dir = $html_dir;
            } elseif (
                !empty($exploded_link[1]) &&
                !empty($exploded_link[2]) &&
                !empty($exploded_link[3])
            ) {
                $module_type = strtolower($exploded_link[1]);
                $module_name = ucfirst(strtolower($exploded_link[2]));
                $module_dir_last_part = implode('/', array_slice($exploded_link, 3));
                $module_dir = HALK_APP_ROOT . '/Module/' . $module_name . '/View/' . $module_type . '/' . $module_dir_last_part;

                if (file_exists($module_dir)) {
                    $change_link = true;
                    $dir = $module_dir;
                }
            }

            // Если ссылка подходит под условия, добавляем ей метку времени последнего обновления в шаблоне
            if ($change_link && $dir) {
                $tpl_output = str_replace(
                    $link,
                    $link . '?' . filemtime($dir),
                    $tpl_output
                );
            }
        }

        return $tpl_output;
    }
}