<?php

namespace Halk\Core;

use Doctrine\DBAL\Cache\QueryCacheProfile;
use Doctrine\DBAL\Connection;

class DBALConnectionWrapper extends Connection
{
    public function executeQuery($query, array $params = [], $types = [], ?QueryCacheProfile $qcp = null)
    {
        return QueryTimer::measure($query, function() use ($query, $params, $types, $qcp) {
            return parent::executeQuery($query, $params, $types, $qcp);
        });
    }

    public function executeUpdate($query, array $params = [], array $types = [])
    {
        return QueryTimer::measure($query, function() use ($query, $params, $types) {
            return parent::executeUpdate($query, $params, $types);
        });
    }

    public function exec($statement)
    {
        return QueryTimer::measure($statement, function() use ($statement) {
            return parent::exec($statement);
        });
    }
}
