<?php
namespace Halk\Core;

/**
 * Cassandra DBO.
 *
 * PHP version 5.3
 *
 * @category   PHP
 * @package    Halk
 * @subpackage Core
 * @author     Kolombet Ivan <i.kolombet@hoster.ru>
 * @copyright  2011 Filanco
 * @license    Proprietary http://www.filanco.ru
 * @version    SVN: $Id: DBOCassandra.php 10514 2012-03-14 15:19:06Z i.kolombet $
 * @link       http://halk.filanco.ru
 */

class DBOCassandra extends DBO
{

    /**
     * @param array $hosts
     * @param array $ports
     * @param string $keyspace
     * @param string $cluster_id
     */
    public function __construct(array $hosts, array $ports, $keyspace, $cluster_id)
    {

        $this->engine = 'cassandra';
        $this->connection_id = $cluster_id;

        $dsn = sprintf('%s:', $this->engine);

        array_map(
            function ($host, $port) use (&$dsn) {
                $dsn .= sprintf('host=%s;port=%s;', $host, $port);
            },
            $hosts,
            $ports
        );

        $this->dsn = $dsn;

        $this->pdo = new \PDO($this->dsn);
        $this->pdo->setAttribute(\PDO::ATTR_PERSISTENT, 1);
        $this->pdo->setAttribute(\PDO::ATTR_ERRMODE, \PDO::ERRMODE_EXCEPTION);

        $this->query(sprintf('USE %s;', $keyspace));
    }
}
