<?php

namespace Halk\Core\Exception;

class ExtendedException extends CoreException
{
    /** @var array */
    private $details;

    public function __construct(string $message, array $details, $code = 0, \Exception $previous = null)
    {
        parent::__construct($message, $code, $previous);
        $this->details = $details;
    }

    public function getDetails(): array
    {
        return $this->details;
    }
}
