<?php

namespace Halk\Core;

/**
 * Halk signal handler.
 *
 * PHP version 5.3
 *
 * @category   PHP
 * @package    Halk
 * @subpackage Core
 * @author     Kolombet Ivan <i.kolombet@hoster.ru>
 * @copyright  2011 Filanco
 * @license    Proprietary http://www.filanco.ru
 * @version    SVN: $Id: SignalHandler.php 10844 2012-03-31 12:08:57Z i.kolombet $
 * @link       http://halk.filanco.ru
 */
class SignalHandler extends Registry
{

    /**
     * Callback map.
     *
     * @var array
     */
    private static $__map = array();


    /**
     * Link a callback to a certain signal.
     *
     * @param string|array $input_class
     * @param integer $signal
     * @param \Closure $callback
     *
     * @return void
     */
    public static function listen($input_class, $signal, \Closure $callback)
    {

        if (is_array($input_class)) {
            foreach ($input_class as $class) {
                !isset(self::$__map[$class]) && self::$__map[$class] = array();
                !isset(self::$__map[$class][$signal]) && self::$__map[$class][$signal] = array();
                self::$__map[$class][$signal][] = $callback;
            }

        } else {
            $class = $input_class;
            !isset(self::$__map[$class]) && self::$__map[$class] = array();
            !isset(self::$__map[$class][$signal]) && self::$__map[$class][$signal] = array();
            self::$__map[$class][$signal][] = $callback;
        }

    }//end listen()

    public static function clear()
    {
        self::$__map = array();
    }

    /**
     * Signal processing.
     *
     * @param Basic $dispatcher
     * @param int $signal
     *
     * @param null $args
     *
     * @return void
     */
    public static function handleSignal(Basic $dispatcher, $signal, $args = null)
    {

        foreach (self::$__map as $class => $subscribers) {
            if ($dispatcher instanceof $class) {
                if (isset($subscribers[$signal])) {
                    foreach ($subscribers[$signal] as $callback) {
                        $callback($dispatcher, $args, $signal);
                    }
                }
            }
        }
    }

}//end class
