<?php

/**
 * Smarty modifier plugin
 *
 * Type: modifier<br>
 * Example: {$count|plural:'штука':'штуки':'штук'}
 * если $count=1, то выводится штука
 * если $count=2, то выводится штуки
 * если $count=6, то выводится штук
 * @param string
 * @param string
 * @return string
 * @version  1.0
 */
function smarty_modifier_plural($count, ...$endings): string
{
    $cases = [2, 0, 1, 1, 1, 2];
    return $endings[($count % 100 > 4 && $count % 100 < 20) ? 2 : $cases[min($count % 10, 5)]];
}
