<?php
/**
* Smarty Internal Plugin Templateparser
*
* This is the template parser.
* It is generated from the internal.templateparser.y file
* @package Smarty
* @subpackage Compiler
* @author Uwe Tews
*/

class TP_yyToken implements ArrayAccess
{
    public $string = '';
    public $metadata = array();

    function __construct($s, $m = array())
    {
        if ($s instanceof TP_yyToken) {
            $this->string = $s->string;
            $this->metadata = $s->metadata;
        } else {
            $this->string = (string) $s;
            if ($m instanceof TP_yyToken) {
                $this->metadata = $m->metadata;
            } elseif (is_array($m)) {
                $this->metadata = $m;
            }
        }
    }

    function __toString()
    {
        return $this->_string;
    }

    function offsetExists($offset): bool
    {
        return isset($this->metadata[$offset]);
    }

    function offsetGet($offset): mixed
    {
        return $this->metadata[$offset];
    }

    function offsetSet($offset, $value): void
    {
        if ($offset === null) {
            if (isset($value[0])) {
                $x = ($value instanceof TP_yyToken) ?
                    $value->metadata : $value;
                $this->metadata = array_merge($this->metadata, $x);
                return;
            }
            $offset = count($this->metadata);
        }
        if ($value === null) {
            return;
        }
        if ($value instanceof TP_yyToken) {
            if ($value->metadata) {
                $this->metadata[$offset] = $value->metadata;
            }
        } elseif ($value) {
            $this->metadata[$offset] = $value;
        }
    }

    function offsetUnset($offset): void
    {
        unset($this->metadata[$offset]);
    }
}

class TP_yyStackEntry
{
    public $stateno;       /* The state-number */
    public $major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
    public $minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};


#line 12 "smarty_internal_templateparser.y"
class Smarty_Internal_Templateparser#line 79 "smarty_internal_templateparser.php"
{
#line 14 "smarty_internal_templateparser.y"

    const Err1 = "Security error: Call to private object member not allowed";
    const Err2 = "Security error: Call to dynamic object member not allowed";
    const Err3 = "PHP in template not allowed. Use SmartyBC to enable it";
    // states whether the parse was successful or not
    public $successful = true;
    public $retvalue = 0;
    private $lex;
    private $internalError = false;
    private $strip = false;

    function __construct($lex, $compiler) {
        $this->lex = $lex;
        $this->compiler = $compiler;
        $this->smarty = $this->compiler->smarty;
        $this->template = $this->compiler->template;
        $this->compiler->has_variable_string = false;
        $this->compiler->prefix_code = array();
        $this->prefix_number = 0;
        $this->block_nesting_level = 0;
        if ($this->security = isset($this->smarty->security_policy)) {
            $this->php_handling = $this->smarty->security_policy->php_handling;
        } else {
            $this->php_handling = $this->smarty->php_handling;
        }
        $this->is_xml = false;
        $this->asp_tags = (ini_get('asp_tags') != '0');
        $this->current_buffer = $this->root_buffer = new _smarty_template_buffer($this);
    }

    public static function escape_start_tag($tag_text) {
        $tag = preg_replace('/\A<\?(.*)\z/', '<<?php ?>?\1', $tag_text, -1 , $count); //Escape tag
        return $tag;
    }

    public static function escape_end_tag($tag_text) {
        return '?<?php ?>>';
    }

    public function compileVariable($variable) {
        if (strpos($variable,'(') == 0) {
            // not a variable variable
            $var = trim($variable,'\'');
            $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable($var, null, true, false)->nocache;
            $this->template->properties['variables'][$var] = $this->compiler->tag_nocache|$this->compiler->nocache;
        }
        //return '(isset($_smarty_tpl->tpl_vars['. $variable .'])?$_smarty_tpl->tpl_vars['. $variable .']->value:$_smarty_tpl->getVariable('. $variable .')->value)';
        return '$_smarty_tpl->tpl_vars['. $variable .']->value';
    }
#line 132 "smarty_internal_templateparser.php"

    const TP_VERT                           =  1;
    const TP_COLON                          =  2;
    const TP_COMMENT                        =  3;
    const TP_PHPSTARTTAG                    =  4;
    const TP_PHPENDTAG                      =  5;
    const TP_ASPSTARTTAG                    =  6;
    const TP_ASPENDTAG                      =  7;
    const TP_FAKEPHPSTARTTAG                =  8;
    const TP_XMLTAG                         =  9;
    const TP_TEXT                           = 10;
    const TP_STRIPON                        = 11;
    const TP_STRIPOFF                       = 12;
    const TP_LITERALSTART                   = 13;
    const TP_LITERALEND                     = 14;
    const TP_LITERAL                        = 15;
    const TP_LDEL                           = 16;
    const TP_RDEL                           = 17;
    const TP_DOLLAR                         = 18;
    const TP_ID                             = 19;
    const TP_EQUAL                          = 20;
    const TP_PTR                            = 21;
    const TP_LDELIF                         = 22;
    const TP_LDELFOR                        = 23;
    const TP_SEMICOLON                      = 24;
    const TP_INCDEC                         = 25;
    const TP_TO                             = 26;
    const TP_STEP                           = 27;
    const TP_LDELFOREACH                    = 28;
    const TP_SPACE                          = 29;
    const TP_AS                             = 30;
    const TP_APTR                           = 31;
    const TP_LDELSETFILTER                  = 32;
    const TP_SMARTYBLOCKCHILD               = 33;
    const TP_LDELSLASH                      = 34;
    const TP_ATTR                           = 35;
    const TP_INTEGER                        = 36;
    const TP_COMMA                          = 37;
    const TP_OPENP                          = 38;
    const TP_CLOSEP                         = 39;
    const TP_MATH                           = 40;
    const TP_UNIMATH                        = 41;
    const TP_ANDSYM                         = 42;
    const TP_ISIN                           = 43;
    const TP_ISDIVBY                        = 44;
    const TP_ISNOTDIVBY                     = 45;
    const TP_ISEVEN                         = 46;
    const TP_ISNOTEVEN                      = 47;
    const TP_ISEVENBY                       = 48;
    const TP_ISNOTEVENBY                    = 49;
    const TP_ISODD                          = 50;
    const TP_ISNOTODD                       = 51;
    const TP_ISODDBY                        = 52;
    const TP_ISNOTODDBY                     = 53;
    const TP_INSTANCEOF                     = 54;
    const TP_QMARK                          = 55;
    const TP_NOT                            = 56;
    const TP_TYPECAST                       = 57;
    const TP_HEX                            = 58;
    const TP_DOT                            = 59;
    const TP_SINGLEQUOTESTRING              = 60;
    const TP_DOUBLECOLON                    = 61;
    const TP_AT                             = 62;
    const TP_HATCH                          = 63;
    const TP_OPENB                          = 64;
    const TP_CLOSEB                         = 65;
    const TP_EQUALS                         = 66;
    const TP_NOTEQUALS                      = 67;
    const TP_GREATERTHAN                    = 68;
    const TP_LESSTHAN                       = 69;
    const TP_GREATEREQUAL                   = 70;
    const TP_LESSEQUAL                      = 71;
    const TP_IDENTITY                       = 72;
    const TP_NONEIDENTITY                   = 73;
    const TP_MOD                            = 74;
    const TP_LAND                           = 75;
    const TP_LOR                            = 76;
    const TP_LXOR                           = 77;
    const TP_QUOTE                          = 78;
    const TP_BACKTICK                       = 79;
    const TP_DOLLARID                       = 80;
    const YY_NO_ACTION = 597;
    const YY_ACCEPT_ACTION = 596;
    const YY_ERROR_ACTION = 595;

    const YY_SZ_ACTTAB = 2383;
static public $yy_action = array(
 /*     0 */   225,  275,  263,  276,  259,  257,  260,  390,  356,  359,
 /*    10 */   353,  193,   18,  127,   42,  317,  381,  351,  196,  350,
 /*    20 */     6,  108,   24,   98,  128,  190,  134,  318,   41,   41,
 /*    30 */   249,  329,  231,   18,   43,   43,  317,   26,  298,   50,
 /*    40 */    47,   48,   44,   10,   13,  305,  306,   12,   11,  340,
 /*    50 */   341,   40,   20,  387,  308,  307,  309,  374,  254,  248,
 /*    60 */   252,  217,  193,  385,  291,  375,  376,  377,  373,  372,
 /*    70 */   368,  367,  369,  370,  371,  378,  379,  225,  312,  255,
 /*    80 */   225,  225,  118,    2,  207,   76,  135,  596,   95,  281,
 /*    90 */   271,  264,    2,  366,  315,  386,  461,  383,  232,  294,
 /*   100 */   303,  388,  313,  389,  227,   41,  144,  225,  461,  245,
 /*   110 */   282,   43,  218,  358,  461,  144,   50,   47,   48,   44,
 /*   120 */    10,   13,  305,  306,   12,   11,  340,  341,   40,   20,
 /*   130 */   105,  177,  522,   46,   46,   41,   19,  522,  143,  297,
 /*   140 */   325,   43,  375,  376,  377,  373,  372,  368,  367,  369,
 /*   150 */   370,  371,  378,  379,  225,  312,  293,  206,  225,  141,
 /*   160 */   124,  225,   54,  119,  123,  225,  459,   38,  173,  246,
 /*   170 */   319,  315,  386,  347,  455,  232,  294,  303,  459,  313,
 /*   180 */   139,  321,   41,   31,  459,   41,   41,    2,   43,  188,
 /*   190 */     2,   43,   43,   50,   47,   48,   44,   10,   13,  305,
 /*   200 */   306,   12,   11,  340,  341,   40,   20,  225,  136,  301,
 /*   210 */   144,  194,  350,  144,   46,  202,  206,  328,  198,  375,
 /*   220 */   376,  377,  373,  372,  368,  367,  369,  370,  371,  378,
 /*   230 */   379,   21,    9,   28,  185,   41,  318,  225,  265,  271,
 /*   240 */   264,   43,  206,   27,  173,  206,   50,   47,   48,   44,
 /*   250 */    10,   13,  305,  306,   12,   11,  340,  341,   40,   20,
 /*   260 */   225,  178,   18,  212,  330,  317,   17,   32,    8,   14,
 /*   270 */   325,  267,  375,  376,  377,  373,  372,  368,  367,  369,
 /*   280 */   370,  371,  378,  379,  136,  363,  363,  207,   41,    4,
 /*   290 */    46,    5,  131,  233,   43,   25,  186,  289,  318,   50,
 /*   300 */    47,   48,   44,   10,   13,  305,  306,   12,   11,  340,
 /*   310 */   341,   40,   20,  225,  100,  161,   18,  355,  361,  317,
 /*   320 */    26,  109,  360,  346,  325,  375,  376,  377,  373,  372,
 /*   330 */   368,  367,  369,  370,  371,  378,  379,  106,  201,  172,
 /*   340 */    25,  206,  288,   25,   18,  261,  181,  317,  325,   45,
 /*   350 */   339,  129,   50,   47,   48,   44,   10,   13,  305,  306,
 /*   360 */    12,   11,  340,  341,   40,   20,  225,  104,  162,   18,
 /*   370 */    16,  205,  317,  206,  248,  238,   43,  325,  375,  376,
 /*   380 */   377,  373,  372,  368,  367,  369,  370,  371,  378,  379,
 /*   390 */   255,  354,  243,  229,  206,  342,   18,  239,  242,  241,
 /*   400 */   248,  266,  300,  330,  240,   50,   47,   48,   44,   10,
 /*   410 */    13,  305,  306,   12,   11,  340,  341,   40,   20,  225,
 /*   420 */   165,  176,  184,   18,   18,   18,  253,  215,  251,  325,
 /*   430 */   325,  375,  376,  377,  373,  372,  368,  367,  369,  370,
 /*   440 */   371,  378,  379,  304,  268,  159,  207,  207,  247,  206,
 /*   450 */   148,   41,  195,  350,  325,   27,   33,   43,   50,   47,
 /*   460 */    48,   44,   10,   13,  305,  306,   12,   11,  340,  341,
 /*   470 */    40,   20,  163,  225,  328,  199,  133,   29,  187,   23,
 /*   480 */   250,  325,  101,  225,  375,  376,  377,  373,  372,  368,
 /*   490 */   367,  369,  370,  371,  378,  379,  225,  298,  207,  334,
 /*   500 */   225,   45,  312,  103,  299,  192,  154,  364,   18,  302,
 /*   510 */   135,  317,  285,   35,  173,  203,  320,    3,  236,    6,
 /*   520 */   108,   41,  232,  294,  303,  134,  313,   43,  130,  249,
 /*   530 */   329,  231,  250,  225,  280,   50,   47,   48,   44,   10,
 /*   540 */    13,  305,  306,   12,   11,  340,  341,   40,   20,  336,
 /*   550 */    36,  166,  212,  230,  332,  228,  338,    8,  132,  330,
 /*   560 */   325,  375,  376,  377,  373,  372,  368,  367,  369,  370,
 /*   570 */   371,  378,  379,  225,  312,  345,   37,  362,  141,  312,
 /*   580 */    94,   77,  135,  156,  236,  182,  173,  135,  122,  204,
 /*   590 */   315,  386,  365,  225,  232,  294,  303,  137,  313,  232,
 /*   600 */   294,  303,  125,  313,   41,  222,  333,  180,  277,  337,
 /*   610 */    43,  225,   50,   47,   48,   44,   10,   13,  305,  306,
 /*   620 */    12,   11,  340,  341,   40,   20,  136,  335,  316,    5,
 /*   630 */    22,  197,  269,   34,  173,  148,  126,  116,  375,  376,
 /*   640 */   377,  373,  372,  368,  367,  369,  370,  371,  378,  379,
 /*   650 */   225,  312,  298,  225,  292,  141,  312,  258,   77,  135,
 /*   660 */   153,  183,  318,  301,  135,  175,  284,  315,  386,  461,
 /*   670 */   117,  232,  294,  303,  325,  313,  232,  294,  303,  382,
 /*   680 */   313,  461,  220,  110,  329,  298,  318,  461,  329,   50,
 /*   690 */    47,   48,   44,   10,   13,  305,  306,   12,   11,  340,
 /*   700 */   341,   40,   20,  225,   30,  191,   46,  189,  314,  107,
 /*   710 */   329,  329,  146,   97,  102,  375,  376,  377,  373,  372,
 /*   720 */   368,  367,  369,  370,  371,  378,  379,  298,  298,  298,
 /*   730 */   329,  329,  329,  329,  329,  329,  329,  329,  329,  329,
 /*   740 */   329,  329,   50,   47,   48,   44,   10,   13,  305,  306,
 /*   750 */    12,   11,  340,  341,   40,   20,  225,  329,  329,  329,
 /*   760 */   329,  329,  329,  329,  329,  114,  160,  115,  375,  376,
 /*   770 */   377,  373,  372,  368,  367,  369,  370,  371,  378,  379,
 /*   780 */   298,  298,  298,  329,  329,  329,  329,  329,  329,  329,
 /*   790 */   329,  329,  329,  329,  283,   50,   47,   48,   44,   10,
 /*   800 */    13,  305,  306,   12,   11,  340,  341,   40,   20,  329,
 /*   810 */   225,  329,  329,  329,  329,  329,  329,  329,  329,  329,
 /*   820 */   329,  375,  376,  377,  373,  372,  368,  367,  369,  370,
 /*   830 */   371,  378,  379,  200,  329,  329,  329,  329,  329,  329,
 /*   840 */   329,  329,  329,  329,  329,  329,  329,  329,  329,   50,
 /*   850 */    47,   48,   44,   10,   13,  305,  306,   12,   11,  340,
 /*   860 */   341,   40,   20,  225,  329,  329,  329,  329,  329,  329,
 /*   870 */   329,  329,  329,  329,  329,  375,  376,  377,  373,  372,
 /*   880 */   368,  367,  369,  370,  371,  378,  379,  329,  329,  329,
 /*   890 */   329,  329,  329,  329,  329,  329,  329,  329,  329,  329,
 /*   900 */   329,  329,   50,   47,   48,   44,   10,   13,  305,  306,
 /*   910 */    12,   11,  340,  341,   40,   20,  329,  329,  329,  329,
 /*   920 */   329,  329,  329,  329,  329,  329,  329,  290,  375,  376,
 /*   930 */   377,  373,  372,  368,  367,  369,  370,  371,  378,  379,
 /*   940 */   225,  312,  329,  225,  329,  141,  312,  329,   77,  135,
 /*   950 */   152,  329,  329,  329,  135,  158,  208,  315,  386,  458,
 /*   960 */   329,  232,  294,  303,  325,  313,  232,  294,  303,  329,
 /*   970 */   313,  458,  223,  329,  329,  329,  318,  458,  329,   50,
 /*   980 */    47,   48,   44,   10,   13,  305,  306,   12,   11,  340,
 /*   990 */   341,   40,   20,  225,  329,  329,   46,  329,  329,  329,
 /*  1000 */   329,  329,  329,  329,  329,  375,  376,  377,  373,  372,
 /*  1010 */   368,  367,  369,  370,  371,  378,  379,  329,  329,  329,
 /*  1020 */   329,  329,  329,  329,  329,  329,  329,  329,  329,  329,
 /*  1030 */   329,  329,   50,   47,   48,   44,   10,   13,  305,  306,
 /*  1040 */    12,   11,  340,  341,   40,   20,  329,  329,  329,  329,
 /*  1050 */   329,  329,  329,  329,  329,  329,  329,  329,  375,  376,
 /*  1060 */   377,  373,  372,  368,  367,  369,  370,  371,  378,  379,
 /*  1070 */   329,  329,  329,   50,   47,   48,   44,   10,   13,  305,
 /*  1080 */   306,   12,   11,  340,  341,   40,   20,  329,  329,  329,
 /*  1090 */   329,  329,  329,  329,  329,  329,  329,  329,  329,  375,
 /*  1100 */   376,  377,  373,  372,  368,  367,  369,  370,  371,  378,
 /*  1110 */   379,  329,  329,  329,  329,  329,   42,  329,  145,  211,
 /*  1120 */   329,  329,    6,  108,  329,  279,  329,  312,  134,  329,
 /*  1130 */   329,  150,  249,  329,  231,  135,  235,   41,   39,  329,
 /*  1140 */   329,   52,  329,   43,  311,  329,  312,  232,  294,  303,
 /*  1150 */   147,  313,  329,  170,  135,  329,   51,   49,  331,  237,
 /*  1160 */   296,  329,  325,  106,    1,  278,  232,  294,  303,  329,
 /*  1170 */   313,  155,  329,   42,  318,  145,  216,  329,   96,    6,
 /*  1180 */   108,   18,  329,  226,  317,  134,  329,  313,  329,  249,
 /*  1190 */   329,  231,  329,  235,   41,   39,  256,  329,   52,  329,
 /*  1200 */    43,  329,  312,  329,  329,  329,  141,  329,  329,   66,
 /*  1210 */   119,  238,  329,   51,   49,  331,  237,  296,  315,  386,
 /*  1220 */   106,    1,  232,  294,  303,  329,  313,  270,  329,  329,
 /*  1230 */    42,  329,  140,   92,  329,   96,    6,  108,   18,   41,
 /*  1240 */   169,  317,  134,  329,  273,   43,  249,  329,  231,  325,
 /*  1250 */   235,   41,   39,  244,  329,   52,   41,   43,  329,  312,
 /*  1260 */   329,  318,   43,  141,  329,  329,   67,  135,  225,  329,
 /*  1270 */    51,   49,  331,  237,  296,  315,  386,  106,    1,  224,
 /*  1280 */   294,  303,  329,  313,  310,  329,  329,   42,  329,  145,
 /*  1290 */   213,  329,   96,    6,  108,  329,   41,  329,  329,  134,
 /*  1300 */   329,  323,   43,  249,  329,  231,  329,  235,  329,   39,
 /*  1310 */   329,  329,   52,   41,  329,  329,  312,  329,  329,   43,
 /*  1320 */   141,   46,  329,   86,  135,  329,  329,   51,   49,  331,
 /*  1330 */   237,  296,  315,  386,  106,    1,  232,  294,  303,  329,
 /*  1340 */   313,  274,  329,  329,   42,  329,  142,  216,  329,   96,
 /*  1350 */     6,  108,  329,   41,  329,  329,  134,  329,  348,   43,
 /*  1360 */   249,  329,  231,  329,  235,  329,    7,  329,  329,   52,
 /*  1370 */    41,  329,  329,  312,  329,  329,   43,  141,  329,  329,
 /*  1380 */    90,  135,  329,  329,   51,   49,  331,  237,  296,  315,
 /*  1390 */   386,  106,    1,  232,  294,  303,  329,  313,  295,  329,
 /*  1400 */   329,   42,  329,  138,  216,  329,   96,    6,  108,  329,
 /*  1410 */    41,  329,  329,  134,  329,  322,   43,  249,  329,  231,
 /*  1420 */   329,  235,  329,   39,  329,  329,   52,   41,  329,  329,
 /*  1430 */   312,  329,  329,   43,  141,  329,  329,   87,  135,  329,
 /*  1440 */   329,   51,   49,  331,  237,  296,  315,  386,  106,    1,
 /*  1450 */   232,  294,  303,  329,  313,  384,  329,  329,   42,  329,
 /*  1460 */   131,  216,  329,   96,    6,  108,  329,   41,  329,  329,
 /*  1470 */   134,  329,  380,   43,  249,  329,  231,  329,  235,  329,
 /*  1480 */    15,  329,  329,   52,   41,  329,  329,  312,  329,  329,
 /*  1490 */    43,  141,  329,  329,   79,  135,  329,  329,   51,   49,
 /*  1500 */   331,  237,  296,  315,  386,  106,    1,  232,  294,  303,
 /*  1510 */   329,  313,  272,  329,  329,   42,  329,  145,  210,  329,
 /*  1520 */    96,    6,  108,  329,   41,  329,  329,  134,  329,  349,
 /*  1530 */    43,  249,  329,  231,  329,  221,  329,   39,  329,  329,
 /*  1540 */    52,   41,  329,  329,  312,  329,  329,   43,  141,  329,
 /*  1550 */   329,   70,  135,  329,  329,   51,   49,  331,  237,  296,
 /*  1560 */   315,  386,  106,    1,  232,  294,  303,  329,  313,  324,
 /*  1570 */   329,  329,   42,  329,  145,  209,  329,   96,    6,  108,
 /*  1580 */   329,   41,  329,  329,  134,  329,  326,   43,  249,  329,
 /*  1590 */   231,  329,  235,  329,   39,  329,  329,   52,   41,  329,
 /*  1600 */   329,  312,  329,  329,   43,  141,  329,  329,   74,  135,
 /*  1610 */   329,  329,   51,   49,  331,  237,  296,  315,  386,  106,
 /*  1620 */     1,  232,  294,  303,  329,  313,  262,  329,  329,   42,
 /*  1630 */   329,  131,  214,  329,   96,    6,  108,  329,   41,  329,
 /*  1640 */   329,  134,  329,  327,   43,  249,  329,  231,  329,  235,
 /*  1650 */   329,   15,  329,  329,   52,   41,  329,  329,  312,  329,
 /*  1660 */   329,   43,  141,  329,  329,   53,  135,  329,  329,   51,
 /*  1670 */    49,  331,  237,  296,  315,  386,  106,  329,  232,  294,
 /*  1680 */   303,  329,  313,  286,  329,  329,   42,  329,  131,  216,
 /*  1690 */   329,   96,    6,  108,  329,   41,  329,  329,  134,  329,
 /*  1700 */   343,   43,  249,  329,  231,  329,  235,  329,   15,  329,
 /*  1710 */   329,   52,   41,  329,  329,  312,  329,  329,   43,  118,
 /*  1720 */   329,  329,   76,  135,  329,  329,   51,   49,  331,  237,
 /*  1730 */   296,  315,  386,  106,  329,  232,  294,  303,  329,  313,
 /*  1740 */   329,  329,  329,  329,  504,  329,  329,  329,   96,  329,
 /*  1750 */   357,  504,  329,  504,  504,  364,  504,  504,  329,  329,
 /*  1760 */   329,   35,  504,  329,  504,    2,  504,    6,  108,  329,
 /*  1770 */   198,  174,  329,  134,  329,  329,  329,  249,  329,  231,
 /*  1780 */   325,  504,  329,   21,    9,  329,  329,  329,  144,  329,
 /*  1790 */   329,  329,  504,  329,  312,   99,  179,  206,  141,  329,
 /*  1800 */   329,   58,  135,  329,  329,  325,  504,  329,   21,    9,
 /*  1810 */   315,  386,  329,  312,  232,  294,  303,  141,  313,  329,
 /*  1820 */    71,  135,  206,  344,   37,  362,  329,  329,  329,  315,
 /*  1830 */   386,  329,  329,  232,  294,  303,  312,  313,  329,  329,
 /*  1840 */   141,  329,  329,   72,  135,  329,  329,  312,  329,  329,
 /*  1850 */   329,  141,  315,  386,   65,  135,  232,  294,  303,  329,
 /*  1860 */   313,  329,  329,  315,  386,  329,  329,  232,  294,  303,
 /*  1870 */   329,  313,  329,  329,  312,  198,  167,  329,  141,  329,
 /*  1880 */   329,   69,  135,  329,  329,  325,  329,  329,   21,    9,
 /*  1890 */   315,  386,  329,  329,  232,  294,  303,  312,  313,  329,
 /*  1900 */   329,  141,  206,  329,   85,  135,  329,  312,  329,  329,
 /*  1910 */   329,  149,  329,  315,  386,  135,  312,  232,  294,  303,
 /*  1920 */   141,  313,  329,   81,  135,  329,  329,  232,  294,  303,
 /*  1930 */   329,  313,  315,  386,  329,  329,  232,  294,  303,  312,
 /*  1940 */   313,  329,  329,  141,  329,  329,   82,  135,  329,  329,
 /*  1950 */   312,  329,  329,  329,  141,  315,  386,   63,  135,  232,
 /*  1960 */   294,  303,  329,  313,  329,  329,  315,  386,  329,  329,
 /*  1970 */   232,  294,  303,  329,  313,  329,  312,  329,  329,  329,
 /*  1980 */   141,  329,  329,   73,  135,  329,  329,  312,  329,  329,
 /*  1990 */   329,  141,  315,  386,   83,  135,  232,  294,  303,  329,
 /*  2000 */   313,  329,  329,  315,  386,  329,  312,  232,  294,  303,
 /*  2010 */   141,  313,  329,   89,  135,  329,  329,  329,  329,  329,
 /*  2020 */   329,  329,  315,  386,  329,  312,  232,  294,  303,  111,
 /*  2030 */   313,  329,   68,  135,  329,  329,  312,  329,  329,  329,
 /*  2040 */   141,  315,  386,   62,  135,  232,  294,  303,  329,  313,
 /*  2050 */   329,  329,  315,  386,  329,  329,  232,  294,  303,  329,
 /*  2060 */   313,  329,  312,  329,  329,  329,  141,  329,  329,   61,
 /*  2070 */   135,  329,  329,  312,  329,  329,  329,  141,  315,  386,
 /*  2080 */    91,  135,  232,  294,  303,  329,  313,  329,  329,  315,
 /*  2090 */   386,  329,  312,  232,  294,  303,  141,  313,  329,   78,
 /*  2100 */   135,  329,  329,  329,  329,  329,  329,  329,  315,  386,
 /*  2110 */   329,  312,  232,  294,  303,  141,  313,  329,   66,  135,
 /*  2120 */   329,  329,  312,  329,  329,  329,  141,  315,  386,   80,
 /*  2130 */   135,  232,  294,  303,  329,  313,  329,  329,  315,  386,
 /*  2140 */   329,  329,  232,  294,  303,  329,  313,  329,  312,  329,
 /*  2150 */   329,  329,  113,  329,  329,   88,  135,  329,  329,  312,
 /*  2160 */   329,  329,  329,  112,  315,  386,   84,  135,  232,  294,
 /*  2170 */   303,  329,  313,  329,  329,  315,  386,  329,  312,  232,
 /*  2180 */   294,  303,  141,  313,  329,   57,  135,  329,  329,  329,
 /*  2190 */   329,  329,  329,  329,  315,  386,  329,  312,  232,  294,
 /*  2200 */   303,   93,  313,  329,   59,  121,  329,  329,  312,  329,
 /*  2210 */   329,  329,  141,  315,  386,   75,  135,  232,  294,  303,
 /*  2220 */   329,  313,  329,  329,  315,  386,  329,  329,  232,  294,
 /*  2230 */   303,  329,  313,  329,  312,  329,  329,  329,  141,  329,
 /*  2240 */   329,   60,  135,  329,  329,  312,  329,  329,  329,  141,
 /*  2250 */   315,  386,   64,  135,  232,  294,  303,  329,  313,  329,
 /*  2260 */   329,  315,  386,  329,  312,  232,  294,  303,  120,  313,
 /*  2270 */   329,   55,  135,  329,  329,  329,  329,  329,  329,  329,
 /*  2280 */   315,  386,  329,  312,  232,  294,  303,   93,  313,  329,
 /*  2290 */    56,  121,  225,  329,  312,  329,  198,  164,  157,  315,
 /*  2300 */   386,  329,  135,  219,  294,  303,  325,  313,  352,   21,
 /*  2310 */     9,  287,  234,  329,  232,  294,  303,  329,  313,  329,
 /*  2320 */    41,  329,  329,  206,  312,  329,   43,  329,  151,    2,
 /*  2330 */   329,  329,  135,  329,  329,  329,  329,  329,  329,  329,
 /*  2340 */   198,  168,  329,  329,  232,  294,  303,  329,  313,  329,
 /*  2350 */   325,  329,  144,   21,    9,  198,  171,  329,  329,  329,
 /*  2360 */   329,  329,  329,  329,  329,  325,  329,  206,   21,    9,
 /*  2370 */   329,  329,  329,  329,  329,  329,  329,  329,  329,  329,
 /*  2380 */   329,  329,  206,
    );
    static public $yy_lookahead = array(
 /*     0 */     1,    3,    4,    5,    6,    7,    8,    9,   10,   11,
 /*    10 */    12,   13,   16,   98,   16,   19,   17,   17,  113,  114,
 /*    20 */    22,   23,   16,   97,   18,   19,   28,  112,   29,   29,
 /*    30 */    32,   33,   34,   16,   35,   35,   19,   20,  112,   40,
 /*    40 */    41,   42,   43,   44,   45,   46,   47,   48,   49,   50,
 /*    50 */    51,   52,   53,    4,    5,    6,    7,    8,   62,   93,
 /*    60 */    94,   95,   13,   14,   15,   66,   67,   68,   69,   70,
 /*    70 */    71,   72,   73,   74,   75,   76,   77,    1,   85,   62,
 /*    80 */     1,    1,   89,   38,  117,   92,   93,   82,   83,   84,
 /*    90 */    85,   86,   38,   17,  101,  102,   17,   17,  105,  106,
 /*   100 */   107,   86,  109,   88,   59,   29,   61,    1,   29,   30,
 /*   110 */    65,   35,  119,  120,   35,   61,   40,   41,   42,   43,
 /*   120 */    44,   45,   46,   47,   48,   49,   50,   51,   52,   53,
 /*   130 */    90,   91,   59,   54,   54,   29,   16,   64,   18,   19,
 /*   140 */   100,   35,   66,   67,   68,   69,   70,   71,   72,   73,
 /*   150 */    74,   75,   76,   77,    1,   85,   36,  117,    1,   89,
 /*   160 */    18,    1,   92,   93,   94,    1,   17,   20,   21,   20,
 /*   170 */    17,  101,  102,   17,   17,  105,  106,  107,   29,  109,
 /*   180 */    38,   17,   29,   31,   35,   29,   29,   38,   35,   90,
 /*   190 */    38,   35,   35,   40,   41,   42,   43,   44,   45,   46,
 /*   200 */    47,   48,   49,   50,   51,   52,   53,    1,   61,  111,
 /*   210 */    61,  113,  114,   61,   54,   90,  117,  118,   90,   66,
 /*   220 */    67,   68,   69,   70,   71,   72,   73,   74,   75,   76,
 /*   230 */    77,  103,  104,   27,  110,   29,  112,    1,   84,   85,
 /*   240 */    86,   35,  117,   20,   21,  117,   40,   41,   42,   43,
 /*   250 */    44,   45,   46,   47,   48,   49,   50,   51,   52,   53,
 /*   260 */     1,   91,   16,   59,   25,   19,   20,   31,   64,   16,
 /*   270 */   100,   25,   66,   67,   68,   69,   70,   71,   72,   73,
 /*   280 */    74,   75,   76,   77,   61,   85,   85,  117,   29,   37,
 /*   290 */    54,   38,   18,   19,   35,   37,  110,   39,  112,   40,
 /*   300 */    41,   42,   43,   44,   45,   46,   47,   48,   49,   50,
 /*   310 */    51,   52,   53,    1,   90,   91,   16,   65,   79,   19,
 /*   320 */    20,  121,  122,  122,  100,   66,   67,   68,   69,   70,
 /*   330 */    71,   72,   73,   74,   75,   76,   77,   63,   24,   91,
 /*   340 */    37,  117,   39,   37,   16,   39,   90,   19,  100,    2,
 /*   350 */    19,   37,   40,   41,   42,   43,   44,   45,   46,   47,
 /*   360 */    48,   49,   50,   51,   52,   53,    1,   90,   91,   16,
 /*   370 */    29,   19,   19,  117,   93,   94,   35,  100,   66,   67,
 /*   380 */    68,   69,   70,   71,   72,   73,   74,   75,   76,   77,
 /*   390 */    62,   79,   96,   62,  117,   17,   16,   18,   19,   19,
 /*   400 */    93,   94,   19,   25,   39,   40,   41,   42,   43,   44,
 /*   410 */    45,   46,   47,   48,   49,   50,   51,   52,   53,    1,
 /*   420 */    91,   91,   90,   16,   16,   16,   19,   19,   19,  100,
 /*   430 */   100,   66,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   440 */    75,   76,   77,  108,   29,   91,  117,  117,   30,  117,
 /*   450 */   115,   29,  113,  114,  100,   20,   96,   35,   40,   41,
 /*   460 */    42,   43,   44,   45,   46,   47,   48,   49,   50,   51,
 /*   470 */    52,   53,   91,    1,  118,   99,   18,   26,  110,   20,
 /*   480 */     2,  100,   97,    1,   66,   67,   68,   69,   70,   71,
 /*   490 */    72,   73,   74,   75,   76,   77,    1,  112,  117,   17,
 /*   500 */     1,    2,   85,   99,   19,  110,   89,   10,   16,   19,
 /*   510 */    93,   19,   17,   16,   21,   99,   17,   38,   59,   22,
 /*   520 */    23,   29,  105,  106,  107,   28,  109,   35,   18,   32,
 /*   530 */    33,   34,    2,    1,   65,   40,   41,   42,   43,   44,
 /*   540 */    45,   46,   47,   48,   49,   50,   51,   52,   53,   17,
 /*   550 */    20,   91,   59,   21,   36,   19,   19,   64,   19,   25,
 /*   560 */   100,   66,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   570 */    75,   76,   77,    1,   85,   78,   79,   80,   89,   85,
 /*   580 */    19,   92,   93,   89,   59,   63,   21,   93,   19,   17,
 /*   590 */   101,  102,   17,    1,  105,  106,  107,   18,  109,  105,
 /*   600 */   106,  107,   18,  109,   29,  116,   36,   63,   19,   17,
 /*   610 */    35,    1,   40,   41,   42,   43,   44,   45,   46,   47,
 /*   620 */    48,   49,   50,   51,   52,   53,   61,   17,  108,   38,
 /*   630 */     2,   19,   39,   55,   21,  115,   18,   97,   66,   67,
 /*   640 */    68,   69,   70,   71,   72,   73,   74,   75,   76,   77,
 /*   650 */     1,   85,  112,    1,  100,   89,   85,  115,   92,   93,
 /*   660 */    89,  110,  112,  111,   93,   91,   17,  101,  102,   17,
 /*   670 */    97,  105,  106,  107,  100,  109,  105,  106,  107,   14,
 /*   680 */   109,   29,  116,   87,  123,  112,  112,   35,  123,   40,
 /*   690 */    41,   42,   43,   44,   45,   46,   47,   48,   49,   50,
 /*   700 */    51,   52,   53,    1,    2,  110,   54,  110,  114,  110,
 /*   710 */   123,  123,   97,   97,   97,   66,   67,   68,   69,   70,
 /*   720 */    71,   72,   73,   74,   75,   76,   77,  112,  112,  112,
 /*   730 */   123,  123,  123,  123,  123,  123,  123,  123,  123,  123,
 /*   740 */   123,  123,   40,   41,   42,   43,   44,   45,   46,   47,
 /*   750 */    48,   49,   50,   51,   52,   53,    1,  123,  123,  123,
 /*   760 */   123,  123,  123,  123,  123,   97,   97,   97,   66,   67,
 /*   770 */    68,   69,   70,   71,   72,   73,   74,   75,   76,   77,
 /*   780 */   112,  112,  112,  123,  123,  123,  123,  123,  123,  123,
 /*   790 */   123,  123,  123,  123,   39,   40,   41,   42,   43,   44,
 /*   800 */    45,   46,   47,   48,   49,   50,   51,   52,   53,  123,
 /*   810 */     1,  123,  123,  123,  123,  123,  123,  123,  123,  123,
 /*   820 */   123,   66,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   830 */    75,   76,   77,   24,  123,  123,  123,  123,  123,  123,
 /*   840 */   123,  123,  123,  123,  123,  123,  123,  123,  123,   40,
 /*   850 */    41,   42,   43,   44,   45,   46,   47,   48,   49,   50,
 /*   860 */    51,   52,   53,    1,  123,  123,  123,  123,  123,  123,
 /*   870 */   123,  123,  123,  123,  123,   66,   67,   68,   69,   70,
 /*   880 */    71,   72,   73,   74,   75,   76,   77,  123,  123,  123,
 /*   890 */   123,  123,  123,  123,  123,  123,  123,  123,  123,  123,
 /*   900 */   123,  123,   40,   41,   42,   43,   44,   45,   46,   47,
 /*   910 */    48,   49,   50,   51,   52,   53,  123,  123,  123,  123,
 /*   920 */   123,  123,  123,  123,  123,  123,  123,   65,   66,   67,
 /*   930 */    68,   69,   70,   71,   72,   73,   74,   75,   76,   77,
 /*   940 */     1,   85,  123,    1,  123,   89,   85,  123,   92,   93,
 /*   950 */    89,  123,  123,  123,   93,   91,   17,  101,  102,   17,
 /*   960 */   123,  105,  106,  107,  100,  109,  105,  106,  107,  123,
 /*   970 */   109,   29,  116,  123,  123,  123,  112,   35,  123,   40,
 /*   980 */    41,   42,   43,   44,   45,   46,   47,   48,   49,   50,
 /*   990 */    51,   52,   53,    1,  123,  123,   54,  123,  123,  123,
 /*  1000 */   123,  123,  123,  123,  123,   66,   67,   68,   69,   70,
 /*  1010 */    71,   72,   73,   74,   75,   76,   77,  123,  123,  123,
 /*  1020 */   123,  123,  123,  123,  123,  123,  123,  123,  123,  123,
 /*  1030 */   123,  123,   40,   41,   42,   43,   44,   45,   46,   47,
 /*  1040 */    48,   49,   50,   51,   52,   53,  123,  123,  123,  123,
 /*  1050 */   123,  123,  123,  123,  123,  123,  123,  123,   66,   67,
 /*  1060 */    68,   69,   70,   71,   72,   73,   74,   75,   76,   77,
 /*  1070 */   123,  123,  123,   40,   41,   42,   43,   44,   45,   46,
 /*  1080 */    47,   48,   49,   50,   51,   52,   53,  123,  123,  123,
 /*  1090 */   123,  123,  123,  123,  123,  123,  123,  123,  123,   66,
 /*  1100 */    67,   68,   69,   70,   71,   72,   73,   74,   75,   76,
 /*  1110 */    77,  123,  123,  123,  123,  123,   16,  123,   18,   19,
 /*  1120 */   123,  123,   22,   23,  123,   17,  123,   85,   28,  123,
 /*  1130 */   123,   89,   32,   33,   34,   93,   36,   29,   38,  123,
 /*  1140 */   123,   41,  123,   35,  102,  123,   85,  105,  106,  107,
 /*  1150 */    89,  109,  123,   91,   93,  123,   56,   57,   58,   59,
 /*  1160 */    60,  123,  100,   63,   64,   65,  105,  106,  107,  123,
 /*  1170 */   109,   93,  123,   16,  112,   18,   19,  123,   78,   22,
 /*  1180 */    23,   16,  123,  105,   19,   28,  123,  109,  123,   32,
 /*  1190 */    33,   34,  123,   36,   29,   38,   31,  123,   41,  123,
 /*  1200 */    35,  123,   85,  123,  123,  123,   89,  123,  123,   92,
 /*  1210 */    93,   94,  123,   56,   57,   58,   59,   60,  101,  102,
 /*  1220 */    63,   64,  105,  106,  107,  123,  109,   17,  123,  123,
 /*  1230 */    16,  123,   18,   19,  123,   78,   22,   23,   16,   29,
 /*  1240 */    91,   19,   28,  123,   17,   35,   32,   33,   34,  100,
 /*  1250 */    36,   29,   38,   31,  123,   41,   29,   35,  123,   85,
 /*  1260 */   123,  112,   35,   89,  123,  123,   92,   93,    1,  123,
 /*  1270 */    56,   57,   58,   59,   60,  101,  102,   63,   64,  105,
 /*  1280 */   106,  107,  123,  109,   17,  123,  123,   16,  123,   18,
 /*  1290 */    19,  123,   78,   22,   23,  123,   29,  123,  123,   28,
 /*  1300 */   123,   17,   35,   32,   33,   34,  123,   36,  123,   38,
 /*  1310 */   123,  123,   41,   29,  123,  123,   85,  123,  123,   35,
 /*  1320 */    89,   54,  123,   92,   93,  123,  123,   56,   57,   58,
 /*  1330 */    59,   60,  101,  102,   63,   64,  105,  106,  107,  123,
 /*  1340 */   109,   17,  123,  123,   16,  123,   18,   19,  123,   78,
 /*  1350 */    22,   23,  123,   29,  123,  123,   28,  123,   17,   35,
 /*  1360 */    32,   33,   34,  123,   36,  123,   38,  123,  123,   41,
 /*  1370 */    29,  123,  123,   85,  123,  123,   35,   89,  123,  123,
 /*  1380 */    92,   93,  123,  123,   56,   57,   58,   59,   60,  101,
 /*  1390 */   102,   63,   64,  105,  106,  107,  123,  109,   17,  123,
 /*  1400 */   123,   16,  123,   18,   19,  123,   78,   22,   23,  123,
 /*  1410 */    29,  123,  123,   28,  123,   17,   35,   32,   33,   34,
 /*  1420 */   123,   36,  123,   38,  123,  123,   41,   29,  123,  123,
 /*  1430 */    85,  123,  123,   35,   89,  123,  123,   92,   93,  123,
 /*  1440 */   123,   56,   57,   58,   59,   60,  101,  102,   63,   64,
 /*  1450 */   105,  106,  107,  123,  109,   17,  123,  123,   16,  123,
 /*  1460 */    18,   19,  123,   78,   22,   23,  123,   29,  123,  123,
 /*  1470 */    28,  123,   17,   35,   32,   33,   34,  123,   36,  123,
 /*  1480 */    38,  123,  123,   41,   29,  123,  123,   85,  123,  123,
 /*  1490 */    35,   89,  123,  123,   92,   93,  123,  123,   56,   57,
 /*  1500 */    58,   59,   60,  101,  102,   63,   64,  105,  106,  107,
 /*  1510 */   123,  109,   17,  123,  123,   16,  123,   18,   19,  123,
 /*  1520 */    78,   22,   23,  123,   29,  123,  123,   28,  123,   17,
 /*  1530 */    35,   32,   33,   34,  123,   36,  123,   38,  123,  123,
 /*  1540 */    41,   29,  123,  123,   85,  123,  123,   35,   89,  123,
 /*  1550 */   123,   92,   93,  123,  123,   56,   57,   58,   59,   60,
 /*  1560 */   101,  102,   63,   64,  105,  106,  107,  123,  109,   17,
 /*  1570 */   123,  123,   16,  123,   18,   19,  123,   78,   22,   23,
 /*  1580 */   123,   29,  123,  123,   28,  123,   17,   35,   32,   33,
 /*  1590 */    34,  123,   36,  123,   38,  123,  123,   41,   29,  123,
 /*  1600 */   123,   85,  123,  123,   35,   89,  123,  123,   92,   93,
 /*  1610 */   123,  123,   56,   57,   58,   59,   60,  101,  102,   63,
 /*  1620 */    64,  105,  106,  107,  123,  109,   17,  123,  123,   16,
 /*  1630 */   123,   18,   19,  123,   78,   22,   23,  123,   29,  123,
 /*  1640 */   123,   28,  123,   17,   35,   32,   33,   34,  123,   36,
 /*  1650 */   123,   38,  123,  123,   41,   29,  123,  123,   85,  123,
 /*  1660 */   123,   35,   89,  123,  123,   92,   93,  123,  123,   56,
 /*  1670 */    57,   58,   59,   60,  101,  102,   63,  123,  105,  106,
 /*  1680 */   107,  123,  109,   17,  123,  123,   16,  123,   18,   19,
 /*  1690 */   123,   78,   22,   23,  123,   29,  123,  123,   28,  123,
 /*  1700 */    17,   35,   32,   33,   34,  123,   36,  123,   38,  123,
 /*  1710 */   123,   41,   29,  123,  123,   85,  123,  123,   35,   89,
 /*  1720 */   123,  123,   92,   93,  123,  123,   56,   57,   58,   59,
 /*  1730 */    60,  101,  102,   63,  123,  105,  106,  107,  123,  109,
 /*  1740 */   123,  123,  123,  123,   17,  123,  123,  123,   78,  123,
 /*  1750 */   120,   24,  123,   26,   27,   10,   29,   30,  123,  123,
 /*  1760 */   123,   16,   35,  123,   37,   38,   39,   22,   23,  123,
 /*  1770 */    90,   91,  123,   28,  123,  123,  123,   32,   33,   34,
 /*  1780 */   100,   54,  123,  103,  104,  123,  123,  123,   61,  123,
 /*  1790 */   123,  123,   65,  123,   85,   90,   91,  117,   89,  123,
 /*  1800 */   123,   92,   93,  123,  123,  100,   79,  123,  103,  104,
 /*  1810 */   101,  102,  123,   85,  105,  106,  107,   89,  109,  123,
 /*  1820 */    92,   93,  117,   78,   79,   80,  123,  123,  123,  101,
 /*  1830 */   102,  123,  123,  105,  106,  107,   85,  109,  123,  123,
 /*  1840 */    89,  123,  123,   92,   93,  123,  123,   85,  123,  123,
 /*  1850 */   123,   89,  101,  102,   92,   93,  105,  106,  107,  123,
 /*  1860 */   109,  123,  123,  101,  102,  123,  123,  105,  106,  107,
 /*  1870 */   123,  109,  123,  123,   85,   90,   91,  123,   89,  123,
 /*  1880 */   123,   92,   93,  123,  123,  100,  123,  123,  103,  104,
 /*  1890 */   101,  102,  123,  123,  105,  106,  107,   85,  109,  123,
 /*  1900 */   123,   89,  117,  123,   92,   93,  123,   85,  123,  123,
 /*  1910 */   123,   89,  123,  101,  102,   93,   85,  105,  106,  107,
 /*  1920 */    89,  109,  123,   92,   93,  123,  123,  105,  106,  107,
 /*  1930 */   123,  109,  101,  102,  123,  123,  105,  106,  107,   85,
 /*  1940 */   109,  123,  123,   89,  123,  123,   92,   93,  123,  123,
 /*  1950 */    85,  123,  123,  123,   89,  101,  102,   92,   93,  105,
 /*  1960 */   106,  107,  123,  109,  123,  123,  101,  102,  123,  123,
 /*  1970 */   105,  106,  107,  123,  109,  123,   85,  123,  123,  123,
 /*  1980 */    89,  123,  123,   92,   93,  123,  123,   85,  123,  123,
 /*  1990 */   123,   89,  101,  102,   92,   93,  105,  106,  107,  123,
 /*  2000 */   109,  123,  123,  101,  102,  123,   85,  105,  106,  107,
 /*  2010 */    89,  109,  123,   92,   93,  123,  123,  123,  123,  123,
 /*  2020 */   123,  123,  101,  102,  123,   85,  105,  106,  107,   89,
 /*  2030 */   109,  123,   92,   93,  123,  123,   85,  123,  123,  123,
 /*  2040 */    89,  101,  102,   92,   93,  105,  106,  107,  123,  109,
 /*  2050 */   123,  123,  101,  102,  123,  123,  105,  106,  107,  123,
 /*  2060 */   109,  123,   85,  123,  123,  123,   89,  123,  123,   92,
 /*  2070 */    93,  123,  123,   85,  123,  123,  123,   89,  101,  102,
 /*  2080 */    92,   93,  105,  106,  107,  123,  109,  123,  123,  101,
 /*  2090 */   102,  123,   85,  105,  106,  107,   89,  109,  123,   92,
 /*  2100 */    93,  123,  123,  123,  123,  123,  123,  123,  101,  102,
 /*  2110 */   123,   85,  105,  106,  107,   89,  109,  123,   92,   93,
 /*  2120 */   123,  123,   85,  123,  123,  123,   89,  101,  102,   92,
 /*  2130 */    93,  105,  106,  107,  123,  109,  123,  123,  101,  102,
 /*  2140 */   123,  123,  105,  106,  107,  123,  109,  123,   85,  123,
 /*  2150 */   123,  123,   89,  123,  123,   92,   93,  123,  123,   85,
 /*  2160 */   123,  123,  123,   89,  101,  102,   92,   93,  105,  106,
 /*  2170 */   107,  123,  109,  123,  123,  101,  102,  123,   85,  105,
 /*  2180 */   106,  107,   89,  109,  123,   92,   93,  123,  123,  123,
 /*  2190 */   123,  123,  123,  123,  101,  102,  123,   85,  105,  106,
 /*  2200 */   107,   89,  109,  123,   92,   93,  123,  123,   85,  123,
 /*  2210 */   123,  123,   89,  101,  102,   92,   93,  105,  106,  107,
 /*  2220 */   123,  109,  123,  123,  101,  102,  123,  123,  105,  106,
 /*  2230 */   107,  123,  109,  123,   85,  123,  123,  123,   89,  123,
 /*  2240 */   123,   92,   93,  123,  123,   85,  123,  123,  123,   89,
 /*  2250 */   101,  102,   92,   93,  105,  106,  107,  123,  109,  123,
 /*  2260 */   123,  101,  102,  123,   85,  105,  106,  107,   89,  109,
 /*  2270 */   123,   92,   93,  123,  123,  123,  123,  123,  123,  123,
 /*  2280 */   101,  102,  123,   85,  105,  106,  107,   89,  109,  123,
 /*  2290 */    92,   93,    1,  123,   85,  123,   90,   91,   89,  101,
 /*  2300 */   102,  123,   93,  105,  106,  107,  100,  109,   17,  103,
 /*  2310 */   104,  102,   21,  123,  105,  106,  107,  123,  109,  123,
 /*  2320 */    29,  123,  123,  117,   85,  123,   35,  123,   89,   38,
 /*  2330 */   123,  123,   93,  123,  123,  123,  123,  123,  123,  123,
 /*  2340 */    90,   91,  123,  123,  105,  106,  107,  123,  109,  123,
 /*  2350 */   100,  123,   61,  103,  104,   90,   91,  123,  123,  123,
 /*  2360 */   123,  123,  123,  123,  123,  100,  123,  117,  103,  104,
 /*  2370 */   123,  123,  123,  123,  123,  123,  123,  123,  123,  123,
 /*  2380 */   123,  123,  117,
);
    const YY_SHIFT_USE_DFLT = -5;
    const YY_SHIFT_MAX = 256;
    static public $yy_shift_ofst = array(
 /*     0 */    -2, 1271, 1157, 1157, 1271, 1157, 1328, 1328, 1100, 1157,
 /*    10 */  1157, 1157, 1157, 1157, 1157, 1157, 1499, 1157, 1157, 1157,
 /*    20 */  1157, 1157, 1556, 1157, 1157, 1157, 1157, 1157, 1157, 1157,
 /*    30 */  1157, 1157, 1157, 1157, 1385, 1214, 1157, 1157, 1157, 1157,
 /*    40 */  1157, 1499, 1214, 1157, 1442, 1442, 1613, 1670, 1670, 1670,
 /*    50 */  1670, 1670, 1670,  206,  153,   76,   -1,  259,  259,  259,
 /*    60 */   809,  939,  755,  862,  702,  649,  365,  312,  418,  495,
 /*    70 */   572,  992,  992,  992,  992,  992,  992,  992,  992,  992,
 /*    80 */   992,  992,  992,  992,  992,  992,  992,  992,  992,  992,
 /*    90 */  1033, 1033, 2291, 1267,  106,   -2, 1745, 1222, 1165,  157,
 /*   100 */   157,  492,  492,  499,  106,  106,  274,  493,  142,  497,
 /*   110 */    49,   79,  942,  652,  246,   17,  328,  300,  236,  223,
 /*   120 */    80,  147,  532, 1227,  353,  353,  353,  422,  407,  142,
 /*   130 */   353,  353,  610,  353,  341,  565,  379,  353,  380,  142,
 /*   140 */   408,  160,  409,  353,  379,  409,  353,  472,  613,  472,
 /*   150 */   472,  472,  472,  472,  472,  613,  472,   -5, 1284, 1210,
 /*   160 */    -4, 1108,    0,  156,  575, 1683, 1552, 1512, 1569, 1609,
 /*   170 */  1666, 1324, 1626,    6, 1495, 1398, 1381, 1341, 1438, 1455,
 /*   180 */    73,  482,   73,  204,  592,  204,  204,  204,  164,  204,
 /*   190 */   253,  204,  204,  665,  613,  613,  613,  479,  472,  347,
 /*   200 */   415,  415,  472,  347,   -5,   -5,   -5,   -5,   -5, 1727,
 /*   210 */   149,   45,  120,  152,   54,  530,   54,  314,  252,  378,
 /*   220 */   306,  459,  258,  303,  239,  331,  522,  536,  469,  537,
 /*   230 */   539,  569,  534,  544,  561,  525,  518,  570,  593,  612,
 /*   240 */   578,  628,  591,  579,  510,  584,  589,  458,  435,  352,
 /*   250 */   485,  478,  451,  479,  490,  383,  618,
);
    const YY_REDUCE_USE_DFLT = -96;
    const YY_REDUCE_MAX = 208;
    static public $yy_reduce_ofst = array(
 /*     0 */     5,   -7,  489,  566, 1630,  856,   70, 1117, 1865, 1854,
 /*    10 */  1831, 1812, 1891, 1902, 1977, 1951, 1940, 1921, 1789, 1762,
 /*    20 */  1402, 1345, 1288, 1231, 1459, 1516, 1751, 1728, 1709, 1573,
 /*    30 */  1988, 2007, 2123, 2149, 2160, 2198, 2179, 1174, 2093, 2026,
 /*    40 */  2037, 2063, 2112, 2074, 1042, 2209, 1822, 2239, 1061,  861,
 /*    50 */   494,  417,  571, 2265, 2250, 2206, 1705, 1785, 1680, 1705,
 /*    60 */   128,  128,  128,  128,  128,  128,  128,  128,  128,  128,
 /*    70 */   128,  128,  128,  128,  128,  128,  128,  128,  128,  128,
 /*    80 */   128,  128,  128,  128,  128,  128,  128,  128,  128,  128,
 /*    90 */   128,  128,  277,  224,   40,  154,  200,  864, 1062,  170,
 /*   100 */   330,  574, 1149,   99,  329,  381, 1078,   98,  -34,  201,
 /*   110 */    15,  125,  125,  125,  -85,  124,  124,  124,  125,  -95,
 /*   120 */   125,  -95,  332,  354,  573,  616,  617,  460,  615,  307,
 /*   130 */   385,  540,  256,  -74,  248,  -95,  335,  668,  540,  281,
 /*   140 */   540,  125,  670,  669,  520,  540,  186,  125,  339,  125,
 /*   150 */   125,  125,  125,  125,  125,  -95,  125,  125,  554,  554,
 /*   160 */   550,  554,  554,  554,  554,  554,  554,  554,  554,  554,
 /*   170 */   554,  554,  554,  542,  554,  554,  554,  554,  554,  554,
 /*   180 */   595,  -33,  551,  552,  -33,  552,  552,  552,  -33,  552,
 /*   190 */   597,  552,  552,  596,  594,  594,  594,  599,  -33,  356,
 /*   200 */   296,  360,  -33,  356,  395,  404,  376,  416,  368,
);
    static public $yyExpectedTokens = array(
        /* 0 */ array(3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16, 22, 23, 28, 32, 33, 34, ),
        /* 1 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 2 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 3 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 4 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 5 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 6 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 7 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 8 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 65, 78, ),
        /* 9 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 10 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 11 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 12 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 13 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 14 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 15 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 16 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 17 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 18 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 19 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 20 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 21 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 22 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 23 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 24 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 25 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 26 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 27 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 28 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 29 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 30 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 31 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 32 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 33 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 34 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 35 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 36 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 37 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 38 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 39 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 40 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 41 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 42 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 43 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 44 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 45 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 46 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 78, ),
        /* 47 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 78, ),
        /* 48 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 78, ),
        /* 49 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 78, ),
        /* 50 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 78, ),
        /* 51 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 78, ),
        /* 52 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 78, ),
        /* 53 */ array(1, 27, 29, 35, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 54 */ array(1, 17, 29, 35, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 55 */ array(1, 17, 29, 35, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 56 */ array(1, 17, 29, 35, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 57 */ array(1, 29, 35, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 58 */ array(1, 29, 35, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 59 */ array(1, 29, 35, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 60 */ array(1, 24, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 61 */ array(1, 17, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 62 */ array(1, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 63 */ array(1, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 64 */ array(1, 2, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 65 */ array(1, 17, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 66 */ array(1, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 67 */ array(1, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 79, ),
        /* 68 */ array(1, 30, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 69 */ array(1, 17, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 70 */ array(1, 17, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 71 */ array(1, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 72 */ array(1, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 73 */ array(1, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 74 */ array(1, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 75 */ array(1, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 76 */ array(1, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 77 */ array(1, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 78 */ array(1, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 79 */ array(1, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 80 */ array(1, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 81 */ array(1, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 82 */ array(1, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 83 */ array(1, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 84 */ array(1, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 85 */ array(1, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 86 */ array(1, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 87 */ array(1, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 88 */ array(1, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 89 */ array(1, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 90 */ array(40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 91 */ array(40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 92 */ array(1, 17, 21, 29, 35, 38, 61, ),
        /* 93 */ array(1, 17, 29, 35, 54, ),
        /* 94 */ array(1, 29, 35, ),
        /* 95 */ array(3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16, 22, 23, 28, 32, 33, 34, ),
        /* 96 */ array(10, 16, 22, 23, 28, 32, 33, 34, 78, 79, 80, ),
        /* 97 */ array(16, 19, 29, 31, 35, ),
        /* 98 */ array(16, 19, 29, 31, 35, ),
        /* 99 */ array(1, 17, 29, 35, ),
        /* 100 */ array(1, 17, 29, 35, ),
        /* 101 */ array(16, 19, 29, 35, ),
        /* 102 */ array(16, 19, 29, 35, ),
        /* 103 */ array(1, 2, 17, ),
        /* 104 */ array(1, 29, 35, ),
        /* 105 */ array(1, 29, 35, ),
        /* 106 */ array(18, 19, 63, ),
        /* 107 */ array(21, 59, 64, ),
        /* 108 */ array(18, 38, ),
        /* 109 */ array(10, 16, 22, 23, 28, 32, 33, 34, 78, 79, 80, ),
        /* 110 */ array(4, 5, 6, 7, 8, 13, 14, 15, ),
        /* 111 */ array(1, 17, 29, 30, 35, 54, ),
        /* 112 */ array(1, 17, 29, 35, 54, ),
        /* 113 */ array(1, 17, 29, 35, 54, ),
        /* 114 */ array(16, 19, 20, 25, ),
        /* 115 */ array(16, 19, 20, 62, ),
        /* 116 */ array(16, 19, 62, ),
        /* 117 */ array(16, 19, 20, ),
        /* 118 */ array(1, 31, 54, ),
        /* 119 */ array(20, 21, 61, ),
        /* 120 */ array(1, 17, 54, ),
        /* 121 */ array(20, 21, 61, ),
        /* 122 */ array(1, 17, 21, ),
        /* 123 */ array(17, 29, 35, ),
        /* 124 */ array(16, 19, ),
        /* 125 */ array(16, 19, ),
        /* 126 */ array(16, 19, ),
        /* 127 */ array(29, 35, ),
        /* 128 */ array(16, 19, ),
        /* 129 */ array(18, 38, ),
        /* 130 */ array(16, 19, ),
        /* 131 */ array(16, 19, ),
        /* 132 */ array(1, 17, ),
        /* 133 */ array(16, 19, ),
        /* 134 */ array(29, 35, ),
        /* 135 */ array(21, 61, ),
        /* 136 */ array(18, 19, ),
        /* 137 */ array(16, 19, ),
        /* 138 */ array(16, 19, ),
        /* 139 */ array(18, 38, ),
        /* 140 */ array(16, 19, ),
        /* 141 */ array(1, 54, ),
        /* 142 */ array(16, 19, ),
        /* 143 */ array(16, 19, ),
        /* 144 */ array(18, 19, ),
        /* 145 */ array(16, 19, ),
        /* 146 */ array(16, 19, ),
        /* 147 */ array(1, ),
        /* 148 */ array(21, ),
        /* 149 */ array(1, ),
        /* 150 */ array(1, ),
        /* 151 */ array(1, ),
        /* 152 */ array(1, ),
        /* 153 */ array(1, ),
        /* 154 */ array(1, ),
        /* 155 */ array(21, ),
        /* 156 */ array(1, ),
        /* 157 */ array(),
        /* 158 */ array(17, 29, 35, ),
        /* 159 */ array(17, 29, 35, ),
        /* 160 */ array(16, 19, 62, ),
        /* 161 */ array(17, 29, 35, ),
        /* 162 */ array(17, 29, 35, ),
        /* 163 */ array(17, 29, 35, ),
        /* 164 */ array(17, 29, 35, ),
        /* 165 */ array(17, 29, 35, ),
        /* 166 */ array(17, 29, 35, ),
        /* 167 */ array(17, 29, 35, ),
        /* 168 */ array(17, 29, 35, ),
        /* 169 */ array(17, 29, 35, ),
        /* 170 */ array(17, 29, 35, ),
        /* 171 */ array(17, 29, 35, ),
        /* 172 */ array(17, 29, 35, ),
        /* 173 */ array(16, 18, 19, ),
        /* 174 */ array(17, 29, 35, ),
        /* 175 */ array(17, 29, 35, ),
        /* 176 */ array(17, 29, 35, ),
        /* 177 */ array(17, 29, 35, ),
        /* 178 */ array(17, 29, 35, ),
        /* 179 */ array(17, 29, 35, ),
        /* 180 */ array(59, 64, ),
        /* 181 */ array(1, 17, ),
        /* 182 */ array(59, 64, ),
        /* 183 */ array(59, 64, ),
        /* 184 */ array(1, 17, ),
        /* 185 */ array(59, 64, ),
        /* 186 */ array(59, 64, ),
        /* 187 */ array(59, 64, ),
        /* 188 */ array(1, 17, ),
        /* 189 */ array(59, 64, ),
        /* 190 */ array(16, 38, ),
        /* 191 */ array(59, 64, ),
        /* 192 */ array(59, 64, ),
        /* 193 */ array(14, ),
        /* 194 */ array(21, ),
        /* 195 */ array(21, ),
        /* 196 */ array(21, ),
        /* 197 */ array(38, ),
        /* 198 */ array(1, ),
        /* 199 */ array(2, ),
        /* 200 */ array(29, ),
        /* 201 */ array(29, ),
        /* 202 */ array(1, ),
        /* 203 */ array(2, ),
        /* 204 */ array(),
        /* 205 */ array(),
        /* 206 */ array(),
        /* 207 */ array(),
        /* 208 */ array(),
        /* 209 */ array(17, 24, 26, 27, 29, 30, 35, 37, 38, 39, 54, 61, 65, 79, ),
        /* 210 */ array(17, 20, 29, 35, 38, 61, ),
        /* 211 */ array(38, 59, 61, 65, ),
        /* 212 */ array(16, 18, 19, 36, ),
        /* 213 */ array(31, 38, 61, ),
        /* 214 */ array(38, 61, ),
        /* 215 */ array(2, 20, ),
        /* 216 */ array(38, 61, ),
        /* 217 */ array(24, 37, ),
        /* 218 */ array(37, 65, ),
        /* 219 */ array(17, 25, ),
        /* 220 */ array(37, 39, ),
        /* 221 */ array(20, 59, ),
        /* 222 */ array(37, 39, ),
        /* 223 */ array(37, 39, ),
        /* 224 */ array(25, 79, ),
        /* 225 */ array(19, 62, ),
        /* 226 */ array(63, ),
        /* 227 */ array(19, ),
        /* 228 */ array(65, ),
        /* 229 */ array(19, ),
        /* 230 */ array(19, ),
        /* 231 */ array(19, ),
        /* 232 */ array(25, ),
        /* 233 */ array(63, ),
        /* 234 */ array(19, ),
        /* 235 */ array(59, ),
        /* 236 */ array(36, ),
        /* 237 */ array(36, ),
        /* 238 */ array(39, ),
        /* 239 */ array(19, ),
        /* 240 */ array(55, ),
        /* 241 */ array(2, ),
        /* 242 */ array(38, ),
        /* 243 */ array(18, ),
        /* 244 */ array(18, ),
        /* 245 */ array(18, ),
        /* 246 */ array(19, ),
        /* 247 */ array(18, ),
        /* 248 */ array(20, ),
        /* 249 */ array(19, ),
        /* 250 */ array(19, ),
        /* 251 */ array(2, ),
        /* 252 */ array(26, ),
        /* 253 */ array(38, ),
        /* 254 */ array(19, ),
        /* 255 */ array(19, ),
        /* 256 */ array(18, ),
        /* 257 */ array(),
        /* 258 */ array(),
        /* 259 */ array(),
        /* 260 */ array(),
        /* 261 */ array(),
        /* 262 */ array(),
        /* 263 */ array(),
        /* 264 */ array(),
        /* 265 */ array(),
        /* 266 */ array(),
        /* 267 */ array(),
        /* 268 */ array(),
        /* 269 */ array(),
        /* 270 */ array(),
        /* 271 */ array(),
        /* 272 */ array(),
        /* 273 */ array(),
        /* 274 */ array(),
        /* 275 */ array(),
        /* 276 */ array(),
        /* 277 */ array(),
        /* 278 */ array(),
        /* 279 */ array(),
        /* 280 */ array(),
        /* 281 */ array(),
        /* 282 */ array(),
        /* 283 */ array(),
        /* 284 */ array(),
        /* 285 */ array(),
        /* 286 */ array(),
        /* 287 */ array(),
        /* 288 */ array(),
        /* 289 */ array(),
        /* 290 */ array(),
        /* 291 */ array(),
        /* 292 */ array(),
        /* 293 */ array(),
        /* 294 */ array(),
        /* 295 */ array(),
        /* 296 */ array(),
        /* 297 */ array(),
        /* 298 */ array(),
        /* 299 */ array(),
        /* 300 */ array(),
        /* 301 */ array(),
        /* 302 */ array(),
        /* 303 */ array(),
        /* 304 */ array(),
        /* 305 */ array(),
        /* 306 */ array(),
        /* 307 */ array(),
        /* 308 */ array(),
        /* 309 */ array(),
        /* 310 */ array(),
        /* 311 */ array(),
        /* 312 */ array(),
        /* 313 */ array(),
        /* 314 */ array(),
        /* 315 */ array(),
        /* 316 */ array(),
        /* 317 */ array(),
        /* 318 */ array(),
        /* 319 */ array(),
        /* 320 */ array(),
        /* 321 */ array(),
        /* 322 */ array(),
        /* 323 */ array(),
        /* 324 */ array(),
        /* 325 */ array(),
        /* 326 */ array(),
        /* 327 */ array(),
        /* 328 */ array(),
        /* 329 */ array(),
        /* 330 */ array(),
        /* 331 */ array(),
        /* 332 */ array(),
        /* 333 */ array(),
        /* 334 */ array(),
        /* 335 */ array(),
        /* 336 */ array(),
        /* 337 */ array(),
        /* 338 */ array(),
        /* 339 */ array(),
        /* 340 */ array(),
        /* 341 */ array(),
        /* 342 */ array(),
        /* 343 */ array(),
        /* 344 */ array(),
        /* 345 */ array(),
        /* 346 */ array(),
        /* 347 */ array(),
        /* 348 */ array(),
        /* 349 */ array(),
        /* 350 */ array(),
        /* 351 */ array(),
        /* 352 */ array(),
        /* 353 */ array(),
        /* 354 */ array(),
        /* 355 */ array(),
        /* 356 */ array(),
        /* 357 */ array(),
        /* 358 */ array(),
        /* 359 */ array(),
        /* 360 */ array(),
        /* 361 */ array(),
        /* 362 */ array(),
        /* 363 */ array(),
        /* 364 */ array(),
        /* 365 */ array(),
        /* 366 */ array(),
        /* 367 */ array(),
        /* 368 */ array(),
        /* 369 */ array(),
        /* 370 */ array(),
        /* 371 */ array(),
        /* 372 */ array(),
        /* 373 */ array(),
        /* 374 */ array(),
        /* 375 */ array(),
        /* 376 */ array(),
        /* 377 */ array(),
        /* 378 */ array(),
        /* 379 */ array(),
        /* 380 */ array(),
        /* 381 */ array(),
        /* 382 */ array(),
        /* 383 */ array(),
        /* 384 */ array(),
        /* 385 */ array(),
        /* 386 */ array(),
        /* 387 */ array(),
        /* 388 */ array(),
        /* 389 */ array(),
        /* 390 */ array(),
);
    static public $yy_default = array(
 /*     0 */   394,  578,  549,  549,  595,  549,  595,  595,  595,  595,
 /*    10 */   595,  595,  595,  595,  595,  595,  595,  595,  595,  595,
 /*    20 */   595,  595,  595,  595,  595,  595,  595,  595,  595,  595,
 /*    30 */   595,  595,  595,  595,  595,  595,  595,  595,  595,  595,
 /*    40 */   595,  595,  595,  595,  595,  595,  595,  595,  595,  595,
 /*    50 */   595,  595,  595,  455,  595,  595,  595,  455,  455,  455,
 /*    60 */   595,  595,  595,  595,  595,  595,  595,  595,  460,  595,
 /*    70 */   595,  466,  465,  484,  547,  579,  581,  548,  580,  489,
 /*    80 */   488,  480,  479,  481,  457,  485,  462,  476,  460,  437,
 /*    90 */   492,  493,  504,  468,  455,  391,  595,  455,  455,  475,
 /*   100 */   512,  455,  455,  595,  455,  455,  595,  561,  595,  595,
 /*   110 */   595,  468,  468,  468,  595,  522,  522,  522,  468,  513,
 /*   120 */   468,  513,  595,  595,  595,  595,  595,  455,  595,  595,
 /*   130 */   595,  595,  595,  595,  455,  513,  595,  595,  595,  595,
 /*   140 */   595,  468,  595,  595,  595,  595,  522,  473,  558,  491,
 /*   150 */   478,  472,  497,  495,  496,  513,  471,  556,  595,  595,
 /*   160 */   523,  595,  595,  595,  595,  595,  595,  595,  595,  595,
 /*   170 */   595,  595,  595,  595,  595,  595,  595,  595,  595,  595,
 /*   180 */   516,  595,  518,  519,  595,  520,  540,  542,  595,  539,
 /*   190 */   522,  517,  541,  410,  562,  559,  536,  522,  475,  551,
 /*   200 */   594,  594,  512,  550,  522,  555,  555,  555,  522,  470,
 /*   210 */   504,  504,  595,  504,  490,  534,  504,  595,  595,  494,
 /*   220 */   595,  500,  595,  595,  494,  595,  595,  595,  595,  595,
 /*   230 */   595,  595,  494,  595,  595,  500,  502,  595,  595,  595,
 /*   240 */   506,  534,  560,  595,  595,  595,  595,  595,  595,  595,
 /*   250 */   595,  534,  463,  534,  595,  595,  595,  401,  543,  400,
 /*   260 */   402,  546,  445,  398,  397,  393,  464,  438,  593,  467,
 /*   270 */   435,  395,  440,  434,  439,  396,  399,  456,  531,  420,
 /*   280 */   529,  392,  528,  506,  527,  535,  444,  557,  545,  544,
 /*   290 */   530,  412,  453,  526,  505,  419,  507,  525,  532,  470,
 /*   300 */   514,  521,  524,  508,  510,  482,  483,  416,  415,  417,
 /*   310 */   418,  477,  511,  515,  538,  469,  509,  534,  533,  432,
 /*   320 */   446,  447,  443,  442,  436,  454,  433,  441,  554,  448,
 /*   330 */   498,  499,  501,  503,  452,  451,  449,  450,  552,  553,
 /*   340 */   486,  487,  589,  430,  582,  583,  584,  431,  429,  426,
 /*   350 */   537,  427,  428,  406,  587,  575,  404,  577,  576,  405,
 /*   360 */   585,  586,  588,  591,  592,  425,  424,  569,  568,  570,
 /*   370 */   571,  572,  567,  566,  414,  563,  564,  565,  573,  574,
 /*   380 */   422,  590,  407,  423,  421,  408,  474,  413,  411,  409,
 /*   390 */   403,
);
    const YYNOCODE = 124;
    const YYSTACKDEPTH = 100;
    const YYNSTATE = 391;
    const YYNRULE = 204;
    const YYERRORSYMBOL = 81;
    const YYERRSYMDT = 'yy0';
    const YYFALLBACK = 0;
    static public $yyFallback = array(
    );
    static function Trace($TraceFILE, $zTracePrompt)
    {
        if (!$TraceFILE) {
            $zTracePrompt = 0;
        } elseif (!$zTracePrompt) {
            $TraceFILE = 0;
        }
        self::$yyTraceFILE = $TraceFILE;
        self::$yyTracePrompt = $zTracePrompt;
    }

    static function PrintTrace()
    {
        self::$yyTraceFILE = fopen('php://output', 'w');
        self::$yyTracePrompt = '<br>';
    }

    static public $yyTraceFILE;
    static public $yyTracePrompt;
    public $yyidx;                    /* Index of top element in stack */
    public $yyerrcnt;                 /* Shifts left before out of the error */
    public $yystack = array();  /* The parser's stack */

    public $yyTokenName = array(
  '$',             'VERT',          'COLON',         'COMMENT',
  'PHPSTARTTAG',   'PHPENDTAG',     'ASPSTARTTAG',   'ASPENDTAG',
  'FAKEPHPSTARTTAG',  'XMLTAG',        'TEXT',          'STRIPON',
  'STRIPOFF',      'LITERALSTART',  'LITERALEND',    'LITERAL',
  'LDEL',          'RDEL',          'DOLLAR',        'ID',
  'EQUAL',         'PTR',           'LDELIF',        'LDELFOR',
  'SEMICOLON',     'INCDEC',        'TO',            'STEP',
  'LDELFOREACH',   'SPACE',         'AS',            'APTR',
  'LDELSETFILTER',  'SMARTYBLOCKCHILD',  'LDELSLASH',     'ATTR',
  'INTEGER',       'COMMA',         'OPENP',         'CLOSEP',
  'MATH',          'UNIMATH',       'ANDSYM',        'ISIN',
  'ISDIVBY',       'ISNOTDIVBY',    'ISEVEN',        'ISNOTEVEN',
  'ISEVENBY',      'ISNOTEVENBY',   'ISODD',         'ISNOTODD',
  'ISODDBY',       'ISNOTODDBY',    'INSTANCEOF',    'QMARK',
  'NOT',           'TYPECAST',      'HEX',           'DOT',
  'SINGLEQUOTESTRING',  'DOUBLECOLON',   'AT',            'HATCH',
  'OPENB',         'CLOSEB',        'EQUALS',        'NOTEQUALS',
  'GREATERTHAN',   'LESSTHAN',      'GREATEREQUAL',  'LESSEQUAL',
  'IDENTITY',      'NONEIDENTITY',  'MOD',           'LAND',
  'LOR',           'LXOR',          'QUOTE',         'BACKTICK',
  'DOLLARID',      'error',         'start',         'template',
  'template_element',  'smartytag',     'literal',       'literal_elements',
  'literal_element',  'value',         'modifierlist',  'attributes',
  'expr',          'varindexed',    'statement',     'statements',
  'optspace',      'varvar',        'foraction',     'modparameters',
  'attribute',     'ternary',       'array',         'ifcond',
  'lop',           'variable',      'function',      'doublequoted_with_quotes',
  'static_class_access',  'object',        'arrayindex',    'indexdef',
  'varvarele',     'objectchain',   'objectelement',  'method',
  'params',        'modifier',      'modparameter',  'arrayelements',
  'arrayelement',  'doublequoted',  'doublequotedcontent',
    );

    static public $yyRuleName = array(
 /*   0 */ "start ::= template",
 /*   1 */ "template ::= template_element",
 /*   2 */ "template ::= template template_element",
 /*   3 */ "template ::=",
 /*   4 */ "template_element ::= smartytag",
 /*   5 */ "template_element ::= COMMENT",
 /*   6 */ "template_element ::= literal",
 /*   7 */ "template_element ::= PHPSTARTTAG",
 /*   8 */ "template_element ::= PHPENDTAG",
 /*   9 */ "template_element ::= ASPSTARTTAG",
 /*  10 */ "template_element ::= ASPENDTAG",
 /*  11 */ "template_element ::= FAKEPHPSTARTTAG",
 /*  12 */ "template_element ::= XMLTAG",
 /*  13 */ "template_element ::= TEXT",
 /*  14 */ "template_element ::= STRIPON",
 /*  15 */ "template_element ::= STRIPOFF",
 /*  16 */ "literal ::= LITERALSTART LITERALEND",
 /*  17 */ "literal ::= LITERALSTART literal_elements LITERALEND",
 /*  18 */ "literal_elements ::= literal_elements literal_element",
 /*  19 */ "literal_elements ::=",
 /*  20 */ "literal_element ::= literal",
 /*  21 */ "literal_element ::= LITERAL",
 /*  22 */ "literal_element ::= PHPSTARTTAG",
 /*  23 */ "literal_element ::= FAKEPHPSTARTTAG",
 /*  24 */ "literal_element ::= PHPENDTAG",
 /*  25 */ "literal_element ::= ASPSTARTTAG",
 /*  26 */ "literal_element ::= ASPENDTAG",
 /*  27 */ "smartytag ::= LDEL value RDEL",
 /*  28 */ "smartytag ::= LDEL value modifierlist attributes RDEL",
 /*  29 */ "smartytag ::= LDEL value attributes RDEL",
 /*  30 */ "smartytag ::= LDEL expr modifierlist attributes RDEL",
 /*  31 */ "smartytag ::= LDEL expr attributes RDEL",
 /*  32 */ "smartytag ::= LDEL DOLLAR ID EQUAL value RDEL",
 /*  33 */ "smartytag ::= LDEL DOLLAR ID EQUAL expr RDEL",
 /*  34 */ "smartytag ::= LDEL DOLLAR ID EQUAL expr attributes RDEL",
 /*  35 */ "smartytag ::= LDEL varindexed EQUAL expr attributes RDEL",
 /*  36 */ "smartytag ::= LDEL ID attributes RDEL",
 /*  37 */ "smartytag ::= LDEL ID RDEL",
 /*  38 */ "smartytag ::= LDEL ID PTR ID attributes RDEL",
 /*  39 */ "smartytag ::= LDEL ID modifierlist attributes RDEL",
 /*  40 */ "smartytag ::= LDEL ID PTR ID modifierlist attributes RDEL",
 /*  41 */ "smartytag ::= LDELIF expr RDEL",
 /*  42 */ "smartytag ::= LDELIF expr attributes RDEL",
 /*  43 */ "smartytag ::= LDELIF statement RDEL",
 /*  44 */ "smartytag ::= LDELIF statement attributes RDEL",
 /*  45 */ "smartytag ::= LDELFOR statements SEMICOLON optspace expr SEMICOLON optspace DOLLAR varvar foraction attributes RDEL",
 /*  46 */ "foraction ::= EQUAL expr",
 /*  47 */ "foraction ::= INCDEC",
 /*  48 */ "smartytag ::= LDELFOR statement TO expr attributes RDEL",
 /*  49 */ "smartytag ::= LDELFOR statement TO expr STEP expr attributes RDEL",
 /*  50 */ "smartytag ::= LDELFOREACH attributes RDEL",
 /*  51 */ "smartytag ::= LDELFOREACH SPACE value AS DOLLAR varvar attributes RDEL",
 /*  52 */ "smartytag ::= LDELFOREACH SPACE value AS DOLLAR varvar APTR DOLLAR varvar attributes RDEL",
 /*  53 */ "smartytag ::= LDELFOREACH SPACE expr AS DOLLAR varvar attributes RDEL",
 /*  54 */ "smartytag ::= LDELFOREACH SPACE expr AS DOLLAR varvar APTR DOLLAR varvar attributes RDEL",
 /*  55 */ "smartytag ::= LDELSETFILTER ID modparameters RDEL",
 /*  56 */ "smartytag ::= LDELSETFILTER ID modparameters modifierlist RDEL",
 /*  57 */ "smartytag ::= SMARTYBLOCKCHILD",
 /*  58 */ "smartytag ::= LDELSLASH ID RDEL",
 /*  59 */ "smartytag ::= LDELSLASH ID modifierlist RDEL",
 /*  60 */ "smartytag ::= LDELSLASH ID PTR ID RDEL",
 /*  61 */ "smartytag ::= LDELSLASH ID PTR ID modifierlist RDEL",
 /*  62 */ "attributes ::= attributes attribute",
 /*  63 */ "attributes ::= attribute",
 /*  64 */ "attributes ::=",
 /*  65 */ "attribute ::= SPACE ID EQUAL ID",
 /*  66 */ "attribute ::= ATTR expr",
 /*  67 */ "attribute ::= ATTR value",
 /*  68 */ "attribute ::= SPACE ID",
 /*  69 */ "attribute ::= SPACE expr",
 /*  70 */ "attribute ::= SPACE value",
 /*  71 */ "attribute ::= SPACE INTEGER EQUAL expr",
 /*  72 */ "statements ::= statement",
 /*  73 */ "statements ::= statements COMMA statement",
 /*  74 */ "statement ::= DOLLAR varvar EQUAL expr",
 /*  75 */ "statement ::= varindexed EQUAL expr",
 /*  76 */ "statement ::= OPENP statement CLOSEP",
 /*  77 */ "expr ::= value",
 /*  78 */ "expr ::= ternary",
 /*  79 */ "expr ::= DOLLAR ID COLON ID",
 /*  80 */ "expr ::= expr MATH value",
 /*  81 */ "expr ::= expr UNIMATH value",
 /*  82 */ "expr ::= expr ANDSYM value",
 /*  83 */ "expr ::= array",
 /*  84 */ "expr ::= expr modifierlist",
 /*  85 */ "expr ::= expr ifcond expr",
 /*  86 */ "expr ::= expr ISIN array",
 /*  87 */ "expr ::= expr ISIN value",
 /*  88 */ "expr ::= expr lop expr",
 /*  89 */ "expr ::= expr ISDIVBY expr",
 /*  90 */ "expr ::= expr ISNOTDIVBY expr",
 /*  91 */ "expr ::= expr ISEVEN",
 /*  92 */ "expr ::= expr ISNOTEVEN",
 /*  93 */ "expr ::= expr ISEVENBY expr",
 /*  94 */ "expr ::= expr ISNOTEVENBY expr",
 /*  95 */ "expr ::= expr ISODD",
 /*  96 */ "expr ::= expr ISNOTODD",
 /*  97 */ "expr ::= expr ISODDBY expr",
 /*  98 */ "expr ::= expr ISNOTODDBY expr",
 /*  99 */ "expr ::= value INSTANCEOF ID",
 /* 100 */ "expr ::= value INSTANCEOF value",
 /* 101 */ "ternary ::= OPENP expr CLOSEP QMARK DOLLAR ID COLON expr",
 /* 102 */ "ternary ::= OPENP expr CLOSEP QMARK expr COLON expr",
 /* 103 */ "value ::= variable",
 /* 104 */ "value ::= UNIMATH value",
 /* 105 */ "value ::= NOT value",
 /* 106 */ "value ::= TYPECAST value",
 /* 107 */ "value ::= variable INCDEC",
 /* 108 */ "value ::= HEX",
 /* 109 */ "value ::= INTEGER",
 /* 110 */ "value ::= INTEGER DOT INTEGER",
 /* 111 */ "value ::= INTEGER DOT",
 /* 112 */ "value ::= DOT INTEGER",
 /* 113 */ "value ::= ID",
 /* 114 */ "value ::= function",
 /* 115 */ "value ::= OPENP expr CLOSEP",
 /* 116 */ "value ::= SINGLEQUOTESTRING",
 /* 117 */ "value ::= doublequoted_with_quotes",
 /* 118 */ "value ::= ID DOUBLECOLON static_class_access",
 /* 119 */ "value ::= varindexed DOUBLECOLON static_class_access",
 /* 120 */ "value ::= smartytag",
 /* 121 */ "value ::= value modifierlist",
 /* 122 */ "variable ::= varindexed",
 /* 123 */ "variable ::= DOLLAR varvar AT ID",
 /* 124 */ "variable ::= object",
 /* 125 */ "variable ::= HATCH ID HATCH",
 /* 126 */ "variable ::= HATCH ID HATCH arrayindex",
 /* 127 */ "variable ::= HATCH variable HATCH",
 /* 128 */ "variable ::= HATCH variable HATCH arrayindex",
 /* 129 */ "varindexed ::= DOLLAR varvar arrayindex",
 /* 130 */ "arrayindex ::= arrayindex indexdef",
 /* 131 */ "arrayindex ::=",
 /* 132 */ "indexdef ::= DOT DOLLAR varvar",
 /* 133 */ "indexdef ::= DOT DOLLAR varvar AT ID",
 /* 134 */ "indexdef ::= DOT ID",
 /* 135 */ "indexdef ::= DOT INTEGER",
 /* 136 */ "indexdef ::= DOT LDEL expr RDEL",
 /* 137 */ "indexdef ::= OPENB ID CLOSEB",
 /* 138 */ "indexdef ::= OPENB ID DOT ID CLOSEB",
 /* 139 */ "indexdef ::= OPENB expr CLOSEB",
 /* 140 */ "indexdef ::= OPENB CLOSEB",
 /* 141 */ "varvar ::= varvarele",
 /* 142 */ "varvar ::= varvar varvarele",
 /* 143 */ "varvarele ::= ID",
 /* 144 */ "varvarele ::= LDEL expr RDEL",
 /* 145 */ "object ::= varindexed objectchain",
 /* 146 */ "objectchain ::= objectelement",
 /* 147 */ "objectchain ::= objectchain objectelement",
 /* 148 */ "objectelement ::= PTR ID arrayindex",
 /* 149 */ "objectelement ::= PTR DOLLAR varvar arrayindex",
 /* 150 */ "objectelement ::= PTR LDEL expr RDEL arrayindex",
 /* 151 */ "objectelement ::= PTR ID LDEL expr RDEL arrayindex",
 /* 152 */ "objectelement ::= PTR method",
 /* 153 */ "function ::= ID OPENP params CLOSEP",
 /* 154 */ "method ::= ID OPENP params CLOSEP",
 /* 155 */ "method ::= DOLLAR ID OPENP params CLOSEP",
 /* 156 */ "params ::= params COMMA expr",
 /* 157 */ "params ::= expr",
 /* 158 */ "params ::=",
 /* 159 */ "modifierlist ::= modifierlist modifier modparameters",
 /* 160 */ "modifierlist ::= modifier modparameters",
 /* 161 */ "modifier ::= VERT AT ID",
 /* 162 */ "modifier ::= VERT ID",
 /* 163 */ "modparameters ::= modparameters modparameter",
 /* 164 */ "modparameters ::=",
 /* 165 */ "modparameter ::= COLON value",
 /* 166 */ "modparameter ::= COLON array",
 /* 167 */ "static_class_access ::= method",
 /* 168 */ "static_class_access ::= method objectchain",
 /* 169 */ "static_class_access ::= ID",
 /* 170 */ "static_class_access ::= DOLLAR ID arrayindex",
 /* 171 */ "static_class_access ::= DOLLAR ID arrayindex objectchain",
 /* 172 */ "ifcond ::= EQUALS",
 /* 173 */ "ifcond ::= NOTEQUALS",
 /* 174 */ "ifcond ::= GREATERTHAN",
 /* 175 */ "ifcond ::= LESSTHAN",
 /* 176 */ "ifcond ::= GREATEREQUAL",
 /* 177 */ "ifcond ::= LESSEQUAL",
 /* 178 */ "ifcond ::= IDENTITY",
 /* 179 */ "ifcond ::= NONEIDENTITY",
 /* 180 */ "ifcond ::= MOD",
 /* 181 */ "lop ::= LAND",
 /* 182 */ "lop ::= LOR",
 /* 183 */ "lop ::= LXOR",
 /* 184 */ "array ::= OPENB arrayelements CLOSEB",
 /* 185 */ "arrayelements ::= arrayelement",
 /* 186 */ "arrayelements ::= arrayelements COMMA arrayelement",
 /* 187 */ "arrayelements ::=",
 /* 188 */ "arrayelement ::= value APTR expr",
 /* 189 */ "arrayelement ::= ID APTR expr",
 /* 190 */ "arrayelement ::= expr",
 /* 191 */ "doublequoted_with_quotes ::= QUOTE QUOTE",
 /* 192 */ "doublequoted_with_quotes ::= QUOTE doublequoted QUOTE",
 /* 193 */ "doublequoted ::= doublequoted doublequotedcontent",
 /* 194 */ "doublequoted ::= doublequotedcontent",
 /* 195 */ "doublequotedcontent ::= BACKTICK variable BACKTICK",
 /* 196 */ "doublequotedcontent ::= BACKTICK expr BACKTICK",
 /* 197 */ "doublequotedcontent ::= DOLLARID",
 /* 198 */ "doublequotedcontent ::= LDEL variable RDEL",
 /* 199 */ "doublequotedcontent ::= LDEL expr RDEL",
 /* 200 */ "doublequotedcontent ::= smartytag",
 /* 201 */ "doublequotedcontent ::= TEXT",
 /* 202 */ "optspace ::= SPACE",
 /* 203 */ "optspace ::=",
    );

    function tokenName($tokenType)
    {
        if ($tokenType === 0) {
            return 'End of Input';
        }
        if ($tokenType > 0 && $tokenType < count($this->yyTokenName)) {
            return $this->yyTokenName[$tokenType];
        } else {
            return "Unknown";
        }
    }

    static function yy_destructor($yymajor, $yypminor)
    {
        switch ($yymajor) {
            default:  break;   /* If no destructor action specified: do nothing */
        }
    }

    function yy_pop_parser_stack()
    {
        if (!count($this->yystack)) {
            return;
        }
        $yytos = array_pop($this->yystack);
        if (self::$yyTraceFILE && $this->yyidx >= 0) {
            fwrite(self::$yyTraceFILE,
                self::$yyTracePrompt . 'Popping ' . $this->yyTokenName[$yytos->major] .
                    "\n");
        }
        $yymajor = $yytos->major;
        self::yy_destructor($yymajor, $yytos->minor);
        $this->yyidx--;
        return $yymajor;
    }

    function __destruct()
    {
        while ($this->yystack !== Array()) {
            $this->yy_pop_parser_stack();
        }
        if (is_resource(self::$yyTraceFILE)) {
            fclose(self::$yyTraceFILE);
        }
    }

    function yy_get_expected_tokens($token)
    {
        $state = $this->yystack[$this->yyidx]->stateno;
        $expected = self::$yyExpectedTokens[$state];
        if (in_array($token, self::$yyExpectedTokens[$state], true)) {
            return $expected;
        }
        $stack = $this->yystack;
        $yyidx = $this->yyidx;
        do {
            $yyact = $this->yy_find_shift_action($token);
            if ($yyact >= self::YYNSTATE && $yyact < self::YYNSTATE + self::YYNRULE) {
                // reduce action
                $done = 0;
                do {
                    if ($done++ == 100) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // too much recursion prevents proper detection
                        // so give up
                        return array_unique($expected);
                    }
                    $yyruleno = $yyact - self::YYNSTATE;
                    $this->yyidx -= self::$yyRuleInfo[$yyruleno]['rhs'];
                    $nextstate = $this->yy_find_reduce_action(
                        $this->yystack[$this->yyidx]->stateno,
                        self::$yyRuleInfo[$yyruleno]['lhs']);
                    if (isset(self::$yyExpectedTokens[$nextstate])) {
		        $expected = array_merge($expected, self::$yyExpectedTokens[$nextstate]);
                            if (in_array($token,
                                  self::$yyExpectedTokens[$nextstate], true)) {
                            $this->yyidx = $yyidx;
                            $this->yystack = $stack;
                            return array_unique($expected);
                        }
                    }
                    if ($nextstate < self::YYNSTATE) {
                        // we need to shift a non-terminal
                        $this->yyidx++;
                        $x = new TP_yyStackEntry;
                        $x->stateno = $nextstate;
                        $x->major = self::$yyRuleInfo[$yyruleno]['lhs'];
                        $this->yystack[$this->yyidx] = $x;
                        continue 2;
                    } elseif ($nextstate == self::YYNSTATE + self::YYNRULE + 1) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // the last token was just ignored, we can't accept
                        // by ignoring input, this is in essence ignoring a
                        // syntax error!
                        return array_unique($expected);
                    } elseif ($nextstate === self::YY_NO_ACTION) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // input accepted, but not shifted (I guess)
                        return $expected;
                    } else {
                        $yyact = $nextstate;
                    }
                } while (true);
            }
            break;
        } while (true);
	$this->yyidx = $yyidx;
	$this->yystack = $stack;
        return array_unique($expected);
    }

    function yy_is_expected_token($token)
    {
        if ($token === 0) {
            return true; // 0 is not part of this
        }
        $state = $this->yystack[$this->yyidx]->stateno;
        if (in_array($token, self::$yyExpectedTokens[$state], true)) {
            return true;
        }
        $stack = $this->yystack;
        $yyidx = $this->yyidx;
        do {
            $yyact = $this->yy_find_shift_action($token);
            if ($yyact >= self::YYNSTATE && $yyact < self::YYNSTATE + self::YYNRULE) {
                // reduce action
                $done = 0;
                do {
                    if ($done++ == 100) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // too much recursion prevents proper detection
                        // so give up
                        return true;
                    }
                    $yyruleno = $yyact - self::YYNSTATE;
                    $this->yyidx -= self::$yyRuleInfo[$yyruleno]['rhs'];
                    $nextstate = $this->yy_find_reduce_action(
                        $this->yystack[$this->yyidx]->stateno,
                        self::$yyRuleInfo[$yyruleno]['lhs']);
                    if (isset(self::$yyExpectedTokens[$nextstate]) &&
                          in_array($token, self::$yyExpectedTokens[$nextstate], true)) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        return true;
                    }
                    if ($nextstate < self::YYNSTATE) {
                        // we need to shift a non-terminal
                        $this->yyidx++;
                        $x = new TP_yyStackEntry;
                        $x->stateno = $nextstate;
                        $x->major = self::$yyRuleInfo[$yyruleno]['lhs'];
                        $this->yystack[$this->yyidx] = $x;
                        continue 2;
                    } elseif ($nextstate == self::YYNSTATE + self::YYNRULE + 1) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        if (!$token) {
                            // end of input: this is valid
                            return true;
                        }
                        // the last token was just ignored, we can't accept
                        // by ignoring input, this is in essence ignoring a
                        // syntax error!
                        return false;
                    } elseif ($nextstate === self::YY_NO_ACTION) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // input accepted, but not shifted (I guess)
                        return true;
                    } else {
                        $yyact = $nextstate;
                    }
                } while (true);
            }
            break;
        } while (true);
        $this->yyidx = $yyidx;
        $this->yystack = $stack;
        return true;
    }

   function yy_find_shift_action($iLookAhead)
    {
        $stateno = $this->yystack[$this->yyidx]->stateno;

        /* if ($this->yyidx < 0) return self::YY_NO_ACTION;  */
        if (!isset(self::$yy_shift_ofst[$stateno])) {
            // no shift actions
            return self::$yy_default[$stateno];
        }
        $i = self::$yy_shift_ofst[$stateno];
        if ($i === self::YY_SHIFT_USE_DFLT) {
            return self::$yy_default[$stateno];
        }
        if ($iLookAhead == self::YYNOCODE) {
            return self::YY_NO_ACTION;
        }
        $i += $iLookAhead;
        if ($i < 0 || $i >= self::YY_SZ_ACTTAB ||
              self::$yy_lookahead[$i] != $iLookAhead) {
            if (count(self::$yyFallback) && $iLookAhead < count(self::$yyFallback)
                   && ($iFallback = self::$yyFallback[$iLookAhead]) != 0) {
                if (self::$yyTraceFILE) {
                    fwrite(self::$yyTraceFILE, self::$yyTracePrompt . "FALLBACK " .
                        $this->yyTokenName[$iLookAhead] . " => " .
                        $this->yyTokenName[$iFallback] . "\n");
                }
                return $this->yy_find_shift_action($iFallback);
            }
            return self::$yy_default[$stateno];
        } else {
            return self::$yy_action[$i];
        }
    }

    function yy_find_reduce_action($stateno, $iLookAhead)
    {
        /* $stateno = $this->yystack[$this->yyidx]->stateno; */

        if (!isset(self::$yy_reduce_ofst[$stateno])) {
            return self::$yy_default[$stateno];
        }
        $i = self::$yy_reduce_ofst[$stateno];
        if ($i == self::YY_REDUCE_USE_DFLT) {
            return self::$yy_default[$stateno];
        }
        if ($iLookAhead == self::YYNOCODE) {
            return self::YY_NO_ACTION;
        }
        $i += $iLookAhead;
        if ($i < 0 || $i >= self::YY_SZ_ACTTAB ||
              self::$yy_lookahead[$i] != $iLookAhead) {
            return self::$yy_default[$stateno];
        } else {
            return self::$yy_action[$i];
        }
    }

    function yy_shift($yyNewState, $yyMajor, $yypMinor)
    {
        $this->yyidx++;
        if ($this->yyidx >= self::YYSTACKDEPTH) {
            $this->yyidx--;
            if (self::$yyTraceFILE) {
                fprintf(self::$yyTraceFILE, "%sStack Overflow!\n", self::$yyTracePrompt);
            }
            while ($this->yyidx >= 0) {
                $this->yy_pop_parser_stack();
            }
#line 84 "smarty_internal_templateparser.y"

    $this->internalError = true;
    $this->compiler->trigger_template_error("Stack overflow in template parser");
#line 1724 "smarty_internal_templateparser.php"
            return;
        }
        $yytos = new TP_yyStackEntry;
        $yytos->stateno = $yyNewState;
        $yytos->major = $yyMajor;
        $yytos->minor = $yypMinor;
        array_push($this->yystack, $yytos);
        if (self::$yyTraceFILE && $this->yyidx > 0) {
            fprintf(self::$yyTraceFILE, "%sShift %d\n", self::$yyTracePrompt,
                $yyNewState);
            fprintf(self::$yyTraceFILE, "%sStack:", self::$yyTracePrompt);
            for($i = 1; $i <= $this->yyidx; $i++) {
                fprintf(self::$yyTraceFILE, " %s",
                    $this->yyTokenName[$this->yystack[$i]->major]);
            }
            fwrite(self::$yyTraceFILE,"\n");
        }
    }

    static public $yyRuleInfo = array(
  array( 'lhs' => 82, 'rhs' => 1 ),
  array( 'lhs' => 83, 'rhs' => 1 ),
  array( 'lhs' => 83, 'rhs' => 2 ),
  array( 'lhs' => 83, 'rhs' => 0 ),
  array( 'lhs' => 84, 'rhs' => 1 ),
  array( 'lhs' => 84, 'rhs' => 1 ),
  array( 'lhs' => 84, 'rhs' => 1 ),
  array( 'lhs' => 84, 'rhs' => 1 ),
  array( 'lhs' => 84, 'rhs' => 1 ),
  array( 'lhs' => 84, 'rhs' => 1 ),
  array( 'lhs' => 84, 'rhs' => 1 ),
  array( 'lhs' => 84, 'rhs' => 1 ),
  array( 'lhs' => 84, 'rhs' => 1 ),
  array( 'lhs' => 84, 'rhs' => 1 ),
  array( 'lhs' => 84, 'rhs' => 1 ),
  array( 'lhs' => 84, 'rhs' => 1 ),
  array( 'lhs' => 86, 'rhs' => 2 ),
  array( 'lhs' => 86, 'rhs' => 3 ),
  array( 'lhs' => 87, 'rhs' => 2 ),
  array( 'lhs' => 87, 'rhs' => 0 ),
  array( 'lhs' => 88, 'rhs' => 1 ),
  array( 'lhs' => 88, 'rhs' => 1 ),
  array( 'lhs' => 88, 'rhs' => 1 ),
  array( 'lhs' => 88, 'rhs' => 1 ),
  array( 'lhs' => 88, 'rhs' => 1 ),
  array( 'lhs' => 88, 'rhs' => 1 ),
  array( 'lhs' => 88, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 3 ),
  array( 'lhs' => 85, 'rhs' => 5 ),
  array( 'lhs' => 85, 'rhs' => 4 ),
  array( 'lhs' => 85, 'rhs' => 5 ),
  array( 'lhs' => 85, 'rhs' => 4 ),
  array( 'lhs' => 85, 'rhs' => 6 ),
  array( 'lhs' => 85, 'rhs' => 6 ),
  array( 'lhs' => 85, 'rhs' => 7 ),
  array( 'lhs' => 85, 'rhs' => 6 ),
  array( 'lhs' => 85, 'rhs' => 4 ),
  array( 'lhs' => 85, 'rhs' => 3 ),
  array( 'lhs' => 85, 'rhs' => 6 ),
  array( 'lhs' => 85, 'rhs' => 5 ),
  array( 'lhs' => 85, 'rhs' => 7 ),
  array( 'lhs' => 85, 'rhs' => 3 ),
  array( 'lhs' => 85, 'rhs' => 4 ),
  array( 'lhs' => 85, 'rhs' => 3 ),
  array( 'lhs' => 85, 'rhs' => 4 ),
  array( 'lhs' => 85, 'rhs' => 12 ),
  array( 'lhs' => 98, 'rhs' => 2 ),
  array( 'lhs' => 98, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 6 ),
  array( 'lhs' => 85, 'rhs' => 8 ),
  array( 'lhs' => 85, 'rhs' => 3 ),
  array( 'lhs' => 85, 'rhs' => 8 ),
  array( 'lhs' => 85, 'rhs' => 11 ),
  array( 'lhs' => 85, 'rhs' => 8 ),
  array( 'lhs' => 85, 'rhs' => 11 ),
  array( 'lhs' => 85, 'rhs' => 4 ),
  array( 'lhs' => 85, 'rhs' => 5 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 3 ),
  array( 'lhs' => 85, 'rhs' => 4 ),
  array( 'lhs' => 85, 'rhs' => 5 ),
  array( 'lhs' => 85, 'rhs' => 6 ),
  array( 'lhs' => 91, 'rhs' => 2 ),
  array( 'lhs' => 91, 'rhs' => 1 ),
  array( 'lhs' => 91, 'rhs' => 0 ),
  array( 'lhs' => 100, 'rhs' => 4 ),
  array( 'lhs' => 100, 'rhs' => 2 ),
  array( 'lhs' => 100, 'rhs' => 2 ),
  array( 'lhs' => 100, 'rhs' => 2 ),
  array( 'lhs' => 100, 'rhs' => 2 ),
  array( 'lhs' => 100, 'rhs' => 2 ),
  array( 'lhs' => 100, 'rhs' => 4 ),
  array( 'lhs' => 95, 'rhs' => 1 ),
  array( 'lhs' => 95, 'rhs' => 3 ),
  array( 'lhs' => 94, 'rhs' => 4 ),
  array( 'lhs' => 94, 'rhs' => 3 ),
  array( 'lhs' => 94, 'rhs' => 3 ),
  array( 'lhs' => 92, 'rhs' => 1 ),
  array( 'lhs' => 92, 'rhs' => 1 ),
  array( 'lhs' => 92, 'rhs' => 4 ),
  array( 'lhs' => 92, 'rhs' => 3 ),
  array( 'lhs' => 92, 'rhs' => 3 ),
  array( 'lhs' => 92, 'rhs' => 3 ),
  array( 'lhs' => 92, 'rhs' => 1 ),
  array( 'lhs' => 92, 'rhs' => 2 ),
  array( 'lhs' => 92, 'rhs' => 3 ),
  array( 'lhs' => 92, 'rhs' => 3 ),
  array( 'lhs' => 92, 'rhs' => 3 ),
  array( 'lhs' => 92, 'rhs' => 3 ),
  array( 'lhs' => 92, 'rhs' => 3 ),
  array( 'lhs' => 92, 'rhs' => 3 ),
  array( 'lhs' => 92, 'rhs' => 2 ),
  array( 'lhs' => 92, 'rhs' => 2 ),
  array( 'lhs' => 92, 'rhs' => 3 ),
  array( 'lhs' => 92, 'rhs' => 3 ),
  array( 'lhs' => 92, 'rhs' => 2 ),
  array( 'lhs' => 92, 'rhs' => 2 ),
  array( 'lhs' => 92, 'rhs' => 3 ),
  array( 'lhs' => 92, 'rhs' => 3 ),
  array( 'lhs' => 92, 'rhs' => 3 ),
  array( 'lhs' => 92, 'rhs' => 3 ),
  array( 'lhs' => 101, 'rhs' => 8 ),
  array( 'lhs' => 101, 'rhs' => 7 ),
  array( 'lhs' => 89, 'rhs' => 1 ),
  array( 'lhs' => 89, 'rhs' => 2 ),
  array( 'lhs' => 89, 'rhs' => 2 ),
  array( 'lhs' => 89, 'rhs' => 2 ),
  array( 'lhs' => 89, 'rhs' => 2 ),
  array( 'lhs' => 89, 'rhs' => 1 ),
  array( 'lhs' => 89, 'rhs' => 1 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 89, 'rhs' => 2 ),
  array( 'lhs' => 89, 'rhs' => 2 ),
  array( 'lhs' => 89, 'rhs' => 1 ),
  array( 'lhs' => 89, 'rhs' => 1 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 89, 'rhs' => 1 ),
  array( 'lhs' => 89, 'rhs' => 1 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 89, 'rhs' => 1 ),
  array( 'lhs' => 89, 'rhs' => 2 ),
  array( 'lhs' => 105, 'rhs' => 1 ),
  array( 'lhs' => 105, 'rhs' => 4 ),
  array( 'lhs' => 105, 'rhs' => 1 ),
  array( 'lhs' => 105, 'rhs' => 3 ),
  array( 'lhs' => 105, 'rhs' => 4 ),
  array( 'lhs' => 105, 'rhs' => 3 ),
  array( 'lhs' => 105, 'rhs' => 4 ),
  array( 'lhs' => 93, 'rhs' => 3 ),
  array( 'lhs' => 110, 'rhs' => 2 ),
  array( 'lhs' => 110, 'rhs' => 0 ),
  array( 'lhs' => 111, 'rhs' => 3 ),
  array( 'lhs' => 111, 'rhs' => 5 ),
  array( 'lhs' => 111, 'rhs' => 2 ),
  array( 'lhs' => 111, 'rhs' => 2 ),
  array( 'lhs' => 111, 'rhs' => 4 ),
  array( 'lhs' => 111, 'rhs' => 3 ),
  array( 'lhs' => 111, 'rhs' => 5 ),
  array( 'lhs' => 111, 'rhs' => 3 ),
  array( 'lhs' => 111, 'rhs' => 2 ),
  array( 'lhs' => 97, 'rhs' => 1 ),
  array( 'lhs' => 97, 'rhs' => 2 ),
  array( 'lhs' => 112, 'rhs' => 1 ),
  array( 'lhs' => 112, 'rhs' => 3 ),
  array( 'lhs' => 109, 'rhs' => 2 ),
  array( 'lhs' => 113, 'rhs' => 1 ),
  array( 'lhs' => 113, 'rhs' => 2 ),
  array( 'lhs' => 114, 'rhs' => 3 ),
  array( 'lhs' => 114, 'rhs' => 4 ),
  array( 'lhs' => 114, 'rhs' => 5 ),
  array( 'lhs' => 114, 'rhs' => 6 ),
  array( 'lhs' => 114, 'rhs' => 2 ),
  array( 'lhs' => 106, 'rhs' => 4 ),
  array( 'lhs' => 115, 'rhs' => 4 ),
  array( 'lhs' => 115, 'rhs' => 5 ),
  array( 'lhs' => 116, 'rhs' => 3 ),
  array( 'lhs' => 116, 'rhs' => 1 ),
  array( 'lhs' => 116, 'rhs' => 0 ),
  array( 'lhs' => 90, 'rhs' => 3 ),
  array( 'lhs' => 90, 'rhs' => 2 ),
  array( 'lhs' => 117, 'rhs' => 3 ),
  array( 'lhs' => 117, 'rhs' => 2 ),
  array( 'lhs' => 99, 'rhs' => 2 ),
  array( 'lhs' => 99, 'rhs' => 0 ),
  array( 'lhs' => 118, 'rhs' => 2 ),
  array( 'lhs' => 118, 'rhs' => 2 ),
  array( 'lhs' => 108, 'rhs' => 1 ),
  array( 'lhs' => 108, 'rhs' => 2 ),
  array( 'lhs' => 108, 'rhs' => 1 ),
  array( 'lhs' => 108, 'rhs' => 3 ),
  array( 'lhs' => 108, 'rhs' => 4 ),
  array( 'lhs' => 103, 'rhs' => 1 ),
  array( 'lhs' => 103, 'rhs' => 1 ),
  array( 'lhs' => 103, 'rhs' => 1 ),
  array( 'lhs' => 103, 'rhs' => 1 ),
  array( 'lhs' => 103, 'rhs' => 1 ),
  array( 'lhs' => 103, 'rhs' => 1 ),
  array( 'lhs' => 103, 'rhs' => 1 ),
  array( 'lhs' => 103, 'rhs' => 1 ),
  array( 'lhs' => 103, 'rhs' => 1 ),
  array( 'lhs' => 104, 'rhs' => 1 ),
  array( 'lhs' => 104, 'rhs' => 1 ),
  array( 'lhs' => 104, 'rhs' => 1 ),
  array( 'lhs' => 102, 'rhs' => 3 ),
  array( 'lhs' => 119, 'rhs' => 1 ),
  array( 'lhs' => 119, 'rhs' => 3 ),
  array( 'lhs' => 119, 'rhs' => 0 ),
  array( 'lhs' => 120, 'rhs' => 3 ),
  array( 'lhs' => 120, 'rhs' => 3 ),
  array( 'lhs' => 120, 'rhs' => 1 ),
  array( 'lhs' => 107, 'rhs' => 2 ),
  array( 'lhs' => 107, 'rhs' => 3 ),
  array( 'lhs' => 121, 'rhs' => 2 ),
  array( 'lhs' => 121, 'rhs' => 1 ),
  array( 'lhs' => 122, 'rhs' => 3 ),
  array( 'lhs' => 122, 'rhs' => 3 ),
  array( 'lhs' => 122, 'rhs' => 1 ),
  array( 'lhs' => 122, 'rhs' => 3 ),
  array( 'lhs' => 122, 'rhs' => 3 ),
  array( 'lhs' => 122, 'rhs' => 1 ),
  array( 'lhs' => 122, 'rhs' => 1 ),
  array( 'lhs' => 96, 'rhs' => 1 ),
  array( 'lhs' => 96, 'rhs' => 0 ),
    );

    static public $yyReduceMap = array(
        0 => 0,
        1 => 1,
        2 => 1,
        4 => 4,
        5 => 5,
        6 => 6,
        7 => 7,
        8 => 8,
        9 => 9,
        10 => 10,
        11 => 11,
        12 => 12,
        13 => 13,
        14 => 14,
        15 => 15,
        16 => 16,
        19 => 16,
        203 => 16,
        17 => 17,
        76 => 17,
        18 => 18,
        104 => 18,
        106 => 18,
        107 => 18,
        130 => 18,
        168 => 18,
        20 => 20,
        21 => 20,
        47 => 20,
        69 => 20,
        70 => 20,
        77 => 20,
        78 => 20,
        83 => 20,
        103 => 20,
        108 => 20,
        109 => 20,
        114 => 20,
        116 => 20,
        117 => 20,
        124 => 20,
        141 => 20,
        167 => 20,
        169 => 20,
        185 => 20,
        190 => 20,
        202 => 20,
        22 => 22,
        23 => 22,
        24 => 24,
        25 => 25,
        26 => 26,
        27 => 27,
        28 => 28,
        29 => 29,
        31 => 29,
        30 => 30,
        32 => 32,
        33 => 32,
        34 => 34,
        35 => 35,
        36 => 36,
        37 => 37,
        38 => 38,
        39 => 39,
        40 => 40,
        41 => 41,
        42 => 42,
        44 => 42,
        43 => 43,
        45 => 45,
        46 => 46,
        48 => 48,
        49 => 49,
        50 => 50,
        51 => 51,
        52 => 52,
        53 => 53,
        54 => 54,
        55 => 55,
        56 => 56,
        57 => 57,
        58 => 58,
        59 => 59,
        60 => 60,
        61 => 61,
        62 => 62,
        63 => 63,
        72 => 63,
        157 => 63,
        161 => 63,
        165 => 63,
        166 => 63,
        64 => 64,
        158 => 64,
        164 => 64,
        65 => 65,
        66 => 66,
        67 => 66,
        68 => 68,
        71 => 71,
        73 => 73,
        74 => 74,
        75 => 74,
        79 => 79,
        80 => 80,
        81 => 80,
        82 => 80,
        84 => 84,
        121 => 84,
        85 => 85,
        88 => 85,
        99 => 85,
        86 => 86,
        87 => 87,
        89 => 89,
        90 => 90,
        91 => 91,
        96 => 91,
        92 => 92,
        95 => 92,
        93 => 93,
        98 => 93,
        94 => 94,
        97 => 94,
        100 => 100,
        101 => 101,
        102 => 102,
        105 => 105,
        110 => 110,
        111 => 111,
        112 => 112,
        113 => 113,
        115 => 115,
        118 => 118,
        119 => 119,
        120 => 120,
        122 => 122,
        123 => 123,
        125 => 125,
        126 => 126,
        127 => 127,
        128 => 128,
        129 => 129,
        131 => 131,
        187 => 131,
        132 => 132,
        133 => 133,
        134 => 134,
        135 => 135,
        136 => 136,
        139 => 136,
        137 => 137,
        138 => 138,
        140 => 140,
        142 => 142,
        143 => 143,
        144 => 144,
        145 => 145,
        146 => 146,
        147 => 147,
        148 => 148,
        149 => 149,
        150 => 150,
        151 => 151,
        152 => 152,
        153 => 153,
        154 => 154,
        155 => 155,
        156 => 156,
        159 => 159,
        160 => 160,
        162 => 162,
        163 => 163,
        170 => 170,
        171 => 171,
        172 => 172,
        173 => 173,
        174 => 174,
        175 => 175,
        176 => 176,
        177 => 177,
        178 => 178,
        179 => 179,
        180 => 180,
        181 => 181,
        182 => 182,
        183 => 183,
        184 => 184,
        186 => 186,
        188 => 188,
        189 => 189,
        191 => 191,
        192 => 192,
        193 => 193,
        194 => 194,
        195 => 195,
        196 => 195,
        198 => 195,
        197 => 197,
        199 => 199,
        200 => 200,
        201 => 201,
    );
#line 95 "smarty_internal_templateparser.y"
    function yy_r0(){
    $this->_retvalue = $this->root_buffer->to_smarty_php();
    }
#line 2160 "smarty_internal_templateparser.php"
#line 103 "smarty_internal_templateparser.y"
    function yy_r1(){
    $this->current_buffer->append_subtree($this->yystack[$this->yyidx + 0]->minor);
    }
#line 2165 "smarty_internal_templateparser.php"
#line 119 "smarty_internal_templateparser.y"
    function yy_r4(){
    if ($this->compiler->has_code) {
        $tmp =''; foreach ($this->compiler->prefix_code as $code) {$tmp.=$code;} $this->compiler->prefix_code=array();
        $this->_retvalue = new _smarty_tag($this, $this->compiler->processNocacheCode($tmp.$this->yystack[$this->yyidx + 0]->minor,true));
    } else {
        $this->_retvalue = new _smarty_tag($this, $this->yystack[$this->yyidx + 0]->minor);
    }
    $this->compiler->has_variable_string = false;
    $this->block_nesting_level = count($this->compiler->_tag_stack);
    }
#line 2177 "smarty_internal_templateparser.php"
#line 131 "smarty_internal_templateparser.y"
    function yy_r5(){
    $this->_retvalue = new _smarty_tag($this, '');
    }
#line 2182 "smarty_internal_templateparser.php"
#line 136 "smarty_internal_templateparser.y"
    function yy_r6(){
    $this->_retvalue = new _smarty_text($this, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 2187 "smarty_internal_templateparser.php"
#line 141 "smarty_internal_templateparser.y"
    function yy_r7(){
    if ($this->php_handling == Smarty::PHP_PASSTHRU) {
        $this->_retvalue = new _smarty_text($this, self::escape_start_tag($this->yystack[$this->yyidx + 0]->minor));
    } elseif ($this->php_handling == Smarty::PHP_QUOTE) {
        $this->_retvalue = new _smarty_text($this, htmlspecialchars($this->yystack[$this->yyidx + 0]->minor, ENT_QUOTES));
    } elseif ($this->php_handling == Smarty::PHP_ALLOW) {
        if (!($this->smarty instanceof SmartyBC)) {
            $this->compiler->trigger_template_error (self::Err3);
        }
        $this->_retvalue = new _smarty_text($this, $this->compiler->processNocacheCode('<?php', true));
    } elseif ($this->php_handling == Smarty::PHP_REMOVE) {
        $this->_retvalue = new _smarty_text($this, '');
    }
    }
#line 2203 "smarty_internal_templateparser.php"
#line 157 "smarty_internal_templateparser.y"
    function yy_r8(){
    if ($this->is_xml) {
        $this->compiler->tag_nocache = true;
        $this->is_xml = false;
        $save = $this->template->has_nocache_code;
        $this->_retvalue = new _smarty_text($this, $this->compiler->processNocacheCode("<?php echo '?>';?>\n", $this->compiler, true));
        $this->template->has_nocache_code = $save;
    } elseif ($this->php_handling == Smarty::PHP_PASSTHRU) {
        $this->_retvalue = new _smarty_text($this, '?<?php ?>>');
    } elseif ($this->php_handling == Smarty::PHP_QUOTE) {
        $this->_retvalue = new _smarty_text($this, htmlspecialchars('?>', ENT_QUOTES));
    } elseif ($this->php_handling == Smarty::PHP_ALLOW) {
        $this->_retvalue = new _smarty_text($this, $this->compiler->processNocacheCode('?>', true));
    } elseif ($this->php_handling == Smarty::PHP_REMOVE) {
        $this->_retvalue = new _smarty_text($this, '');
    }
    }
#line 2222 "smarty_internal_templateparser.php"
#line 176 "smarty_internal_templateparser.y"
    function yy_r9(){
    if ($this->php_handling == Smarty::PHP_PASSTHRU) {
        $this->_retvalue = new _smarty_text($this, '<<?php ?>%');
    } elseif ($this->php_handling == Smarty::PHP_QUOTE) {
        $this->_retvalue = new _smarty_text($this, htmlspecialchars($this->yystack[$this->yyidx + 0]->minor, ENT_QUOTES));
    } elseif ($this->php_handling == Smarty::PHP_ALLOW) {
        if ($this->asp_tags) {
            if (!($this->smarty instanceof SmartyBC)) {
                $this->compiler->trigger_template_error (self::Err3);
            }
            $this->_retvalue = new _smarty_text($this, $this->compiler->processNocacheCode('<%', true));
        } else {
            $this->_retvalue = new _smarty_text($this, '<<?php ?>%');
        }
    } elseif ($this->php_handling == Smarty::PHP_REMOVE) {
        if ($this->asp_tags) {
            $this->_retvalue = new _smarty_text($this, '');
        } else {
            $this->_retvalue = new _smarty_text($this, '<<?php ?>%');
        }
    }
    }
#line 2246 "smarty_internal_templateparser.php"
#line 200 "smarty_internal_templateparser.y"
    function yy_r10(){
    if ($this->php_handling == Smarty::PHP_PASSTHRU) {
        $this->_retvalue = new _smarty_text($this, '%<?php ?>>');
    } elseif ($this->php_handling == Smarty::PHP_QUOTE) {
        $this->_retvalue = new _smarty_text($this, htmlspecialchars('%>', ENT_QUOTES));
    } elseif ($this->php_handling == Smarty::PHP_ALLOW) {
        if ($this->asp_tags) {
            $this->_retvalue = new _smarty_text($this, $this->compiler->processNocacheCode('%>', true));
        } else {
            $this->_retvalue = new _smarty_text($this, '%<?php ?>>');
        }
    } elseif ($this->php_handling == Smarty::PHP_REMOVE) {
        if ($this->asp_tags) {
            $this->_retvalue = new _smarty_text($this, '');
        } else {
            $this->_retvalue = new _smarty_text($this, '%<?php ?>>');
        }
    }
    }
#line 2267 "smarty_internal_templateparser.php"
#line 220 "smarty_internal_templateparser.y"
    function yy_r11(){
    if ($this->strip) {
        $this->_retvalue = new _smarty_text($this, preg_replace('![\t ]*[\r\n]+[\t ]*!', '', self::escape_start_tag($this->yystack[$this->yyidx + 0]->minor)));
    } else {
        $this->_retvalue = new _smarty_text($this, self::escape_start_tag($this->yystack[$this->yyidx + 0]->minor));
    }
    }
#line 2276 "smarty_internal_templateparser.php"
#line 229 "smarty_internal_templateparser.y"
    function yy_r12(){
    $this->compiler->tag_nocache = true;
    $this->is_xml = true;
    $save = $this->template->has_nocache_code;
    $this->_retvalue = new _smarty_text($this, $this->compiler->processNocacheCode("<?php echo '<?xml';?>", $this->compiler, true));
    $this->template->has_nocache_code = $save;
    }
#line 2285 "smarty_internal_templateparser.php"
#line 238 "smarty_internal_templateparser.y"
    function yy_r13(){
    if ($this->strip) {
        $this->_retvalue = new _smarty_text($this, preg_replace('![\t ]*[\r\n]+[\t ]*!', '', $this->yystack[$this->yyidx + 0]->minor));
    } else {
        $this->_retvalue = new _smarty_text($this, $this->yystack[$this->yyidx + 0]->minor);
    }
    }
#line 2294 "smarty_internal_templateparser.php"
#line 247 "smarty_internal_templateparser.y"
    function yy_r14(){
    $this->strip = true;
    $this->_retvalue = new _smarty_text($this, '');
    }
#line 2300 "smarty_internal_templateparser.php"
#line 252 "smarty_internal_templateparser.y"
    function yy_r15(){
    $this->strip = false;
    $this->_retvalue = new _smarty_text($this, '');
    }
#line 2306 "smarty_internal_templateparser.php"
#line 258 "smarty_internal_templateparser.y"
    function yy_r16(){
    $this->_retvalue = '';
    }
#line 2311 "smarty_internal_templateparser.php"
#line 262 "smarty_internal_templateparser.y"
    function yy_r17(){
    $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor;
    }
#line 2316 "smarty_internal_templateparser.php"
#line 266 "smarty_internal_templateparser.y"
    function yy_r18(){
    $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 2321 "smarty_internal_templateparser.php"
#line 274 "smarty_internal_templateparser.y"
    function yy_r20(){
    $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 2326 "smarty_internal_templateparser.php"
#line 282 "smarty_internal_templateparser.y"
    function yy_r22(){
    $this->_retvalue = self::escape_start_tag($this->yystack[$this->yyidx + 0]->minor);
    }
#line 2331 "smarty_internal_templateparser.php"
#line 290 "smarty_internal_templateparser.y"
    function yy_r24(){
    $this->_retvalue = self::escape_end_tag($this->yystack[$this->yyidx + 0]->minor);
    }
#line 2336 "smarty_internal_templateparser.php"
#line 294 "smarty_internal_templateparser.y"
    function yy_r25(){
    $this->_retvalue = '<<?php ?>%';
    }
#line 2341 "smarty_internal_templateparser.php"
#line 298 "smarty_internal_templateparser.y"
    function yy_r26(){
    $this->_retvalue = '%<?php ?>>';
    }
#line 2346 "smarty_internal_templateparser.php"
#line 307 "smarty_internal_templateparser.y"
    function yy_r27(){
    $this->_retvalue = $this->compiler->compileTag('private_print_expression',array(),array('value'=>$this->yystack[$this->yyidx + -1]->minor));
    }
#line 2351 "smarty_internal_templateparser.php"
#line 311 "smarty_internal_templateparser.y"
    function yy_r28(){
    $this->_retvalue = $this->compiler->compileTag('private_print_expression',$this->yystack[$this->yyidx + -1]->minor,array('value'=>$this->yystack[$this->yyidx + -3]->minor, 'modifierlist'=>$this->yystack[$this->yyidx + -2]->minor));
    }
#line 2356 "smarty_internal_templateparser.php"
#line 315 "smarty_internal_templateparser.y"
    function yy_r29(){
    $this->_retvalue = $this->compiler->compileTag('private_print_expression',$this->yystack[$this->yyidx + -1]->minor,array('value'=>$this->yystack[$this->yyidx + -2]->minor));
    }
#line 2361 "smarty_internal_templateparser.php"
#line 319 "smarty_internal_templateparser.y"
    function yy_r30(){
    $this->_retvalue = $this->compiler->compileTag('private_print_expression',$this->yystack[$this->yyidx + -1]->minor,array('value'=>$this->yystack[$this->yyidx + -3]->minor,'modifierlist'=>$this->yystack[$this->yyidx + -2]->minor));
    }
#line 2366 "smarty_internal_templateparser.php"
#line 332 "smarty_internal_templateparser.y"
    function yy_r32(){
    $this->_retvalue = $this->compiler->compileTag('assign',array(array('value'=>$this->yystack[$this->yyidx + -1]->minor),array('var'=>"'".$this->yystack[$this->yyidx + -3]->minor."'")));
    }
#line 2371 "smarty_internal_templateparser.php"
#line 340 "smarty_internal_templateparser.y"
    function yy_r34(){
    $this->_retvalue = $this->compiler->compileTag('assign',array_merge(array(array('value'=>$this->yystack[$this->yyidx + -2]->minor),array('var'=>"'".$this->yystack[$this->yyidx + -4]->minor."'")),$this->yystack[$this->yyidx + -1]->minor));
    }
#line 2376 "smarty_internal_templateparser.php"
#line 344 "smarty_internal_templateparser.y"
    function yy_r35(){
    $this->_retvalue = $this->compiler->compileTag('assign',array_merge(array(array('value'=>$this->yystack[$this->yyidx + -2]->minor),array('var'=>$this->yystack[$this->yyidx + -4]->minor['var'])),$this->yystack[$this->yyidx + -1]->minor),array('smarty_internal_index'=>$this->yystack[$this->yyidx + -4]->minor['smarty_internal_index']));
    }
#line 2381 "smarty_internal_templateparser.php"
#line 349 "smarty_internal_templateparser.y"
    function yy_r36(){
    $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -2]->minor,$this->yystack[$this->yyidx + -1]->minor);
    }
#line 2386 "smarty_internal_templateparser.php"
#line 353 "smarty_internal_templateparser.y"
    function yy_r37(){
    $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -1]->minor,array());
    }
#line 2391 "smarty_internal_templateparser.php"
#line 358 "smarty_internal_templateparser.y"
    function yy_r38(){
    $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -4]->minor,$this->yystack[$this->yyidx + -1]->minor,array('object_methode'=>$this->yystack[$this->yyidx + -2]->minor));
    }
#line 2396 "smarty_internal_templateparser.php"
#line 363 "smarty_internal_templateparser.y"
    function yy_r39(){
    $this->_retvalue = '<?php ob_start();?>'.$this->compiler->compileTag($this->yystack[$this->yyidx + -3]->minor,$this->yystack[$this->yyidx + -1]->minor).'<?php echo ';
    $this->_retvalue .= $this->compiler->compileTag('private_modifier',array(),array('modifierlist'=>$this->yystack[$this->yyidx + -2]->minor,'value'=>'ob_get_clean()')).'?>';
    }
#line 2402 "smarty_internal_templateparser.php"
#line 369 "smarty_internal_templateparser.y"
    function yy_r40(){
    $this->_retvalue = '<?php ob_start();?>'.$this->compiler->compileTag($this->yystack[$this->yyidx + -5]->minor,$this->yystack[$this->yyidx + -1]->minor,array('object_methode'=>$this->yystack[$this->yyidx + -3]->minor)).'<?php echo ';
    $this->_retvalue .= $this->compiler->compileTag('private_modifier',array(),array('modifierlist'=>$this->yystack[$this->yyidx + -2]->minor,'value'=>'ob_get_clean()')).'?>';
    }
#line 2408 "smarty_internal_templateparser.php"
#line 375 "smarty_internal_templateparser.y"
    function yy_r41(){
    $tag = trim(substr($this->yystack[$this->yyidx + -2]->minor,$this->lex->ldel_length));
    $this->_retvalue = $this->compiler->compileTag(($tag == 'else if')? 'elseif' : $tag,array(),array('if condition'=>$this->yystack[$this->yyidx + -1]->minor));
    }
#line 2414 "smarty_internal_templateparser.php"
#line 380 "smarty_internal_templateparser.y"
    function yy_r42(){
    $tag = trim(substr($this->yystack[$this->yyidx + -3]->minor,$this->lex->ldel_length));
    $this->_retvalue = $this->compiler->compileTag(($tag == 'else if')? 'elseif' : $tag,$this->yystack[$this->yyidx + -1]->minor,array('if condition'=>$this->yystack[$this->yyidx + -2]->minor));
    }
#line 2420 "smarty_internal_templateparser.php"
#line 385 "smarty_internal_templateparser.y"
    function yy_r43(){
    $tag = trim(substr($this->yystack[$this->yyidx + -2]->minor,$this->lex->ldel_length));
    $this->_retvalue = $this->compiler->compileTag(($tag == 'else if')? 'elseif' : $tag,array(),array('if condition'=>$this->yystack[$this->yyidx + -1]->minor));
    }
#line 2426 "smarty_internal_templateparser.php"
#line 396 "smarty_internal_templateparser.y"
    function yy_r45(){
    $this->_retvalue = $this->compiler->compileTag('for',array_merge($this->yystack[$this->yyidx + -1]->minor,array(array('start'=>$this->yystack[$this->yyidx + -10]->minor),array('ifexp'=>$this->yystack[$this->yyidx + -7]->minor),array('var'=>$this->yystack[$this->yyidx + -3]->minor),array('step'=>$this->yystack[$this->yyidx + -2]->minor))),1);
    }
#line 2431 "smarty_internal_templateparser.php"
#line 400 "smarty_internal_templateparser.y"
    function yy_r46(){
    $this->_retvalue = '='.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 2436 "smarty_internal_templateparser.php"
#line 408 "smarty_internal_templateparser.y"
    function yy_r48(){
    $this->_retvalue = $this->compiler->compileTag('for',array_merge($this->yystack[$this->yyidx + -1]->minor,array(array('start'=>$this->yystack[$this->yyidx + -4]->minor),array('to'=>$this->yystack[$this->yyidx + -2]->minor))),0);
    }
#line 2441 "smarty_internal_templateparser.php"
#line 412 "smarty_internal_templateparser.y"
    function yy_r49(){
    $this->_retvalue = $this->compiler->compileTag('for',array_merge($this->yystack[$this->yyidx + -1]->minor,array(array('start'=>$this->yystack[$this->yyidx + -6]->minor),array('to'=>$this->yystack[$this->yyidx + -4]->minor),array('step'=>$this->yystack[$this->yyidx + -2]->minor))),0);
    }
#line 2446 "smarty_internal_templateparser.php"
#line 417 "smarty_internal_templateparser.y"
    function yy_r50(){
    $this->_retvalue = $this->compiler->compileTag('foreach',$this->yystack[$this->yyidx + -1]->minor);
    }
#line 2451 "smarty_internal_templateparser.php"
#line 422 "smarty_internal_templateparser.y"
    function yy_r51(){
    $this->_retvalue = $this->compiler->compileTag('foreach',array_merge($this->yystack[$this->yyidx + -1]->minor,array(array('from'=>$this->yystack[$this->yyidx + -5]->minor),array('item'=>$this->yystack[$this->yyidx + -2]->minor))));
    }
#line 2456 "smarty_internal_templateparser.php"
#line 426 "smarty_internal_templateparser.y"
    function yy_r52(){
    $this->_retvalue = $this->compiler->compileTag('foreach',array_merge($this->yystack[$this->yyidx + -1]->minor,array(array('from'=>$this->yystack[$this->yyidx + -8]->minor),array('item'=>$this->yystack[$this->yyidx + -2]->minor),array('key'=>$this->yystack[$this->yyidx + -5]->minor))));
    }
#line 2461 "smarty_internal_templateparser.php"
#line 430 "smarty_internal_templateparser.y"
    function yy_r53(){
    $this->_retvalue = $this->compiler->compileTag('foreach',array_merge($this->yystack[$this->yyidx + -1]->minor,array(array('from'=>$this->yystack[$this->yyidx + -5]->minor),array('item'=>$this->yystack[$this->yyidx + -2]->minor))));
    }
#line 2466 "smarty_internal_templateparser.php"
#line 434 "smarty_internal_templateparser.y"
    function yy_r54(){
    $this->_retvalue = $this->compiler->compileTag('foreach',array_merge($this->yystack[$this->yyidx + -1]->minor,array(array('from'=>$this->yystack[$this->yyidx + -8]->minor),array('item'=>$this->yystack[$this->yyidx + -2]->minor),array('key'=>$this->yystack[$this->yyidx + -5]->minor))));
    }
#line 2471 "smarty_internal_templateparser.php"
#line 439 "smarty_internal_templateparser.y"
    function yy_r55(){
    $this->_retvalue = $this->compiler->compileTag('setfilter',array(),array('modifier_list'=>array(array_merge(array($this->yystack[$this->yyidx + -2]->minor),$this->yystack[$this->yyidx + -1]->minor))));
    }
#line 2476 "smarty_internal_templateparser.php"
#line 443 "smarty_internal_templateparser.y"
    function yy_r56(){
    $this->_retvalue = $this->compiler->compileTag('setfilter',array(),array('modifier_list'=>array_merge(array(array_merge(array($this->yystack[$this->yyidx + -3]->minor),$this->yystack[$this->yyidx + -2]->minor)),$this->yystack[$this->yyidx + -1]->minor)));
    }
#line 2481 "smarty_internal_templateparser.php"
#line 448 "smarty_internal_templateparser.y"
    function yy_r57(){
    $this->_retvalue = SMARTY_INTERNAL_COMPILE_BLOCK::compileChildBlock($this->compiler);
    }
#line 2486 "smarty_internal_templateparser.php"
#line 454 "smarty_internal_templateparser.y"
    function yy_r58(){
    $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -1]->minor.'close',array());
    }
#line 2491 "smarty_internal_templateparser.php"
#line 458 "smarty_internal_templateparser.y"
    function yy_r59(){
    $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -2]->minor.'close',array(),array('modifier_list'=>$this->yystack[$this->yyidx + -1]->minor));
    }
#line 2496 "smarty_internal_templateparser.php"
#line 463 "smarty_internal_templateparser.y"
    function yy_r60(){
    $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -3]->minor.'close',array(),array('object_methode'=>$this->yystack[$this->yyidx + -1]->minor));
    }
#line 2501 "smarty_internal_templateparser.php"
#line 467 "smarty_internal_templateparser.y"
    function yy_r61(){
    $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -4]->minor.'close',array(),array('object_methode'=>$this->yystack[$this->yyidx + -2]->minor, 'modifier_list'=>$this->yystack[$this->yyidx + -1]->minor));
    }
#line 2506 "smarty_internal_templateparser.php"
#line 475 "smarty_internal_templateparser.y"
    function yy_r62(){
    $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor;
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 2512 "smarty_internal_templateparser.php"
#line 481 "smarty_internal_templateparser.y"
    function yy_r63(){
    $this->_retvalue = array($this->yystack[$this->yyidx + 0]->minor);
    }
#line 2517 "smarty_internal_templateparser.php"
#line 486 "smarty_internal_templateparser.y"
    function yy_r64(){
    $this->_retvalue = array();
    }
#line 2522 "smarty_internal_templateparser.php"
#line 491 "smarty_internal_templateparser.y"
    function yy_r65(){
    if (preg_match('~^true$~i', $this->yystack[$this->yyidx + 0]->minor)) {
        $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>'true');
    } elseif (preg_match('~^false$~i', $this->yystack[$this->yyidx + 0]->minor)) {
        $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>'false');
    } elseif (preg_match('~^null$~i', $this->yystack[$this->yyidx + 0]->minor)) {
        $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>'null');
    } else {
        $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>"'".$this->yystack[$this->yyidx + 0]->minor."'");
    }
    }
#line 2535 "smarty_internal_templateparser.php"
#line 503 "smarty_internal_templateparser.y"
    function yy_r66(){
    $this->_retvalue = array(trim($this->yystack[$this->yyidx + -1]->minor," =\n\r\t")=>$this->yystack[$this->yyidx + 0]->minor);
    }
#line 2540 "smarty_internal_templateparser.php"
#line 511 "smarty_internal_templateparser.y"
    function yy_r68(){
    $this->_retvalue = "'".$this->yystack[$this->yyidx + 0]->minor."'";
    }
#line 2545 "smarty_internal_templateparser.php"
#line 523 "smarty_internal_templateparser.y"
    function yy_r71(){
    $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>$this->yystack[$this->yyidx + 0]->minor);
    }
#line 2550 "smarty_internal_templateparser.php"
#line 536 "smarty_internal_templateparser.y"
    function yy_r73(){
    $this->yystack[$this->yyidx + -2]->minor[]=$this->yystack[$this->yyidx + 0]->minor;
    $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor;
    }
#line 2556 "smarty_internal_templateparser.php"
#line 541 "smarty_internal_templateparser.y"
    function yy_r74(){
    $this->_retvalue = array('var' => $this->yystack[$this->yyidx + -2]->minor, 'value'=>$this->yystack[$this->yyidx + 0]->minor);
    }
#line 2561 "smarty_internal_templateparser.php"
#line 569 "smarty_internal_templateparser.y"
    function yy_r79(){
    $this->_retvalue = '$_smarty_tpl->getStreamVariable(\''. $this->yystack[$this->yyidx + -2]->minor .'://'. $this->yystack[$this->yyidx + 0]->minor . '\')';
    }
#line 2566 "smarty_internal_templateparser.php"
#line 574 "smarty_internal_templateparser.y"
    function yy_r80(){
    $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor . trim($this->yystack[$this->yyidx + -1]->minor) . $this->yystack[$this->yyidx + 0]->minor;
    }
#line 2571 "smarty_internal_templateparser.php"
#line 593 "smarty_internal_templateparser.y"
    function yy_r84(){
    $this->_retvalue = $this->compiler->compileTag('private_modifier',array(),array('value'=>$this->yystack[$this->yyidx + -1]->minor,'modifierlist'=>$this->yystack[$this->yyidx + 0]->minor));
    }
#line 2576 "smarty_internal_templateparser.php"
#line 599 "smarty_internal_templateparser.y"
    function yy_r85(){
    $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 2581 "smarty_internal_templateparser.php"
#line 603 "smarty_internal_templateparser.y"
    function yy_r86(){
    $this->_retvalue = 'in_array('.$this->yystack[$this->yyidx + -2]->minor.','.$this->yystack[$this->yyidx + 0]->minor.')';
    }
#line 2586 "smarty_internal_templateparser.php"
#line 607 "smarty_internal_templateparser.y"
    function yy_r87(){
    $this->_retvalue = 'in_array('.$this->yystack[$this->yyidx + -2]->minor.',(array)'.$this->yystack[$this->yyidx + 0]->minor.')';
    }
#line 2591 "smarty_internal_templateparser.php"
#line 615 "smarty_internal_templateparser.y"
    function yy_r89(){
    $this->_retvalue = '!('.$this->yystack[$this->yyidx + -2]->minor.' % '.$this->yystack[$this->yyidx + 0]->minor.')';
    }
#line 2596 "smarty_internal_templateparser.php"
#line 619 "smarty_internal_templateparser.y"
    function yy_r90(){
    $this->_retvalue = '('.$this->yystack[$this->yyidx + -2]->minor.' % '.$this->yystack[$this->yyidx + 0]->minor.')';
    }
#line 2601 "smarty_internal_templateparser.php"
#line 623 "smarty_internal_templateparser.y"
    function yy_r91(){
    $this->_retvalue = '!(1 & '.$this->yystack[$this->yyidx + -1]->minor.')';
    }
#line 2606 "smarty_internal_templateparser.php"
#line 627 "smarty_internal_templateparser.y"
    function yy_r92(){
    $this->_retvalue = '(1 & '.$this->yystack[$this->yyidx + -1]->minor.')';
    }
#line 2611 "smarty_internal_templateparser.php"
#line 631 "smarty_internal_templateparser.y"
    function yy_r93(){
    $this->_retvalue = '!(1 & '.$this->yystack[$this->yyidx + -2]->minor.' / '.$this->yystack[$this->yyidx + 0]->minor.')';
    }
#line 2616 "smarty_internal_templateparser.php"
#line 635 "smarty_internal_templateparser.y"
    function yy_r94(){
    $this->_retvalue = '(1 & '.$this->yystack[$this->yyidx + -2]->minor.' / '.$this->yystack[$this->yyidx + 0]->minor.')';
    }
#line 2621 "smarty_internal_templateparser.php"
#line 659 "smarty_internal_templateparser.y"
    function yy_r100(){
    $this->prefix_number++;
    $this->compiler->prefix_code[] = '<?php $_tmp'.$this->prefix_number.'='.$this->yystack[$this->yyidx + 0]->minor.';?>';
    $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + -1]->minor.'$_tmp'.$this->prefix_number;
    }
#line 2628 "smarty_internal_templateparser.php"
#line 668 "smarty_internal_templateparser.y"
    function yy_r101(){
    $this->_retvalue = $this->yystack[$this->yyidx + -6]->minor.' ? '. $this->compileVariable("'".$this->yystack[$this->yyidx + -2]->minor."'") . ' : '.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 2633 "smarty_internal_templateparser.php"
#line 672 "smarty_internal_templateparser.y"
    function yy_r102(){
    $this->_retvalue = $this->yystack[$this->yyidx + -5]->minor.' ? '.$this->yystack[$this->yyidx + -2]->minor.' : '.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 2638 "smarty_internal_templateparser.php"
#line 687 "smarty_internal_templateparser.y"
    function yy_r105(){
    $this->_retvalue = '!'.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 2643 "smarty_internal_templateparser.php"
#line 708 "smarty_internal_templateparser.y"
    function yy_r110(){
    $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.'.'.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 2648 "smarty_internal_templateparser.php"
#line 712 "smarty_internal_templateparser.y"
    function yy_r111(){
    $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.'.';
    }
#line 2653 "smarty_internal_templateparser.php"
#line 716 "smarty_internal_templateparser.y"
    function yy_r112(){
    $this->_retvalue = '.'.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 2658 "smarty_internal_templateparser.php"
#line 721 "smarty_internal_templateparser.y"
    function yy_r113(){
    if (preg_match('~^true$~i', $this->yystack[$this->yyidx + 0]->minor)) {
        $this->_retvalue = 'true';
    } elseif (preg_match('~^false$~i', $this->yystack[$this->yyidx + 0]->minor)) {
        $this->_retvalue = 'false';
    } elseif (preg_match('~^null$~i', $this->yystack[$this->yyidx + 0]->minor)) {
        $this->_retvalue = 'null';
    } else {
        $this->_retvalue = "'".$this->yystack[$this->yyidx + 0]->minor."'";
    }
    }
#line 2671 "smarty_internal_templateparser.php"
#line 739 "smarty_internal_templateparser.y"
    function yy_r115(){
    $this->_retvalue = "(". $this->yystack[$this->yyidx + -1]->minor .")";
    }
#line 2676 "smarty_internal_templateparser.php"
#line 754 "smarty_internal_templateparser.y"
    function yy_r118(){
    if (!$this->security || isset($this->smarty->registered_classes[$this->yystack[$this->yyidx + -2]->minor]) || $this->smarty->security_policy->isTrustedStaticClass($this->yystack[$this->yyidx + -2]->minor, $this->compiler)) {
        if (isset($this->smarty->registered_classes[$this->yystack[$this->yyidx + -2]->minor])) {
            $this->_retvalue = $this->smarty->registered_classes[$this->yystack[$this->yyidx + -2]->minor].'::'.$this->yystack[$this->yyidx + 0]->minor;
        } else {
            $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.'::'.$this->yystack[$this->yyidx + 0]->minor;
        }
    } else {
        $this->compiler->trigger_template_error ("static class '".$this->yystack[$this->yyidx + -2]->minor."' is undefined or not allowed by security setting");
    }
    }
#line 2689 "smarty_internal_templateparser.php"
#line 766 "smarty_internal_templateparser.y"
    function yy_r119(){
    if ($this->yystack[$this->yyidx + -2]->minor['var'] == '\'smarty\'') {
        $this->_retvalue =  $this->compiler->compileTag('private_special_variable',array(),$this->yystack[$this->yyidx + -2]->minor['smarty_internal_index']).'::'.$this->yystack[$this->yyidx + 0]->minor;
    } else {
        $this->_retvalue = $this->compileVariable($this->yystack[$this->yyidx + -2]->minor['var']).$this->yystack[$this->yyidx + -2]->minor['smarty_internal_index'].'::'.$this->yystack[$this->yyidx + 0]->minor;
    }
    }
#line 2698 "smarty_internal_templateparser.php"
#line 775 "smarty_internal_templateparser.y"
    function yy_r120(){
    $this->prefix_number++;
    $this->compiler->prefix_code[] = '<?php ob_start();?>'.$this->yystack[$this->yyidx + 0]->minor.'<?php $_tmp'.$this->prefix_number.'=ob_get_clean();?>';
    $this->_retvalue = '$_tmp'.$this->prefix_number;
    }
#line 2705 "smarty_internal_templateparser.php"
#line 790 "smarty_internal_templateparser.y"
    function yy_r122(){
    if ($this->yystack[$this->yyidx + 0]->minor['var'] == '\'smarty\'') {
        $smarty_var = $this->compiler->compileTag('private_special_variable',array(),$this->yystack[$this->yyidx + 0]->minor['smarty_internal_index']);
        $this->_retvalue = $smarty_var;
    } else {
        // used for array reset,next,prev,end,current
        $this->last_variable = $this->yystack[$this->yyidx + 0]->minor['var'];
        $this->last_index = $this->yystack[$this->yyidx + 0]->minor['smarty_internal_index'];
        $this->_retvalue = $this->compileVariable($this->yystack[$this->yyidx + 0]->minor['var']).$this->yystack[$this->yyidx + 0]->minor['smarty_internal_index'];
    }
    }
#line 2718 "smarty_internal_templateparser.php"
#line 803 "smarty_internal_templateparser.y"
    function yy_r123(){
    $this->_retvalue = '$_smarty_tpl->tpl_vars['. $this->yystack[$this->yyidx + -2]->minor .']->'.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 2723 "smarty_internal_templateparser.php"
#line 813 "smarty_internal_templateparser.y"
    function yy_r125(){
    $this->_retvalue = '$_smarty_tpl->getConfigVariable(\''. $this->yystack[$this->yyidx + -1]->minor .'\')';
    }
#line 2728 "smarty_internal_templateparser.php"
#line 817 "smarty_internal_templateparser.y"
    function yy_r126(){
    $this->_retvalue = '(is_array($tmp = $_smarty_tpl->getConfigVariable(\''. $this->yystack[$this->yyidx + -2]->minor .'\')) ? $tmp'.$this->yystack[$this->yyidx + 0]->minor.' :null)';
    }
#line 2733 "smarty_internal_templateparser.php"
#line 821 "smarty_internal_templateparser.y"
    function yy_r127(){
    $this->_retvalue = '$_smarty_tpl->getConfigVariable('. $this->yystack[$this->yyidx + -1]->minor .')';
    }
#line 2738 "smarty_internal_templateparser.php"
#line 825 "smarty_internal_templateparser.y"
    function yy_r128(){
    $this->_retvalue = '(is_array($tmp = $_smarty_tpl->getConfigVariable('. $this->yystack[$this->yyidx + -2]->minor .')) ? $tmp'.$this->yystack[$this->yyidx + 0]->minor.' : null)';
    }
#line 2743 "smarty_internal_templateparser.php"
#line 829 "smarty_internal_templateparser.y"
    function yy_r129(){
    $this->_retvalue = array('var'=>$this->yystack[$this->yyidx + -1]->minor, 'smarty_internal_index'=>$this->yystack[$this->yyidx + 0]->minor);
    }
#line 2748 "smarty_internal_templateparser.php"
#line 842 "smarty_internal_templateparser.y"
    function yy_r131(){
    return;
    }
#line 2753 "smarty_internal_templateparser.php"
#line 848 "smarty_internal_templateparser.y"
    function yy_r132(){
    $this->_retvalue = '['.$this->compileVariable($this->yystack[$this->yyidx + 0]->minor).']';
    }
#line 2758 "smarty_internal_templateparser.php"
#line 852 "smarty_internal_templateparser.y"
    function yy_r133(){
    $this->_retvalue = '['.$this->compileVariable($this->yystack[$this->yyidx + -2]->minor).'->'.$this->yystack[$this->yyidx + 0]->minor.']';
    }
#line 2763 "smarty_internal_templateparser.php"
#line 856 "smarty_internal_templateparser.y"
    function yy_r134(){
    $this->_retvalue = "['". $this->yystack[$this->yyidx + 0]->minor ."']";
    }
#line 2768 "smarty_internal_templateparser.php"
#line 860 "smarty_internal_templateparser.y"
    function yy_r135(){
    $this->_retvalue = "[". $this->yystack[$this->yyidx + 0]->minor ."]";
    }
#line 2773 "smarty_internal_templateparser.php"
#line 864 "smarty_internal_templateparser.y"
    function yy_r136(){
    $this->_retvalue = "[". $this->yystack[$this->yyidx + -1]->minor ."]";
    }
#line 2778 "smarty_internal_templateparser.php"
#line 869 "smarty_internal_templateparser.y"
    function yy_r137(){
    $this->_retvalue = '['.$this->compiler->compileTag('private_special_variable',array(),'[\'section\'][\''.$this->yystack[$this->yyidx + -1]->minor.'\'][\'index\']').']';
    }
#line 2783 "smarty_internal_templateparser.php"
#line 873 "smarty_internal_templateparser.y"
    function yy_r138(){
    $this->_retvalue = '['.$this->compiler->compileTag('private_special_variable',array(),'[\'section\'][\''.$this->yystack[$this->yyidx + -3]->minor.'\'][\''.$this->yystack[$this->yyidx + -1]->minor.'\']').']';
    }
#line 2788 "smarty_internal_templateparser.php"
#line 883 "smarty_internal_templateparser.y"
    function yy_r140(){
    $this->_retvalue = '[]';
    }
#line 2793 "smarty_internal_templateparser.php"
#line 896 "smarty_internal_templateparser.y"
    function yy_r142(){
    $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.'.'.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 2798 "smarty_internal_templateparser.php"
#line 901 "smarty_internal_templateparser.y"
    function yy_r143(){
    $this->_retvalue = '\''.$this->yystack[$this->yyidx + 0]->minor.'\'';
    }
#line 2803 "smarty_internal_templateparser.php"
#line 906 "smarty_internal_templateparser.y"
    function yy_r144(){
    $this->_retvalue = '('.$this->yystack[$this->yyidx + -1]->minor.')';
    }
#line 2808 "smarty_internal_templateparser.php"
#line 913 "smarty_internal_templateparser.y"
    function yy_r145(){
    if ($this->yystack[$this->yyidx + -1]->minor['var'] == '\'smarty\'') {
        $this->_retvalue =  $this->compiler->compileTag('private_special_variable',array(),$this->yystack[$this->yyidx + -1]->minor['smarty_internal_index']).$this->yystack[$this->yyidx + 0]->minor;
    } else {
        $this->_retvalue = $this->compileVariable($this->yystack[$this->yyidx + -1]->minor['var']).$this->yystack[$this->yyidx + -1]->minor['smarty_internal_index'].$this->yystack[$this->yyidx + 0]->minor;
    }
    }
#line 2817 "smarty_internal_templateparser.php"
#line 922 "smarty_internal_templateparser.y"
    function yy_r146(){
    $this->_retvalue  = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 2822 "smarty_internal_templateparser.php"
#line 927 "smarty_internal_templateparser.y"
    function yy_r147(){
    $this->_retvalue  = $this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 2827 "smarty_internal_templateparser.php"
#line 932 "smarty_internal_templateparser.y"
    function yy_r148(){
    if ($this->security && substr($this->yystack[$this->yyidx + -1]->minor,0,1) == '_') {
        $this->compiler->trigger_template_error (self::Err1);
    }
    $this->_retvalue = '->'.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 2835 "smarty_internal_templateparser.php"
#line 939 "smarty_internal_templateparser.y"
    function yy_r149(){
    if ($this->security) {
        $this->compiler->trigger_template_error (self::Err2);
    }
    $this->_retvalue = '->{'.$this->compileVariable($this->yystack[$this->yyidx + -1]->minor).$this->yystack[$this->yyidx + 0]->minor.'}';
    }
#line 2843 "smarty_internal_templateparser.php"
#line 946 "smarty_internal_templateparser.y"
    function yy_r150(){
    if ($this->security) {
        $this->compiler->trigger_template_error (self::Err2);
    }
    $this->_retvalue = '->{'.$this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + 0]->minor.'}';
    }
#line 2851 "smarty_internal_templateparser.php"
#line 953 "smarty_internal_templateparser.y"
    function yy_r151(){
    if ($this->security) {
        $this->compiler->trigger_template_error (self::Err2);
    }
    $this->_retvalue = '->{\''.$this->yystack[$this->yyidx + -4]->minor.'\'.'.$this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + 0]->minor.'}';
    }
#line 2859 "smarty_internal_templateparser.php"
#line 961 "smarty_internal_templateparser.y"
    function yy_r152(){
    $this->_retvalue = '->'.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 2864 "smarty_internal_templateparser.php"
#line 969 "smarty_internal_templateparser.y"
    function yy_r153(){
    if (!$this->security || $this->smarty->security_policy->isTrustedPhpFunction($this->yystack[$this->yyidx + -3]->minor, $this->compiler)) {
        if (strcasecmp($this->yystack[$this->yyidx + -3]->minor,'isset') === 0 || strcasecmp($this->yystack[$this->yyidx + -3]->minor,'empty') === 0 || strcasecmp($this->yystack[$this->yyidx + -3]->minor,'array') === 0 || is_callable($this->yystack[$this->yyidx + -3]->minor)) {
            $func_name = strtolower($this->yystack[$this->yyidx + -3]->minor);
            if ($func_name == 'isset') {
                if (count($this->yystack[$this->yyidx + -1]->minor) == 0) {
                    $this->compiler->trigger_template_error ('Illegal number of paramer in "isset()"');
                }
                $par = implode(',',$this->yystack[$this->yyidx + -1]->minor);
                if (strncasecmp($par,'$_smarty_tpl->getConfigVariable',strlen('$_smarty_tpl->getConfigVariable')) === 0) {
                    $this->prefix_number++;
                    $this->compiler->prefix_code[] = '<?php $_tmp'.$this->prefix_number.'='.str_replace(')',', false)',$par).';?>';
                    $isset_par = '$_tmp'.$this->prefix_number;
                } else {
                    $isset_par=str_replace("')->value","',null,true,false)->value",$par);
                }
                $this->_retvalue = $this->yystack[$this->yyidx + -3]->minor . "(". $isset_par .")";
            } elseif (in_array($func_name,array('empty','reset','current','end','prev','next'))){
                if (count($this->yystack[$this->yyidx + -1]->minor) != 1) {
                    $this->compiler->trigger_template_error ('Illegal number of paramer in "empty()"');
                }
                if ($func_name == 'empty') {
                    $this->_retvalue = $func_name.'('.str_replace("')->value","',null,true,false)->value",$this->yystack[$this->yyidx + -1]->minor[0]).')';
                } else {
                    $this->_retvalue = $func_name.'('.$this->yystack[$this->yyidx + -1]->minor[0].')';
                }
            } else {
                $this->_retvalue = $this->yystack[$this->yyidx + -3]->minor . "(". implode(',',$this->yystack[$this->yyidx + -1]->minor) .")";
            }
        } else {
            $this->compiler->trigger_template_error ("unknown function \"" . $this->yystack[$this->yyidx + -3]->minor . "\"");
        }
    }
    }
#line 2900 "smarty_internal_templateparser.php"
#line 1007 "smarty_internal_templateparser.y"
    function yy_r154(){
    if ($this->security && substr($this->yystack[$this->yyidx + -3]->minor,0,1) == '_') {
        $this->compiler->trigger_template_error (self::Err1);
    }
    $this->_retvalue = $this->yystack[$this->yyidx + -3]->minor . "(". implode(',',$this->yystack[$this->yyidx + -1]->minor) .")";
    }
#line 2908 "smarty_internal_templateparser.php"
#line 1014 "smarty_internal_templateparser.y"
    function yy_r155(){
    if ($this->security) {
        $this->compiler->trigger_template_error (self::Err2);
    }
    $this->prefix_number++;
    $this->compiler->prefix_code[] = '<?php $_tmp'.$this->prefix_number.'='.$this->compileVariable("'".$this->yystack[$this->yyidx + -3]->minor."'").';?>';
    $this->_retvalue = '$_tmp'.$this->prefix_number.'('. implode(',',$this->yystack[$this->yyidx + -1]->minor) .')';
    }
#line 2918 "smarty_internal_templateparser.php"
#line 1025 "smarty_internal_templateparser.y"
    function yy_r156(){
    $this->_retvalue = array_merge($this->yystack[$this->yyidx + -2]->minor,array($this->yystack[$this->yyidx + 0]->minor));
    }
#line 2923 "smarty_internal_templateparser.php"
#line 1042 "smarty_internal_templateparser.y"
    function yy_r159(){
    $this->_retvalue = array_merge($this->yystack[$this->yyidx + -2]->minor,array(array_merge($this->yystack[$this->yyidx + -1]->minor,$this->yystack[$this->yyidx + 0]->minor)));
    }
#line 2928 "smarty_internal_templateparser.php"
#line 1046 "smarty_internal_templateparser.y"
    function yy_r160(){
    $this->_retvalue = array(array_merge($this->yystack[$this->yyidx + -1]->minor,$this->yystack[$this->yyidx + 0]->minor));
    }
#line 2933 "smarty_internal_templateparser.php"
#line 1054 "smarty_internal_templateparser.y"
    function yy_r162(){
    $this->_retvalue =  array($this->yystack[$this->yyidx + 0]->minor);
    }
#line 2938 "smarty_internal_templateparser.php"
#line 1062 "smarty_internal_templateparser.y"
    function yy_r163(){
    $this->_retvalue = array_merge($this->yystack[$this->yyidx + -1]->minor,$this->yystack[$this->yyidx + 0]->minor);
    }
#line 2943 "smarty_internal_templateparser.php"
#line 1096 "smarty_internal_templateparser.y"
    function yy_r170(){
    $this->_retvalue = '$'.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 2948 "smarty_internal_templateparser.php"
#line 1101 "smarty_internal_templateparser.y"
    function yy_r171(){
    $this->_retvalue = '$'.$this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 2953 "smarty_internal_templateparser.php"
#line 1107 "smarty_internal_templateparser.y"
    function yy_r172(){
    $this->_retvalue = '==';
    }
#line 2958 "smarty_internal_templateparser.php"
#line 1111 "smarty_internal_templateparser.y"
    function yy_r173(){
    $this->_retvalue = '!=';
    }
#line 2963 "smarty_internal_templateparser.php"
#line 1115 "smarty_internal_templateparser.y"
    function yy_r174(){
    $this->_retvalue = '>';
    }
#line 2968 "smarty_internal_templateparser.php"
#line 1119 "smarty_internal_templateparser.y"
    function yy_r175(){
    $this->_retvalue = '<';
    }
#line 2973 "smarty_internal_templateparser.php"
#line 1123 "smarty_internal_templateparser.y"
    function yy_r176(){
    $this->_retvalue = '>=';
    }
#line 2978 "smarty_internal_templateparser.php"
#line 1127 "smarty_internal_templateparser.y"
    function yy_r177(){
    $this->_retvalue = '<=';
    }
#line 2983 "smarty_internal_templateparser.php"
#line 1131 "smarty_internal_templateparser.y"
    function yy_r178(){
    $this->_retvalue = '===';
    }
#line 2988 "smarty_internal_templateparser.php"
#line 1135 "smarty_internal_templateparser.y"
    function yy_r179(){
    $this->_retvalue = '!==';
    }
#line 2993 "smarty_internal_templateparser.php"
#line 1139 "smarty_internal_templateparser.y"
    function yy_r180(){
    $this->_retvalue = '%';
    }
#line 2998 "smarty_internal_templateparser.php"
#line 1143 "smarty_internal_templateparser.y"
    function yy_r181(){
    $this->_retvalue = '&&';
    }
#line 3003 "smarty_internal_templateparser.php"
#line 1147 "smarty_internal_templateparser.y"
    function yy_r182(){
    $this->_retvalue = '||';
    }
#line 3008 "smarty_internal_templateparser.php"
#line 1151 "smarty_internal_templateparser.y"
    function yy_r183(){
    $this->_retvalue = ' XOR ';
    }
#line 3013 "smarty_internal_templateparser.php"
#line 1158 "smarty_internal_templateparser.y"
    function yy_r184(){
    $this->_retvalue = 'array('.$this->yystack[$this->yyidx + -1]->minor.')';
    }
#line 3018 "smarty_internal_templateparser.php"
#line 1166 "smarty_internal_templateparser.y"
    function yy_r186(){
    $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.','.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 3023 "smarty_internal_templateparser.php"
#line 1174 "smarty_internal_templateparser.y"
    function yy_r188(){
    $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.'=>'.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 3028 "smarty_internal_templateparser.php"
#line 1178 "smarty_internal_templateparser.y"
    function yy_r189(){
    $this->_retvalue = '\''.$this->yystack[$this->yyidx + -2]->minor.'\'=>'.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 3033 "smarty_internal_templateparser.php"
#line 1190 "smarty_internal_templateparser.y"
    function yy_r191(){
    $this->_retvalue = "''";
    }
#line 3038 "smarty_internal_templateparser.php"
#line 1194 "smarty_internal_templateparser.y"
    function yy_r192(){
    $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor->to_smarty_php();
    }
#line 3043 "smarty_internal_templateparser.php"
#line 1199 "smarty_internal_templateparser.y"
    function yy_r193(){
    $this->yystack[$this->yyidx + -1]->minor->append_subtree($this->yystack[$this->yyidx + 0]->minor);
    $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor;
    }
#line 3049 "smarty_internal_templateparser.php"
#line 1204 "smarty_internal_templateparser.y"
    function yy_r194(){
    $this->_retvalue = new _smarty_doublequoted($this, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 3054 "smarty_internal_templateparser.php"
#line 1208 "smarty_internal_templateparser.y"
    function yy_r195(){
    $this->_retvalue = new _smarty_code($this, '(string)'.$this->yystack[$this->yyidx + -1]->minor);
    }
#line 3059 "smarty_internal_templateparser.php"
#line 1216 "smarty_internal_templateparser.y"
    function yy_r197(){
    $this->_retvalue = new _smarty_code($this, '(string)$_smarty_tpl->tpl_vars[\''. substr($this->yystack[$this->yyidx + 0]->minor,1) .'\']->value');
    }
#line 3064 "smarty_internal_templateparser.php"
#line 1224 "smarty_internal_templateparser.y"
    function yy_r199(){
    $this->_retvalue = new _smarty_code($this, '(string)('.$this->yystack[$this->yyidx + -1]->minor.')');
    }
#line 3069 "smarty_internal_templateparser.php"
#line 1228 "smarty_internal_templateparser.y"
    function yy_r200(){
    $this->_retvalue = new _smarty_tag($this, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 3074 "smarty_internal_templateparser.php"
#line 1232 "smarty_internal_templateparser.y"
    function yy_r201(){
    $this->_retvalue = new _smarty_dq_content($this, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 3079 "smarty_internal_templateparser.php"

    private $_retvalue;

    function yy_reduce($yyruleno)
    {
        $yymsp = $this->yystack[$this->yyidx];
        if (self::$yyTraceFILE && $yyruleno >= 0
              && $yyruleno < count(self::$yyRuleName)) {
            fprintf(self::$yyTraceFILE, "%sReduce (%d) [%s].\n",
                self::$yyTracePrompt, $yyruleno,
                self::$yyRuleName[$yyruleno]);
        }

        $this->_retvalue = $yy_lefthand_side = null;
        if (array_key_exists($yyruleno, self::$yyReduceMap)) {
            // call the action
            $this->_retvalue = null;
            $this->{'yy_r' . self::$yyReduceMap[$yyruleno]}();
            $yy_lefthand_side = $this->_retvalue;
        }
        $yygoto = self::$yyRuleInfo[$yyruleno]['lhs'];
        $yysize = self::$yyRuleInfo[$yyruleno]['rhs'];
        $this->yyidx -= $yysize;
        for($i = $yysize; $i; $i--) {
            // pop all of the right-hand side parameters
            array_pop($this->yystack);
        }
        $yyact = $this->yy_find_reduce_action($this->yystack[$this->yyidx]->stateno, $yygoto);
        if ($yyact < self::YYNSTATE) {
            if (!self::$yyTraceFILE && $yysize) {
                $this->yyidx++;
                $x = new TP_yyStackEntry;
                $x->stateno = $yyact;
                $x->major = $yygoto;
                $x->minor = $yy_lefthand_side;
                $this->yystack[$this->yyidx] = $x;
            } else {
                $this->yy_shift($yyact, $yygoto, $yy_lefthand_side);
            }
        } elseif ($yyact == self::YYNSTATE + self::YYNRULE + 1) {
            $this->yy_accept();
        }
    }

    function yy_parse_failed()
    {
        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sFail!\n", self::$yyTracePrompt);
        }
        while ($this->yyidx >= 0) {
            $this->yy_pop_parser_stack();
        }
    }

    function yy_syntax_error($yymajor, $TOKEN)
    {
#line 77 "smarty_internal_templateparser.y"

    $this->internalError = true;
    $this->yymajor = $yymajor;
    $this->compiler->trigger_template_error();
#line 3142 "smarty_internal_templateparser.php"
    }

    function yy_accept()
    {
        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sAccept!\n", self::$yyTracePrompt);
        }
        while ($this->yyidx >= 0) {
            $stack = $this->yy_pop_parser_stack();
        }
#line 69 "smarty_internal_templateparser.y"

    $this->successful = !$this->internalError;
    $this->internalError = false;
    $this->retvalue = $this->_retvalue;
    //echo $this->retvalue."\n\n";
#line 3160 "smarty_internal_templateparser.php"
    }

    function doParse($yymajor, $yytokenvalue)
    {
        $yyerrorhit = 0;   /* True if yymajor has invoked an error */

        if ($this->yyidx === null || $this->yyidx < 0) {
            $this->yyidx = 0;
            $this->yyerrcnt = -1;
            $x = new TP_yyStackEntry;
            $x->stateno = 0;
            $x->major = 0;
            $this->yystack = array();
            array_push($this->yystack, $x);
        }
        $yyendofinput = ($yymajor==0);

        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sInput %s\n",
                self::$yyTracePrompt, $this->yyTokenName[$yymajor]);
        }

        do {
            $yyact = $this->yy_find_shift_action($yymajor);
            if ($yymajor < self::YYERRORSYMBOL &&
                  !$this->yy_is_expected_token($yymajor)) {
                // force a syntax error
                $yyact = self::YY_ERROR_ACTION;
            }
            if ($yyact < self::YYNSTATE) {
                $this->yy_shift($yyact, $yymajor, $yytokenvalue);
                $this->yyerrcnt--;
                if ($yyendofinput && $this->yyidx >= 0) {
                    $yymajor = 0;
                } else {
                    $yymajor = self::YYNOCODE;
                }
            } elseif ($yyact < self::YYNSTATE + self::YYNRULE) {
                $this->yy_reduce($yyact - self::YYNSTATE);
            } elseif ($yyact == self::YY_ERROR_ACTION) {
                if (self::$yyTraceFILE) {
                    fprintf(self::$yyTraceFILE, "%sSyntax Error!\n",
                        self::$yyTracePrompt);
                }
                if (self::YYERRORSYMBOL) {
                    if ($this->yyerrcnt < 0) {
                        $this->yy_syntax_error($yymajor, $yytokenvalue);
                    }
                    $yymx = $this->yystack[$this->yyidx]->major;
                    if ($yymx == self::YYERRORSYMBOL || $yyerrorhit ){
                        if (self::$yyTraceFILE) {
                            fprintf(self::$yyTraceFILE, "%sDiscard input token %s\n",
                                self::$yyTracePrompt, $this->yyTokenName[$yymajor]);
                        }
                        $this->yy_destructor($yymajor, $yytokenvalue);
                        $yymajor = self::YYNOCODE;
                    } else {
                        while ($this->yyidx >= 0 &&
                                 $yymx != self::YYERRORSYMBOL &&
        ($yyact = $this->yy_find_shift_action(self::YYERRORSYMBOL)) >= self::YYNSTATE
                              ){
                            $this->yy_pop_parser_stack();
                        }
                        if ($this->yyidx < 0 || $yymajor==0) {
                            $this->yy_destructor($yymajor, $yytokenvalue);
                            $this->yy_parse_failed();
                            $yymajor = self::YYNOCODE;
                        } elseif ($yymx != self::YYERRORSYMBOL) {
                            $u2 = 0;
                            $this->yy_shift($yyact, self::YYERRORSYMBOL, $u2);
                        }
                    }
                    $this->yyerrcnt = 3;
                    $yyerrorhit = 1;
                } else {
                    if ($this->yyerrcnt <= 0) {
                        $this->yy_syntax_error($yymajor, $yytokenvalue);
                    }
                    $this->yyerrcnt = 3;
                    $this->yy_destructor($yymajor, $yytokenvalue);
                    if ($yyendofinput) {
                        $this->yy_parse_failed();
                    }
                    $yymajor = self::YYNOCODE;
                }
            } else {
                $this->yy_accept();
                $yymajor = self::YYNOCODE;
            }
        } while ($yymajor != self::YYNOCODE && $this->yyidx >= 0);
    }
}
