<?php
namespace Halk\Core;

class Bootstrap extends Registry
{
    const HALK_BOOTSTRAP = true;

    public function setup()
    {
        $this->init();
        $this->setLocale();
        $this->registerErrorHandler();
    }

    protected function setLocale()
    {
        // Устанавливаем таймзону
        date_default_timezone_set(Config::getInstance()->getValue("timezone"));

        // Устанавливаем локаль
        setlocale(LC_ALL, Config::getInstance()->getValue("locale"));
        setlocale(LC_NUMERIC, 'C');

        header('Content-Type: text/html; charset=' . HALK_INTERNAL_ENCODING);

        bindtextdomain(HALK_APPLICATION_NAME, HALK_LOCALE_PATH);
        bind_textdomain_codeset(HALK_APPLICATION_NAME, HALK_INTERNAL_ENCODING);
        textdomain(HALK_APPLICATION_NAME);
    }

    protected function registerErrorHandler()
    {
        Error::register();
    }

    protected function init()
    {
        require_once '_init.php';
    }

}
