<?php

namespace Halk\Core\Cache;

use Halk\Core\Exception\CoreException;

/**
 * Class CacheFactory
 * @package Halk\Core\Cache
 */
class CacheFactory
{
    public static function get($driverName)
    {
        switch($driverName) {
            case 'redis':
                return Redis::getInstance();
            case 'memcache':
                return Memcache::getInstance();
            default:
                throw new CoreException('Cache driver not found');
        }
    }
}