<?php

namespace Halk\Core;


/**
 * Registry class.
 *
 * @category  PHP
 * @package   Common
 * @author    Kolombet Ivan <i.kolombet@hoster.ru>
 * @copyright 2011 Filanco
 * @license   Proprietary http://www.filanco.ru
 * @version   Release: 2.0
 * @link      http://halk.filanco.ru
 */
abstract class Registry extends Basic
{

    private function __construct()
    {
        //приватный ибо синглтон
    }

    /**
     *
     * @var array
     */
    private static $instances = array();

    /**
     * Get class instance.
     *
     * @param string $class_name class name
     *
     * @return static
     */
    public static function getInstance($class_name = null)
    {

        if (is_null($class_name)) {
            $class_name = get_called_class();
        }

        if (!isset(self::$instances[$class_name])) {
            $instance = new $class_name();
            self::$instances[$class_name] = $instance;
        }

        return self::$instances[$class_name];
    }//end getInstance()
}//end class
