<?php
namespace Halk\Core\File;

abstract class ErrorsRegistry
{

    /**
     * Массив с сообщениями об ошибках
     *
     * @var Array
     * @access protected
     */
    protected $errors = array();

    /**
     * Возвращает массив всех сообщений об ошибках
     *
     * @access public
     * @return Array
     */
    public function getErrors()
    {
        return $this->errors;
    }

    /**
     * Возвращает "склеенные" сообщения об ошибках
     *
     * @param String $delimiter Разделитель
     * @access public
     * @return string
     */
    public function getErrString($delimiter = '; ')
    {
        return implode($delimiter, $this->getErrors());
    }

    /**
     * Проверяет наличие зарегистрированных ошибок
     *
     * @access public
     * @return boolean
     */
    public function isError()
    {
        return (bool) count($this->errors);
    }

    /**
     * Форматирует строку с сообщением об ошибке,
     * помещает ее в массив $errors
     *
     * @param String $msg
     * @access protected
     * @return void
     */
    protected function registerError($msg)
    {
        $args = func_get_args();
        array_shift($args);

        $message = vsprintf($msg, $args);
        $this->errors[] = $message;
    }
}
