<?php

namespace Halk\Core;

use Halk\Core\Smarty\Resource\Halk as SmartyResource;
use Halk\Core\Smarty\SmartyFilters;

/**
 * Custom Smarty class.
 *
 * @category   PHP
 * @package    Halk
 * @subpackage Core
 * @author     Kolombet Ivan <i.kolombet@hoster.ru>
 * @copyright  2011 Filanco
 * @license    Proprietary http://www.filanco.ru
 * @version    Release: 2.0
 * @link       http://halk.filanco.ru
 */
class Smarty extends \Smarty
{

    /**
     * Constructor.
     *
     * @uses Config
     */
    public function __construct()
    {
        parent::__construct();

        $ini = Config::getInstance();

        $this->template_dir = $ini->getValue('home') . '/' . $ini->getValue('smarty_template_dir');
        $this->compile_dir = $ini->getValue('home') . '/' . $ini->getValue('smarty_compile_dir');
        $this->cache_dir = $ini->getValue('home') . '/' . $ini->getValue('smarty_cache_dir');
        $this->config_dir = $ini->getValue('home') . '/' . $ini->getValue('smarty_config_dir');

        if ($ini->containsKey('smarty_file_perm')) {
            $this->_file_perms = octdec($ini->getValue('smarty_file_perm'));
        }

        if ($ini->containsKey('smarty_dir_perm')) {
            $this->_dir_perms = octdec($ini->getValue('smarty_dir_perm'));
        }

        $this->left_delimiter = HALK_SMARTY_LEFT_DELIMITER;
        $this->right_delimiter = HALK_SMARTY_RIGHT_DELIMITER;

        $this->debugging = $ini->getValue('smarty_debugging');
        $this->caching = $ini->getValue('smarty_caching');
        $this->compile_check = $ini->getValue('smarty_compile_check');
        $this->force_compile = $ini->getValue('smarty_force_compile');
        $this->addPluginsDir($ini->getValue('home') . '/' . $ini->getValue('smarty_plugins_dir'));

        if (
            $ini->containsKey('smarty_add_timestamps_to_links') &&
            $ini->getValue('smarty_add_timestamps_to_links'
        )) {
            $this->registerFilter('pre', [new SmartyFilters(), 'addTimestampsToLinks']);
        }

        $this->registerExtensions();
    }//end getInstance()

    /**
     * This is bullshit.
     * PHP classes cannot inherit more than 1 (one) class.
     *
     * @return Smarty
     */
    public static function getInstance()
    {
        return Registry::getInstance(__CLASS__);
    }//end __construct()

    public function includeScripts($module)
    {
        if (!$docdir = Config::getInstance()->getValue('document_root')) {
            trigger_error('Рабочий каталог не задан, автозагрузка js отключена');
        } else {
            $dir = HALK_APP_ROOT .'/Module/' . ucfirst($module) . '/View/js';
            if (file_exists($dir) && ($files = scandir($dir))) {
                if (!$scripts = $this->getVariable('scripts')->value) {
                    $scripts = [];
                }
                foreach ($files as $file) {
                    if (strpos($file, '.js')) {
                        $scripts[] = '/js/' . $module . '/' . $file;
                    }
                }
                $ptr = $this;
                while ($ptr instanceof \Smarty_Internal_Template) {
                    $ptr = $ptr->parent;
                }
                $ptr->assign('scripts', $scripts);
            }
        }
    }

    protected function registerExtensions()
    {
        $this->registerResource(HALK_TEMPLATE_PREFIX, new SmartyResource());
    }
}//end class
