<?php declare(strict_types=1);

namespace MyENA\RGW;

/**
 * Class AbstractArrayModel
 * @package MyENA\RGW
 */
abstract class AbstractModelCollection extends AbstractModel implements \Iterator, \Countable
{
    /** @var array */
    private $data = [];

    /**
     * AbstractArrayResponse constructor.
     * @param array $data
     */
    public function __construct(array $data = [])
    {
        $class = $this->containedType();
        foreach ($data as $datum) {
            $this->data[] = new $class($datum);
        }
    }

    /**
     * Must return the fully qualified class name of the contained object
     *
     * @return string
     */
    abstract protected function containedType(): string;

    /**
     * @return mixed
     */
    public function first()
    {
        return $this->data[0] ?? null;
    }

    /**
     * @return mixed
     */
    public function current(): mixed
    {
        return current($this->data);
    }

    public function next(): void
    {
        next($this->data);
    }

    /**
     * @return int|mixed|null|string
     */
    public function key(): mixed
    {
        return key($this->data);
    }

    /**
     * @return bool
     */
    public function valid(): bool
    {
        return null !== key($this->data);
    }

    public function rewind(): void
    {
        reset($this->data);
    }

    /**
     * @return int
     */
    public function count(): int
    {
        return count($this->data);
    }

    /**
     * @return array
     */
    public function jsonSerialize(): mixed
    {
        return $this->data;
    }
}
