<?php
namespace Filanco\SitemapTool;

use Curl\Curl;

/**
 * Class Crawler
 */
trait Crawler
{
    protected $url;
    protected $links = [];
    protected $notFound = [];
    protected $scanned = [];

    /**
     * Scan site content
     * @param Curl $curl
     * @return string
     * @throws \Exception
     */
    public function scan(Curl $curl)
    {
        $content = '';

        if (in_array($this->url, $this->scanned)) {
            return $content;
        }

        $content = $curl->get($this->url);
        $this->scanned[] = $curl->url;

        return $content;
    }

    /**
     * @return array
     */
    public function getLinks()
    {
        return $this->links;
    }

    /**
     * @return array
     */
    public function getNotFoundLinks()
    {
        return $this->notFound;
    }

    public function findLinks(Parser $p, $cb)
    {
        $links = $p->find('a');

        if ($cb && $cb instanceof \Closure) {
            return $cb($links);
        }

        return $links;
    }
}
