<?php

require '../vendor/autoload.php';

use Filanco\SitemapTool\Sitemap;

$sitemap = new Sitemap(
    'https://onecam.ru',
    [
        'redirectLimit' => 1,
        /*'additionalLinks' => [
            '/test' => [ 'url' => '/test' ]
        ],*/
        'forbiddenLinks' => ['^$', '#', '\.(jpg|png|gif|doc|docx)$'],
        'priority' => 0.6,
        'priorityCustom' => [
            '^/$' => 0.8,
            '^/news/.*$' => 0.7,
            '^/about/news$' => 0.7,
        ],
        'frequency' => 'weekly',
        'frequencyCustom' => [
            '^/$' => 'daily',
            '^/news/.*$' => 'daily',
            '^/about/news$' => 'daily',
        ]
    ]
);

$sitemap->saveAs(__DIR__ . '/sitemap.xml');

//header("Content-type: text/xml");
//echo $sitemap->getContent();
