<?php
namespace Filanco\SitemapTool;

use Curl\Curl;

/**
 * Class Crawler
 */
trait Crawler
{
    protected $url;
    protected $links = [];
    protected $notFound = [];
    protected $scanned = [];

    /**
     * Scan site content
     * @param Curl $curl
     * @param int  $redirectLimit
     * @return string
     * @throws \Exception
     */
    public function scan(Curl $curl, $redirectLimit = 0)
    {
        $content = '';

        if (in_array($this->url, $this->scanned)) {
            return $content;
        }

        $content = $curl->get($this->url);

        // Handling redirects
        if (in_array($curl->httpStatusCode, [301, 302]) && $redirectLimit > 0 && strpos($curl->responseHeaders['Location'], '/') === 0) {
            $this->url = $this->baseUrl . $curl->responseHeaders['Location'];
            return $this->scan($curl, --$redirectLimit);
        }

        $this->scanned[] = $curl->url;

        return $content;
    }

    /**
     * @return array
     */
    public function getLinks()
    {
        return $this->links;
    }

    /**
     * @return array
     */
    public function getNotFoundLinks()
    {
        return $this->notFound;
    }

    public function findLinks(Parser $p, $cb)
    {
        $links = $p->find('a');

        if ($cb && $cb instanceof \Closure) {
            return $cb($links);
        }

        return $links;
    }
}
