<?php
namespace Filanco\SitemapTool;

/**
 * Class Parser
 */
class Parser
{
    protected $content;
    protected $extensions;

    public function __construct($content, $extensions = [])
    {
        $this->content = $content;
        $this->extensions = $extensions;
    }

    public function find($tagName)
    {
        $matches = [];

        switch ($tagName) {
            case 'a':
                $regexp = "<a\s[^>]*href=(\"??)([^\" >]*?)\\1[^>]*>(.*)<\/a>";
                preg_match_all("/{$regexp}/siU", $this->content, $matches, PREG_SET_ORDER);
                break;
        }

        return $matches;
    }
}
