<?php
use Filanco\Sms\Client;
use Filanco\Sms\ClientLogInterface;
use Filanco\Sms\Credential;
use Filanco\Sms\Message;

require_once __DIR__ . '/../vendor/autoload.php';

class Logger implements ClientLogInterface
{
    public function log($message)
    {
        echo date('Y-m-d H:i:s') . ': ' . $message . PHP_EOL;
    }
}

class SmsClient
{
    /**
     * @var Client
     */
    private static $client;

    /**
     * @return Client
     */
    public static function getApi()
    {
        if (!self::$client) {
            $credential = new Credential([
                'login' => 'login',
                'password' => 'password',
                'address' => 'https://host'
            ]);

            self::$client = new Client($credential, new Logger());
        }

        return self::$client;
    }
}

$message = new Message([
    'phone' => '+79161239357',
    'body' => 'Тестовая смска в халк',
    'sender' => 'Domenus'
]);

$sms_client = SmsClient::getApi();
$message = $sms_client->send($message);
var_dump($message);
var_dump($sms_client->view($message->getId()));