<?php
namespace Filanco\Sms;

use Filanco\ApiClient\ApiClientAbstract;

/**
 * Class ApiClient
 * @package Filanco\Sms
 */
class ApiClient extends ApiClientAbstract
{
    /** @var Credential */
    protected $credential;

    /** @var ClientLogInterface */
    protected $logger;
    
    public function __construct(Credential $credential, ClientLogInterface $logger = null)
    {
        $this->credential = $credential;
        $this->logger = $logger;
    }

    public function send(
        $action,
        array $params = [],
        $method = 'GET'
    )
    {
        $url = $this->credential->getAddress() . '/api/http-rpc';
        $params['method'] = $action;
        $params['login'] = $this->credential->getLogin();
        $params['password'] = $this->credential->getPassword();
        $params['content_type'] = 'json';

        return parent::makeRequest($url, [http_build_query($params)], $method, [], 'form');
    }

    protected function logRequest($url, $query, $params)
    {
        if (!is_null($this->logger)) {
            $this->logger->log('Request: ' . json_encode(func_get_args()));
        }
    }

    protected function logResponse($response, $raw_data)
    {
        if (!is_null($this->logger)) {
            $this->logger->log('Response: ' . json_encode(func_get_args()));
        }
    }

    protected function handleCheckResult($check)
    {
        return json_decode(parent::handleCheckResult($check), true);
    }
}