<?php
namespace Filanco\Sms;

use Filanco\BaseModel;

/**
 * Class Message
 * @package Filanco\Sms
 *
 * @method int getId()
 * @method string getPhone()
 * @method string getState()
 * @method string getBody()
 * @method string getSender()
 * @method string getCreateTime()
 */
class Message extends BaseModel
{
    const
        STATUS_PENDING = 'pending',
        STATUS_SENDING = 'sending',
        STATUS_SUCCESS = 'success',
        STATUS_FAILED = 'failed';

    protected function fields()
    {
        return [
            'id' => 'Идентификатор',
            'phone' => 'Номер телефона',
            'state' => 'Статус отправки',
            'sender' => 'Отправитель',
            'body' => 'Тело сообщения',
            'create_time' => 'Дата создания',
        ];
    }

    protected function validators()
    {
        return [
            'phone' => function($value) {
                return !empty($value);
            },
            'body' => function($value) {
                return !empty($value);
            },
            'sender' => function($value) {
                return !empty($value);
            }
        ];
    }
}