<?php
namespace Filanco\Sms;

/**
 * Class Client
 * @package Filanco\Sms
 */
class Client
{
    /** @var ApiClient */
    protected $api_client;

    public function __construct(Credential $credential, ClientLogInterface $logger = null)
    {
        $this->api_client = new ApiClient($credential, $logger);
    }

    public function send(Message $message)
    {
        $message = [
            'phone' => $message->getPhone(),
            'body' => $message->getBody(),
            'sender' => $message->getSender(),
        ];
        $api_response = $this->api_client->send('sms/send', ['message' => $message], 'POST');
        return $this->getMessageFromApiResponse($api_response);
    }

    public function view($message_id)
    {
        $api_response = $this->api_client->send('sms/view', ['id' => $message_id]);
        return $this->getMessageFromApiResponse($api_response);
    }

    /**
     * @param array $api_response
     * @return Message
     */
    protected function getMessageFromApiResponse(array $api_response)
    {
        return new Message($api_response['data']['message']);
    }
}