<?php
namespace Filanco\Sms;

use Filanco\BaseModel;

/**
 * Class Credential
 * @package Filanco\Sms
 *
 * @method string getLogin()
 * @method string getPassword()
 * @method string getAddress()
 */
class Credential extends BaseModel
{
    protected function fields()
    {
        return [
            'login' => 'Логин',
            'password' => 'Пароль',
            'address' => 'Адрес для подключения',
        ];
    }

    protected function validators()
    {
        return [
            'login' => function($value) {
                return !empty($value);
            },
            'password' => function($value) {
                return !empty($value);
            },
            'address' => function($value) {
                return !empty($value);
            }
        ];
    }
}