<?php
class VMware_VCloud_API_Helper
{
    public static $ExternalEncoding = 'UTF-8';

    public static function addString($out, $string){
        return $out . $string;
    }

    public static function constructNS($attrs, $namespaces, $nsdef) {
        $namespacedef = ''; 
        if ($namespaces && array_keys($namespaces)) {
            foreach (array_keys($namespaces) as $key) {
                if (!$key && 0 >= strpos($nsdef, 'xmlns=')) {
                    $keyname = 'xmlns';
                    $namespacedef .= " $keyname=\"" . $namespaces[$key] . "\"";
                }
            }
        }
        if ($attrs) {
            $xsiType = $attrs->getNamedItemNS('http://www.w3.org/2001/XMLSchema-instance', 'type');
            if ($xsiType && 0 >= strpos($nsdef, 'xsi:type=')) {
                #print " realtype = " . $xsiType->name . ", " . $xsiType->nodeValue . "\n";
                $namespacedef .= " xsi:type='" . $xsiType->nodeValue . "'";
            }
        }
        return $namespacedef;
    }

    public static function parseString($inString, $type=null) {
        if (!$inString) {
            return null;
        }
        $doc = new DOMDocument();
        $doc->loadXML($inString);
        if (!$doc) {
            throw New Exception("parseString: failed to load DOMDocument, " .
                                "inString: $inString");
        }
        $sxml = simplexml_import_dom($doc);
        $namespaces = $sxml->getDocNamespaces(true);
        $rootNode = $doc->getElementsByTagName('*')->item(0);
        $rootName = $rootNode->localName;
        $typeName = $rootName;
        if (!$type) {
            $realType = $rootNode->getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
            if ($realType) {
                list($ns, $typeName) = explode(':', $realType);
            }
            $type = self::getClassName($typeName);
            if (!$type) {
                exit("Unknown type, please specify the data object type using $type.\n");
            }
        }
        try {
            $typeClass = new ReflectionClass($type);
            $build = $typeClass->GetMethod("build");
            if ($typeClass->isInstantiable()) {
                $typeObj = $typeClass->newInstance();
                if ($typeName != $rootName) {
                    $typeObj->set_tagName($rootName);
                }
                $build->invoke($typeObj, $rootNode, $namespaces);
                return $typeObj;
            }
        } catch (Exception $e) {
            print ("Got exception on type " . $type . "\n");
            print ($e->getMessage() . " at line " . $e->getLine() . "\n");
        }
        return null;
    }

    public static function format_string($input_data, $input_name='') {
        if ($input_data instanceof DOMText) {
            $input_data = $input_data->wholeText;
        }
        return $input_data;
    }

    public static function format_integer($input_data, $input_name='') {
        if ($input_data instanceof DOMText) {
            $input_data = $input_data->wholeText;
        }
        return sprintf('%d', $input_data);
    }

    public static function format_float($input_data, $input_name='') {
        if ($input_data instanceof DOMText) {
            $input_data = $input_data->wholeText;
        }
        return sprintf('%s', $input_data);
    }

    public static function format_double($input_data, $input_name='') {
        if ($input_data instanceof DOMText) {
            $input_data = $input_data->wholeText;
        }
        return sprintf('%s', $input_data);
    }

    public static function format_boolean($input_data, $input_name='') {
        if ($input_data instanceof DOMText) {
            $input_data = $input_data->wholeText;
        }
        return ($input_data)? 'true' : 'false';
    }

    public static function get_boolean($input_data) {
        $str = strtolower($input_data);
        if ($str == 'true') {
            return true;
        } else {
            return false;
        }
    }

    public static function quote_xml($inStr){
        if (is_string($inStr) && !is_null($inStr)) {
            $s1 = $inStr;
            $s1 = str_replace('&', '&amp;', $s1);
            $s1 = str_replace('<', '&lt;', $s1);
            $s1 = str_replace('>', '&gt;', $s1);
            return $s1;
        } else {
            return $inStr;
        }
    }

    public static function quote_attrib($inStr) {
        if (is_string($inStr) && !is_null($inStr)) {
            $s1 = $inStr;
            $s1 = str_replace('&', '&amp;', $s1);
            $s1 = str_replace('<', '&lt;', $s1);
            $s1 = str_replace('>', '&gt;', $s1);
            if (strpos($s1, '"') >= 0) {
                $s1 = str_replace('"', "&quot;", $s1);
            }
            return '"' . $s1 . '"';
        } else {
            return $inStr;
        }
    }

    public static function showIndent($out, $level){
        if ($level > 0) {
            foreach (range(1, $level) as $i){
                $out = self::addString($out, '    ');
            }
        }
        return $out;
    }

    public static function getNamespaceTag($objNS, $name, $defaultNS='', $ugNS='', $rootNS) {
        $ns = '';
        if ($objNS) {
            if (array_key_exists($name, $objNS)) {
                $ns = $objNS[$name];
            } else {
                if ($ugNS == $rootNS) {
                    $ns = '';
                } else {
                    if ($rootNS && $rootNS != $defaultNS) {
                        $ns = self::getNsid($defaultNS);
                    } else {
                        $ns = '';
                    }
                }
            }
        } else if ($ugNS && $ugNS != $rootNS) {
            $ns = self::getNsid($ugNS);
        }

        if (!empty($ns)) {
            $ns .= ':';
        }
        return $ns;
    }

    public static function getAttributeNamespaceTag($objNS, $name, $defaultNS='', $ugNS='', $rootNS='') {
        if (($rootNS == 'http://www.vmware.com/vcloud/v1.5' or
            $rootNS == 'http://www.vmware.com/vcloud/versions') && $defaultNS == $rootNS) {
            return '';
        }
        if ($defaultNS != 'http://schemas.dmtf.org/ovf/envelope/1') {
            return '';
        }
        return self::getNamespaceTag($objNS, $name, $defaultNS, $ugNS, $rootNS);
    }

    public static function getClassName($tagname) {
        $type = null;
        $nameClassMap = array(
            'QueryResultAclRuleRecordType'=>'VMware_VCloud_API_QueryResultAclRuleRecordType',
            'AdminServiceOfferingInstanceReferences'=>'VMware_VCloud_API_ReferencesType',
            'ServiceResourceResourceReferences'=>'VMware_VCloud_API_ReferencesType',
            'DiskSection_Type'=>'VMware_VCloud_API_OVF_DiskSection_Type',
            'NetworkSection_Type'=>'VMware_VCloud_API_OVF_NetworkSection_Type',
            'TasksListType'=>'VMware_VCloud_API_TasksListType',
            'OrgNetworkReference'=>'VMware_VCloud_API_ReferenceType',
            'ServiceOfferingInstanceReference'=>'VMware_VCloud_API_ReferenceType',
            'VAppOrgNetworkRelationReference'=>'VMware_VCloud_API_ReferenceType',
            'StartupSection'=>'VMware_VCloud_API_OVF_StartupSection_Type',
            'CoresPerSocket'=>'VMware_VCloud_API_CoresPerSocket_Type',
            'GatewayInterfacesType'=>'VMware_VCloud_API_GatewayInterfacesType',
            'ImportMediaParamsType'=>'VMware_VCloud_API_Extension_ImportMediaParamsType',
            'TaskReferences'=>'VMware_VCloud_API_ReferencesType',
            'VAppType'=>'VMware_VCloud_API_VAppType',
            'BootOrderSection'=>'VMware_VCloud_API_BootOrderSection_Type',
            'Metadata'=>'VMware_VCloud_API_MetadataType',
            'LinkType'=>'VMware_VCloud_API_LinkType',
            'QueryResultCatalogItemRecordType'=>'VMware_VCloud_API_QueryResultCatalogItemRecordType',
            'SystemConfigurationSettings'=>'VMware_VCloud_API_Extension_SystemConfigurationSettingsType',
            'Parent'=>'VMware_VCloud_API_OVF_cimString',
            'CloneMediaParams'=>'VMware_VCloud_API_CloneMediaParamsType',
            'IcmpSubType'=>'VMware_VCloud_API_string',
            'Catalog'=>'VMware_VCloud_API_CatalogType',
            'cimString'=>'VMware_VCloud_API_OVF_cimString',
            'FencePoolType'=>'VMware_VCloud_API_Extension_FencePoolType',
            'QueryResultResourceClassRecordType'=>'VMware_VCloud_API_QueryResultResourceClassRecordType',
            'ConfigurationName'=>'VMware_VCloud_API_OVF_cimString',
            'RightReference'=>'VMware_VCloud_API_ReferenceType',
            'VMWNetworkPoolType'=>'VMware_VCloud_API_Extension_VMWNetworkPoolType',
            'UserEntityRights'=>'VMware_VCloud_API_Extension_UserEntityRightsType',
            'VirtualSystemCollection_Type'=>'VMware_VCloud_API_OVF_VirtualSystemCollection_Type',
            'QueryResultAdminUserRecordType'=>'VMware_VCloud_API_QueryResultAdminUserRecordType',
            'VsToVmxMapType'=>'VMware_VCloud_API_VsToVmxMapType',
            'OrgVdcNetworkReferences'=>'VMware_VCloud_API_ReferencesType',
            'VAppTemplateChildrenType'=>'VMware_VCloud_API_VAppTemplateChildrenType',
            'TaskReference'=>'VMware_VCloud_API_ReferenceType',
            'QueryResultVAppRecordType'=>'VMware_VCloud_API_QueryResultVAppRecordType',
            'ConfigurationDataRoot'=>'VMware_VCloud_API_OVF_cimString',
            'LicensingVirtualMachineType'=>'VMware_VCloud_API_Extension_LicensingVirtualMachineType',
            'ProviderVdcResourcePoolRelationRecord'=>'VMware_VCloud_API_QueryResultProviderVdcResourcePoolRelationRecordType',
            'ServiceType'=>'VMware_VCloud_API_ServiceType',
            'VMWProviderVdcReference'=>'VMware_VCloud_API_ReferenceType',
            'OtherResourceType'=>'VMware_VCloud_API_OVF_cimString',
            'SnapshotSection'=>'VMware_VCloud_API_SnapshotSectionType',
            'VmServiceOfferingInstanceReference'=>'VMware_VCloud_API_ReferenceType',
            'VcTrustStoreUpdateParamsType'=>'VMware_VCloud_API_Extension_VcTrustStoreUpdateParamsType',
            'GatewayIpsecVpnServiceType'=>'VMware_VCloud_API_GatewayIpsecVpnServiceType',
            'OrgVdcStorageProfileReference'=>'VMware_VCloud_API_ReferenceType',
            'VMWProviderVdcResourcePoolSetType'=>'VMware_VCloud_API_Extension_VMWProviderVdcResourcePoolSetType',
            'ProductSectionList'=>'VMware_VCloud_API_ProductSectionListType',
            'BlockingTaskOperationParams'=>'VMware_VCloud_API_Extension_BlockingTaskOperationParamsType',
            'MetadataType'=>'VMware_VCloud_API_MetadataType',
            'Reference'=>'VMware_VCloud_API_ReferenceType',
            'NetworkPoolReferences'=>'VMware_VCloud_API_ReferencesType',
            'OrgVdcNetworkRecord'=>'VMware_VCloud_API_QueryResultOrgVdcNetworkRecordType',
            'RoleReferencesType'=>'VMware_VCloud_API_RoleReferencesType',
            'IpAddressesType'=>'VMware_VCloud_API_IpAddressesType',
            'ServiceExtension'=>'VMware_VCloud_API_Extension_AdminServiceExtensionType',
            'ResourceSubType'=>'VMware_VCloud_API_OVF_cimString',
            'Entity'=>'VMware_VCloud_API_EntityType',
            'LoadBalancerServiceType'=>'VMware_VCloud_API_LoadBalancerServiceType',
            'KeystoreUpdateParams'=>'VMware_VCloud_API_KeystoreUpdateParamsType',
            'AllEULAsAccepted'=>'VMware_VCloud_API_boolean',
            'EdgeGateway'=>'VMware_VCloud_API_GatewayType',
            'IpsecVpnRemotePeerType'=>'VMware_VCloud_API_IpsecVpnRemotePeerType',
            'VersionsType'=>'VMware_VCloud_API_Extension_VersionsType',
            'AdminDiskRecord'=>'VMware_VCloud_API_QueryResultAdminDiskRecordType',
            'MetadataValueType'=>'VMware_VCloud_API_MetadataValueType',
            'DatastoreReference'=>'VMware_VCloud_API_ReferenceType',
            'LBPersistenceType'=>'VMware_VCloud_API_LBPersistenceType',
            'SourcedVmInstantiationParamsType'=>'VMware_VCloud_API_SourcedVmInstantiationParamsType',
            'SnapshotDataRoot'=>'VMware_VCloud_API_OVF_cimString',
            'AdminVAppTemplateRecord'=>'VMware_VCloud_API_QueryResultAdminVAppTemplateRecordType',
            'ScreenTicket'=>'VMware_VCloud_API_ScreenTicketType',
            'SessionType'=>'VMware_VCloud_API_SessionType',
            'DiskCreateParamsType'=>'VMware_VCloud_API_DiskCreateParamsType',
            'RasdItemsList'=>'VMware_VCloud_API_RasdItemsListType',
            'MediaReferences'=>'VMware_VCloud_API_ReferencesType',
            'ApiDefinition'=>'VMware_VCloud_API_Extension_AdminApiDefinitionType',
            'VmDiskRelationRecord'=>'VMware_VCloud_API_QueryResultVmDiskRelationRecordType',
            'KeystoreUploadSocket'=>'VMware_VCloud_API_KeystoreUploadSocketType',
            'FileDescriptorRecord'=>'VMware_VCloud_API_QueryResultFileDescriptorRecordType',
            'OrgVdcResourcePoolRelationRecord'=>'VMware_VCloud_API_QueryResultOrgVdcResourcePoolRelationRecordType',
            'ApiFilter'=>'VMware_VCloud_API_Extension_ApiFilterType',
            'OrgOperationLimitsSettingsType'=>'VMware_VCloud_API_OrgOperationLimitsSettingsType',
            'MetadataValue'=>'VMware_VCloud_API_MetadataValueType',
            'AclRuleReference'=>'VMware_VCloud_API_ReferenceType',
            'UndeployVAppParams'=>'VMware_VCloud_API_UndeployVAppParamsType',
            'KerberosSettings'=>'VMware_VCloud_API_Extension_KerberosSettingsType',
            'OrgVdcStorageProfileReferences'=>'VMware_VCloud_API_ReferencesType',
            'FirewallService'=>'VMware_VCloud_API_FirewallServiceType',
            'NetworkSection'=>'VMware_VCloud_API_OVF_NetworkSection_Type',
            'CreateVdcParams'=>'VMware_VCloud_API_CreateVdcParamsType',
            'AdminVMRecord'=>'VMware_VCloud_API_QueryResultAdminVMRecordType',
            'NetworkPoolType'=>'VMware_VCloud_API_NetworkPoolType',
            'AutomaticStartupActionDelay'=>'VMware_VCloud_API_OVF_cimDateTime',
            'AdminVdcReferences'=>'VMware_VCloud_API_ReferencesType',
            'TaskType'=>'VMware_VCloud_API_TaskType',
            'Org'=>'VMware_VCloud_API_OrgType',
            'MetadataTypedValue'=>'VMware_VCloud_API_MetadataTypedValue',
            'QueryResultAllocatedExternalAddressRecordType'=>'VMware_VCloud_API_QueryResultAllocatedExternalAddressRecordType',
            'VirtualCenterRecord'=>'VMware_VCloud_API_QueryResultVirtualCenterRecordType',
            'ProductSection_Type'=>'VMware_VCloud_API_OVF_ProductSection_Type',
            'DiskCreateParams'=>'VMware_VCloud_API_DiskCreateParamsType',
            'OrgGuestPersonalizationSettings'=>'VMware_VCloud_API_OrgGuestPersonalizationSettingsType',
            'AdminFileDescriptorType'=>'VMware_VCloud_API_Extension_AdminFileDescriptorType',
            'HostRecord'=>'VMware_VCloud_API_QueryResultHostRecordType',
            'AddressOnParent'=>'VMware_VCloud_API_OVF_cimString',
            'LeaseSettingsSection'=>'VMware_VCloud_API_LeaseSettingsSectionType',
            'ResourceClassAction'=>'VMware_VCloud_API_Extension_ResourceClassActionType',
            'QueryResultProviderVdcResourcePoolRelationRecordType'=>'VMware_VCloud_API_QueryResultProviderVdcResourcePoolRelationRecordType',
            'IpRangeType'=>'VMware_VCloud_API_IpRangeType',
            'VMWVimServerReferencesType'=>'VMware_VCloud_API_Extension_VMWVimServerReferencesType',
            'DatastoreRecord'=>'VMware_VCloud_API_QueryResultDatastoreRecordType',
            'SystemConfigurationSettingValue'=>'VMware_VCloud_API_Extension_SystemConfigurationSettingValueType',
            'LdapSettings'=>'VMware_VCloud_API_Extension_LdapSettingsType',
            'SubAllocationsType'=>'VMware_VCloud_API_SubAllocationsType',
            'BlockingTaskRecord'=>'VMware_VCloud_API_QueryResultBlockingTaskRecordType',
            'RegisterVAppParams'=>'VMware_VCloud_API_RegisterVAppParamsType',
            'cimUnsignedInt'=>'VMware_VCloud_API_OVF_cimUnsignedInt',
            'VdcReferences'=>'VMware_VCloud_API_VdcReferencesType',
            'NatRuleType'=>'VMware_VCloud_API_NatRuleType',
            'cimFloat'=>'VMware_VCloud_API_OVF_cimFloat',
            'VAppOrgVdcNetworkRelationRecord'=>'VMware_VCloud_API_QueryResultVAppOrgVdcNetworkRelationRecordType',
            'GatewayNatRuleType'=>'VMware_VCloud_API_GatewayNatRuleType',
            'ServerType'=>'VMware_VCloud_API_Extension_ServerType',
            'StrandedItem'=>'VMware_VCloud_API_Extension_StrandedItemType',
            'AdminServiceLinkType'=>'VMware_VCloud_API_Extension_AdminServiceLinkType',
            'SuspendDataRoot'=>'VMware_VCloud_API_OVF_cimString',
            'AnnotationSection'=>'VMware_VCloud_API_OVF_AnnotationSection_Type',
            'VirtualSystemType'=>'VMware_VCloud_API_OVF_cimString',
            'Owner'=>'VMware_VCloud_API_OwnerType',
            'VAppNetworkConfigurationType'=>'VMware_VCloud_API_VAppNetworkConfigurationType',
            'cimInt'=>'VMware_VCloud_API_OVF_cimInt',
            'Event'=>'VMware_VCloud_API_EventType',
            'VAppNetwork'=>'VMware_VCloud_API_VAppNetworkType',
            'VAppTemplate'=>'VMware_VCloud_API_VAppTemplateType',
            'Group'=>'VMware_VCloud_API_GroupType',
            'OrgLeaseSettingsType'=>'VMware_VCloud_API_OrgLeaseSettingsType',
            'MetadataNumberValue'=>'VMware_VCloud_API_MetadataNumberValue',
            'ServiceOfferingAssociateParamsType'=>'VMware_VCloud_API_Extension_ServiceOfferingAssociateParamsType',
            'SystemSettingsType'=>'VMware_VCloud_API_Extension_SystemSettingsType',
            'GroupRecord'=>'VMware_VCloud_API_QueryResultGroupRecordType',
            'VendorServices'=>'VMware_VCloud_API_VendorServicesType',
            'VMWProviderVdcParams'=>'VMware_VCloud_API_Extension_VMWProviderVdcParamsType',
            'ApiDefinitionRecord'=>'VMware_VCloud_API_QueryResultApiDefinitionRecordType',
            'UpdateVdcStorageProfilesType'=>'VMware_VCloud_API_UpdateVdcStorageProfilesType',
            'InstantiationParamsType'=>'VMware_VCloud_API_InstantiationParamsType',
            'VMWNetworkPool'=>'VMware_VCloud_API_Extension_VMWNetworkPoolType',
            'VMReference'=>'VMware_VCloud_API_ReferenceType',
            'VMWProviderVdcReferencesType'=>'VMware_VCloud_API_Extension_VMWProviderVdcReferencesType',
            'GatewayIpsecVpnEndpointType'=>'VMware_VCloud_API_GatewayIpsecVpnEndpointType',
            'NicIpMapType'=>'VMware_VCloud_API_NicIpMapType',
            'OrgSettings'=>'VMware_VCloud_API_OrgSettingsType',
            'MigrateParams'=>'VMware_VCloud_API_Extension_MigrateParamsType',
            'ServiceOfferingRecord'=>'VMware_VCloud_API_QueryResultServiceOfferingRecordType',
            'QueryResultApiDefinitionRecordType'=>'VMware_VCloud_API_QueryResultApiDefinitionRecordType',
            'EventType'=>'VMware_VCloud_API_EventType',
            'SspiKeytabUpdateParams'=>'VMware_VCloud_API_SspiKeytabUpdateParamsType',
            'CloneVAppParams'=>'VMware_VCloud_API_CloneVAppParamsType',
            'NatOneToOneBasicRuleType'=>'VMware_VCloud_API_NatOneToOneBasicRuleType',
            'VimServerType'=>'VMware_VCloud_API_Extension_VimServerType',
            'CatalogReference'=>'VMware_VCloud_API_ReferenceType',
            'InstantiateVmParamsType'=>'VMware_VCloud_API_InstantiateVmParamsType',
            'SystemPasswordPolicySettingsType'=>'VMware_VCloud_API_Extension_SystemPasswordPolicySettingsType',
            'VxlanPoolType'=>'VMware_VCloud_API_Extension_VxlanPoolType',
            'OrgEmailSettingsType'=>'VMware_VCloud_API_OrgEmailSettingsType',
            'QueryResultStrandedItemRecordType'=>'VMware_VCloud_API_QueryResultStrandedItemRecordType',
            'AclRuleReferences'=>'VMware_VCloud_API_ReferencesType',
            'CatalogItemsType'=>'VMware_VCloud_API_CatalogItemsType',
            'AllocationUnits'=>'VMware_VCloud_API_OVF_cimString',
            'QueryResultRecords'=>'VMware_VCloud_API_QueryResultRecordsType',
            'QueryResultPortgroupRecordType'=>'VMware_VCloud_API_QueryResultPortgroupRecordType',
            'CreateSnapshotParamsType'=>'VMware_VCloud_API_CreateSnapshotParamsType',
            'GatewayConfigurationType'=>'VMware_VCloud_API_GatewayConfigurationType',
            'OrgPasswordPolicySettingsType'=>'VMware_VCloud_API_OrgPasswordPolicySettingsType',
            'ServiceOfferingInstanceAssociateParams'=>'VMware_VCloud_API_Extension_ServiceOfferingInstanceAssociateParamsType',
            'RegisterVAppParamsType'=>'VMware_VCloud_API_RegisterVAppParamsType',
            'VmType'=>'VMware_VCloud_API_VmType',
            'Config_Type'=>'VMware_VCloud_API_Config_Type',
            'AdminVdcRecord'=>'VMware_VCloud_API_QueryResultAdminVdcRecordType',
            'Snapshot'=>'VMware_VCloud_API_SnapshotType',
            'cimChar16'=>'VMware_VCloud_API_OVF_cimChar16',
            'QueryResultVmDiskRelationRecordType'=>'VMware_VCloud_API_QueryResultVmDiskRelationRecordType',
            'VAppNetworkReferences'=>'VMware_VCloud_API_ReferencesType',
            'VMWStorageProfiles'=>'VMware_VCloud_API_Extension_VMWStorageProfilesType',
            'VdcServiceOfferingReferences'=>'VMware_VCloud_API_ReferencesType',
            'DvSwitchRecord'=>'VMware_VCloud_API_QueryResultDvSwitchRecordType',
            'cimShort'=>'VMware_VCloud_API_OVF_cimShort',
            'ReferencesType'=>'VMware_VCloud_API_ReferencesType',
            'OrgNetworkType'=>'VMware_VCloud_API_OrgNetworkType',
            'RegisterVimServerParams'=>'VMware_VCloud_API_Extension_RegisterVimServerParamsType',
            'VmServiceOfferingInstanceReferences'=>'VMware_VCloud_API_ReferencesType',
            'SspiKeytabUploadSocketType'=>'VMware_VCloud_API_SspiKeytabUploadSocketType',
            'DatastoreProviderVdcRelationRecord'=>'VMware_VCloud_API_QueryResultDatastoreProviderVdcRelationRecordType',
            'AdminServiceLinksType'=>'VMware_VCloud_API_Extension_AdminServiceLinksType',
            'DeploymentOptionSection'=>'VMware_VCloud_API_OVF_DeploymentOptionSection_Type',
            'CpuCompatibilitySection_Type'=>'VMware_VCloud_API_CpuCompatibilitySection_Type',
            'AllocatedIpAddresses'=>'VMware_VCloud_API_AllocatedIpAddressesType',
            'AdminVdcType'=>'VMware_VCloud_API_AdminVdcType',
            'VMWProviderVdcResourcePoolType'=>'VMware_VCloud_API_Extension_VMWProviderVdcResourcePoolType',
            'ComplianceResult'=>'VMware_VCloud_API_ComplianceResultType',
            'SmtpSettingsType'=>'VMware_VCloud_API_Extension_SmtpSettingsType',
            'RecomposeVAppParamsType'=>'VMware_VCloud_API_RecomposeVAppParamsType',
            'UserReferences'=>'VMware_VCloud_API_ReferencesType',
            'ServiceOfferingInstanceDisassociateParamsType'=>'VMware_VCloud_API_Extension_ServiceOfferingInstanceDisassociateParamsType',
            'OrgVdcNetworkReference'=>'VMware_VCloud_API_ReferenceType',
            'Media'=>'VMware_VCloud_API_MediaType',
            'InstantiateOvfPropertyType'=>'VMware_VCloud_API_InstantiateOvfPropertyType',
            'ServiceOfferingReference'=>'VMware_VCloud_API_ReferenceType',
            'StaticRoutingService'=>'VMware_VCloud_API_StaticRoutingServiceType',
            'CloneVAppTemplateParams'=>'VMware_VCloud_API_CloneVAppTemplateParamsType',
            'PortgroupRecord'=>'VMware_VCloud_API_QueryResultPortgroupRecordType',
            'SystemSettings'=>'VMware_VCloud_API_Extension_SystemSettingsType',
            'ImportVmAsVAppParams'=>'VMware_VCloud_API_Extension_ImportVmAsVAppParamsType',
            'FileDescriptor'=>'VMware_VCloud_API_Extension_AdminFileDescriptorType',
            'UserRecord'=>'VMware_VCloud_API_QueryResultUserRecordType',
            'MigrateParamsType'=>'VMware_VCloud_API_Extension_MigrateParamsType',
            'ResourceClass'=>'VMware_VCloud_API_Extension_ResourceClassType',
            'NetworkService'=>'VMware_VCloud_API_NetworkServiceType',
            'CertificateUpdateParams'=>'VMware_VCloud_API_CertificateUpdateParamsType',
            'GeneralOrgSettings'=>'VMware_VCloud_API_OrgGeneralSettingsType',
            'VAppOrgVdcNetworkRelationReference'=>'VMware_VCloud_API_ReferenceType',
            'IpRangesType'=>'VMware_VCloud_API_IpRangesType',
            'InstallSection'=>'VMware_VCloud_API_OVF_InstallSection_Type',
            'VirtualMachine'=>'VMware_VCloud_API_Extension_LicensingVirtualMachineType',
            'VimObjectRefListType'=>'VMware_VCloud_API_Extension_VimObjectRefListType',
            'QueryResultAdminApiDefinitionRecordType'=>'VMware_VCloud_API_QueryResultAdminApiDefinitionRecordType',
            'AuthorizationCheckParamsType'=>'VMware_VCloud_API_Extension_AuthorizationCheckParamsType',
            'Reservation'=>'VMware_VCloud_API_OVF_cimUnsignedLong',
            'QueryResultAdminServiceOfferingInstanceRecordType'=>'VMware_VCloud_API_QueryResultAdminServiceOfferingInstanceRecordType',
            'AmqpSettingsType'=>'VMware_VCloud_API_Extension_AmqpSettingsType',
            'OrganizationResourcePoolSetType'=>'VMware_VCloud_API_Extension_OrganizationResourcePoolSetType',
            'OperatingSystemFamilyInfoType'=>'VMware_VCloud_API_OperatingSystemFamilyInfoType',
            'License'=>'VMware_VCloud_API_Extension_LicenseType',
            'MappingBehavior'=>'VMware_VCloud_API_OVF_MappingBehavior',
            'PrepareHostParams'=>'VMware_VCloud_API_Extension_PrepareHostParamsType',
            'VAppTemplateReference'=>'VMware_VCloud_API_ReferenceType',
            'AdminVdcStorageProfile'=>'VMware_VCloud_API_AdminVdcStorageProfileType',
            'QueryResultAdminAllocatedExternalAddressRecordType'=>'VMware_VCloud_API_QueryResultAdminAllocatedExternalAddressRecordType',
            'VdcsType'=>'VMware_VCloud_API_VdcsType',
            'CaptureVAppParamsType'=>'VMware_VCloud_API_CaptureVAppParamsType',
            'AdminDiskReferences'=>'VMware_VCloud_API_ReferencesType',
            'QueryResultApiFilterRecordType'=>'VMware_VCloud_API_QueryResultApiFilterRecordType',
            'Content_Type'=>'VMware_VCloud_API_OVF_Content_Type',
            'ExternalNatIpMapType'=>'VMware_VCloud_API_ExternalNatIpMapType',
            'ContainerType'=>'VMware_VCloud_API_ContainerType',
            'VMWProviderVdcStorageProfileType'=>'VMware_VCloud_API_Extension_VMWProviderVdcStorageProfileType',
            'VirtualSystem'=>'VMware_VCloud_API_OVF_VirtualSystem_Type',
            'ServiceOfferingInstance'=>'VMware_VCloud_API_Extension_ServiceOfferingInstanceType',
            'QueryResultFileDescriptorRecordType'=>'VMware_VCloud_API_QueryResultFileDescriptorRecordType',
            'VApp'=>'VMware_VCloud_API_VAppType',
            'EnvelopeType'=>'VMware_VCloud_API_OVF_EnvelopeType',
            'VmQuestionAnswerType'=>'VMware_VCloud_API_VmQuestionAnswerType',
            'cimHexBinary'=>'VMware_VCloud_API_OVF_cimHexBinary',
            'EmailSettingsType'=>'VMware_VCloud_API_Extension_EmailSettingsType',
            'CatalogItemReference'=>'VMware_VCloud_API_ReferenceType',
            'LdapSettingsType'=>'VMware_VCloud_API_Extension_LdapSettingsType',
            'IpsecVpnThirdPartyPeer'=>'VMware_VCloud_API_IpsecVpnThirdPartyPeerType',
            'File'=>'VMware_VCloud_API_FileType',
            'CIM_ResourceAllocationSettingData_Type'=>'VMware_VCloud_API_OVF_CIM_ResourceAllocationSettingData_Type',
            'IpScopesType'=>'VMware_VCloud_API_IpScopesType',
            'CreateVdcParamsType'=>'VMware_VCloud_API_CreateVdcParamsType',
            'VdsContextType'=>'VMware_VCloud_API_Extension_VdsContextType',
            'qualifierSArray'=>'VMware_VCloud_API_OVF_qualifierSArray',
            'BlockingTask'=>'VMware_VCloud_API_Extension_BlockingTaskType',
            'OrgVdcStorageProfileRecord'=>'VMware_VCloud_API_QueryResultOrgVdcStorageProfileRecordType',
            'LBPoolMemberType'=>'VMware_VCloud_API_LBPoolMemberType',
            'SystemConfigurationSettingType'=>'VMware_VCloud_API_Extension_SystemConfigurationSettingType',
            'ControlAccessParams'=>'VMware_VCloud_API_ControlAccessParamsType',
            'LogDataRoot'=>'VMware_VCloud_API_OVF_cimString',
            'CreationTime'=>'VMware_VCloud_API_OVF_cimDateTime',
            'VMWStorageProfileType'=>'VMware_VCloud_API_Extension_VMWStorageProfileType',
            'CustomOrgLdapSettingsType'=>'VMware_VCloud_API_CustomOrgLdapSettingsType',
            'ServiceOfferingInstanceParamsType'=>'VMware_VCloud_API_Extension_ServiceOfferingInstanceParamsType',
            'PortGroupPoolType'=>'VMware_VCloud_API_Extension_PortGroupPoolType',
            'VmSelectionType'=>'VMware_VCloud_API_VmSelectionType',
            'ExtensionObjectRef'=>'VMware_VCloud_API_Extension_ExtensionObjectRefType',
            'InstantiateVAppParamsType'=>'VMware_VCloud_API_InstantiateVAppParamsType',
            'ConfigurationFile'=>'VMware_VCloud_API_OVF_cimString',
            'BundleUploadParamsType'=>'VMware_VCloud_API_Extension_BundleUploadParamsType',
            'DhcpPoolServiceType'=>'VMware_VCloud_API_DhcpPoolServiceType',
            'HostReference'=>'VMware_VCloud_API_ReferenceType',
            'Direction'=>'VMware_VCloud_API_string',
            'UndeployVAppParamsType'=>'VMware_VCloud_API_UndeployVAppParamsType',
            'OrgListType'=>'VMware_VCloud_API_OrgListType',
            'VmVimInfo'=>'VMware_VCloud_API_Extension_VmVimInfoType',
            'DiskSection'=>'VMware_VCloud_API_OVF_DiskSection_Type',
            'ImportMediaParams'=>'VMware_VCloud_API_Extension_ImportMediaParamsType',
            'ApiFilters'=>'VMware_VCloud_API_Extension_ApiFiltersType',
            'QueryResultServiceOfferingRecordType'=>'VMware_VCloud_API_QueryResultServiceOfferingRecordType',
            'SystemPasswordPolicySettings'=>'VMware_VCloud_API_Extension_SystemPasswordPolicySettingsType',
            'LicensingReportType'=>'VMware_VCloud_API_Extension_LicensingReportType',
            'AutomaticShutdownAction'=>'VMware_VCloud_API_OVF_AutomaticShutdownAction',
            'CbmData'=>'VMware_VCloud_API_Extension_CbmDataType',
            'VMWHostReferences'=>'VMware_VCloud_API_Extension_VMWHostReferencesType',
            'PrepareHostParamsType'=>'VMware_VCloud_API_Extension_PrepareHostParamsType',
            'UserEntityRightsType'=>'VMware_VCloud_API_Extension_UserEntityRightsType',
            'ExternalNetwork'=>'VMware_VCloud_API_ExternalNetworkType',
            'VmVimInfoType'=>'VMware_VCloud_API_Extension_VmVimInfoType',
            'ServiceOfferingType'=>'VMware_VCloud_API_Extension_ServiceOfferingType',
            'IpsecVpnLocalPeerType'=>'VMware_VCloud_API_IpsecVpnLocalPeerType',
            'Task'=>'VMware_VCloud_API_TaskType',
            'LicensingReportRecord'=>'VMware_VCloud_API_QueryResultLicensingReportRecordType',
            'KeystoreUpdateParamsType'=>'VMware_VCloud_API_KeystoreUpdateParamsType',
            'ServiceLink'=>'VMware_VCloud_API_Extension_AdminServiceLinkType',
            'PoolID'=>'VMware_VCloud_API_OVF_cimString',
            'VendorTemplateAttributesType'=>'VMware_VCloud_API_VendorTemplateAttributesType',
            'AdminServiceReference'=>'VMware_VCloud_API_ReferenceType',
            'PublishCatalogParamsType'=>'VMware_VCloud_API_PublishCatalogParamsType',
            'DhcpService'=>'VMware_VCloud_API_DhcpServiceType',
            'DatastoreReferences'=>'VMware_VCloud_API_ReferencesType',
            'AclRule'=>'VMware_VCloud_API_Extension_AclRuleType',
            'ProviderVdcStorageProfiles'=>'VMware_VCloud_API_ProviderVdcStorageProfilesType',
            'cimBoolean'=>'VMware_VCloud_API_OVF_cimBoolean',
            'PublishExternalCatalogParamsType'=>'VMware_VCloud_API_PublishExternalCatalogParamsType',
            'ResourceEntitiesType'=>'VMware_VCloud_API_ResourceEntitiesType',
            'SystemConfigurationSetting'=>'VMware_VCloud_API_Extension_SystemConfigurationSettingType',
            'AdminUserRecord'=>'VMware_VCloud_API_QueryResultAdminUserRecordType',
            'QueryResultVirtualCenterRecordType'=>'VMware_VCloud_API_QueryResultVirtualCenterRecordType',
            'GuestCustomizationSection'=>'VMware_VCloud_API_GuestCustomizationSectionType',
            'FileUploadSocketType'=>'VMware_VCloud_API_FileUploadSocketType',
            'ServiceOfferingInstanceCreateParams'=>'VMware_VCloud_API_Extension_ServiceOfferingInstanceCreateParamsType',
            'GroupsListType'=>'VMware_VCloud_API_GroupsListType',
            'RasdItemsListType'=>'VMware_VCloud_API_RasdItemsListType',
            'VirtualDiskDesc_Type'=>'VMware_VCloud_API_OVF_VirtualDiskDesc_Type',
            'VdcStorageProfileParamsType'=>'VMware_VCloud_API_VdcStorageProfileParamsType',
            'VirtualHardwareSection'=>'VMware_VCloud_API_OVF_VirtualHardwareSection_Type',
            'LookupServiceSettings'=>'VMware_VCloud_API_Extension_LookupServiceSettingsType',
            'cimDouble'=>'VMware_VCloud_API_OVF_cimDouble',
            'ResourcePoolVMRecord'=>'VMware_VCloud_API_QueryResultResourcePoolVMRecordType',
            'Disk'=>'VMware_VCloud_API_DiskType',
            'AllocatedIpAddressesType'=>'VMware_VCloud_API_AllocatedIpAddressesType',
            'QueryResultTaskRecordType'=>'VMware_VCloud_API_QueryResultTaskRecordType',
            'NetworkPoolReference'=>'VMware_VCloud_API_ReferenceType',
            'qualifierSInt64'=>'VMware_VCloud_API_OVF_qualifierSInt64',
            'NetworkConfigurationType'=>'VMware_VCloud_API_NetworkConfigurationType',
            'VdcStorageProfileParams'=>'VMware_VCloud_API_VdcStorageProfileParamsType',
            'OrgVdcReferences'=>'VMware_VCloud_API_ReferencesType',
            'LookupServiceParams'=>'VMware_VCloud_API_Extension_LookupServiceParamsType',
            'NetworkConfigSectionType'=>'VMware_VCloud_API_NetworkConfigSectionType',
            'QueryResultAdminMediaRecordType'=>'VMware_VCloud_API_QueryResultAdminMediaRecordType',
            'QueryResultAdminVdcRecordType'=>'VMware_VCloud_API_QueryResultAdminVdcRecordType',
            'QueryResultConditionRecordType'=>'VMware_VCloud_API_QueryResultConditionRecordType',
            'GeneralSettings'=>'VMware_VCloud_API_Extension_GeneralSettingsType',
            'LoadBalancerVirtualServerType'=>'VMware_VCloud_API_LoadBalancerVirtualServerType',
            'NetworkAssignmentType'=>'VMware_VCloud_API_NetworkAssignmentType',
            'VlanPoolType'=>'VMware_VCloud_API_Extension_VlanPoolType',
            'UserReference'=>'VMware_VCloud_API_ReferenceType',
            'AdminServiceRecord'=>'VMware_VCloud_API_QueryResultAdminServiceRecordType',
            'QueryResultOrgNetworkRecordType'=>'VMware_VCloud_API_QueryResultOrgNetworkRecordType',
            'ComposeVAppParamsType'=>'VMware_VCloud_API_ComposeVAppParamsType',
            'UserType'=>'VMware_VCloud_API_UserType',
            'ResourceClassesType'=>'VMware_VCloud_API_Extension_ResourceClassesType',
            'StartupSection_Type'=>'VMware_VCloud_API_OVF_StartupSection_Type',
            'InstantiateOvfProperty'=>'VMware_VCloud_API_InstantiateOvfPropertyType',
            'VAppLeaseSettings'=>'VMware_VCloud_API_OrgLeaseSettingsType',
            'AllocatedIpAddressType'=>'VMware_VCloud_API_AllocatedIpAddressType',
            'AdminOrgVdcStorageProfileReference'=>'VMware_VCloud_API_ReferenceType',
            'EntityLinkType'=>'VMware_VCloud_API_EntityLinkType',
            'NetworkServiceInsertion'=>'VMware_VCloud_API_NetworkServiceInsertionType',
            'AmqpSettingsTestType'=>'VMware_VCloud_API_Extension_AmqpSettingsTestType',
            'SystemConfigurationSettingsType'=>'VMware_VCloud_API_Extension_SystemConfigurationSettingsType',
            'QueryResultNetworkRecordType'=>'VMware_VCloud_API_QueryResultNetworkRecordType',
            'EdgeGatewayRecord'=>'VMware_VCloud_API_QueryResultEdgeGatewayRecordType',
            'ConfigurationID'=>'VMware_VCloud_API_OVF_cimString',
            'AnnotationSection_Type'=>'VMware_VCloud_API_OVF_AnnotationSection_Type',
            'TaskRecord'=>'VMware_VCloud_API_QueryResultTaskRecordType',
            'UberAdminSettingsType'=>'VMware_VCloud_API_Extension_UberAdminSettingsType',
            'Record'=>'VMware_VCloud_API_QueryResultRecordType',
            'QueryResultCatalogRecordType'=>'VMware_VCloud_API_QueryResultCatalogRecordType',
            'OrgVAppTemplateLeaseSettings'=>'VMware_VCloud_API_OrgVAppTemplateLeaseSettingsType',
            'GatewayDhcpServiceType'=>'VMware_VCloud_API_GatewayDhcpServiceType',
            'ServiceOfferingParamsMetaInfoType'=>'VMware_VCloud_API_Extension_ServiceOfferingParamsMetaInfoType',
            'NumericRangeType'=>'VMware_VCloud_API_Extension_NumericRangeType',
            'OrgFederationSettings'=>'VMware_VCloud_API_OrgFederationSettingsType',
            'Strings'=>'VMware_VCloud_API_OVF_Strings_Type',
            'OrgLdapUserAttributesType'=>'VMware_VCloud_API_OrgLdapUserAttributesType',
            'ImportVmAsVAppTemplateParams'=>'VMware_VCloud_API_Extension_ImportVmAsVAppTemplateParamsType',
            'RealmType'=>'VMware_VCloud_API_Extension_RealmType',
            'QueryResultDatastoreRecordType'=>'VMware_VCloud_API_QueryResultDatastoreRecordType',
            'SupportedHardwareVersionsType'=>'VMware_VCloud_API_SupportedHardwareVersionsType',
            'LicensingManagedServerRecord'=>'VMware_VCloud_API_QueryResultLicensingManagedServerRecordType',
            'VendorServicesType'=>'VMware_VCloud_API_VendorServicesType',
            'ScreenTicketType'=>'VMware_VCloud_API_ScreenTicketType',
            'SourcePort'=>'VMware_VCloud_API_int',
            'GeneralSettingsType'=>'VMware_VCloud_API_Extension_GeneralSettingsType',
            'OperatingSystemSection_Type'=>'VMware_VCloud_API_OVF_OperatingSystemSection_Type',
            'VirtualCenterReferences'=>'VMware_VCloud_API_ReferencesType',
            'MetadataStringValue'=>'VMware_VCloud_API_MetadataStringValue',
            'NetworksType'=>'VMware_VCloud_API_NetworksType',
            'CatalogsListType'=>'VMware_VCloud_API_CatalogsListType',
            'RuntimeInfoSection'=>'VMware_VCloud_API_RuntimeInfoSectionType',
            'KeystoreUploadSocketType'=>'VMware_VCloud_API_KeystoreUploadSocketType',
            'Notification'=>'VMware_VCloud_API_Extension_NotificationType',
            'CatalogReferences'=>'VMware_VCloud_API_ReferencesType',
            'RelocateParams'=>'VMware_VCloud_API_RelocateParamsType',
            'VendorTemplateType'=>'VMware_VCloud_API_VendorTemplateType',
            'Strings_Type'=>'VMware_VCloud_API_OVF_Strings_Type',
            'QueryResultProviderVdcStorageProfileRecordType'=>'VMware_VCloud_API_QueryResultProviderVdcStorageProfileRecordType',
            'QueryResultServiceRecordType'=>'VMware_VCloud_API_QueryResultServiceRecordType',
            'OrgVdcRecord'=>'VMware_VCloud_API_QueryResultOrgVdcRecordType',
            'AdminOrgType'=>'VMware_VCloud_API_AdminOrgType',
            'ResourcePoolType'=>'VMware_VCloud_API_Extension_ResourcePoolType',
            'NetworkFeaturesType'=>'VMware_VCloud_API_NetworkFeaturesType',
            'RootComputeCapacityType'=>'VMware_VCloud_API_RootComputeCapacityType',
            'MksTicketType'=>'VMware_VCloud_API_MksTicketType',
            'IpsecVpnSubnetType'=>'VMware_VCloud_API_IpsecVpnSubnetType',
            'StrandedItemVimObjectType'=>'VMware_VCloud_API_Extension_StrandedItemVimObjectType',
            'CopyOrMoveCatalogItemParamsType'=>'VMware_VCloud_API_CopyOrMoveCatalogItemParamsType',
            'AuthorizationCheckResponse'=>'VMware_VCloud_API_Extension_AuthorizationCheckResponseType',
            'UpdateRightsParams'=>'VMware_VCloud_API_Extension_UpdateRightsParamsType',
            'VAppTemplateRecord'=>'VMware_VCloud_API_QueryResultVAppTemplateRecordType',
            'OrgVdcNetwork'=>'VMware_VCloud_API_OrgVdcNetworkType',
            'CreateSnapshotParams'=>'VMware_VCloud_API_CreateSnapshotParamsType',
            'RightType'=>'VMware_VCloud_API_RightType',
            'ApiExtensibilityType'=>'VMware_VCloud_API_ApiExtensibilityType',
            'VdcServiceOfferingReference'=>'VMware_VCloud_API_ReferenceType',
            'ServiceOfferingParamsMetaInfo'=>'VMware_VCloud_API_Extension_ServiceOfferingParamsMetaInfoType',
            'VMWExtensionType'=>'VMware_VCloud_API_Extension_VMWExtensionType',
            'DiskRecord'=>'VMware_VCloud_API_QueryResultDiskRecordType',
            'ServiceOfferingParamMetaInfo'=>'VMware_VCloud_API_Extension_ServiceOfferingParamMetaInfoType',
            'QueryResultAdminVAppTemplateRecordType'=>'VMware_VCloud_API_QueryResultAdminVAppTemplateRecordType',
            'ProviderVdcMergeParams'=>'VMware_VCloud_API_Extension_ProviderVdcMergeParamsType',
            'CapacityWithUsageType'=>'VMware_VCloud_API_CapacityWithUsageType',
            'ServiceLinkReferences'=>'VMware_VCloud_API_ReferencesType',
            'SspiKeytabUpdateParamsType'=>'VMware_VCloud_API_SspiKeytabUpdateParamsType',
            'LBPoolHealthCheckType'=>'VMware_VCloud_API_LBPoolHealthCheckType',
            'FirewallServiceType'=>'VMware_VCloud_API_FirewallServiceType',
            'ManagedServer'=>'VMware_VCloud_API_Extension_LicensingManagedServerType',
            'QueryResultOrgVdcResourcePoolRelationRecordType'=>'VMware_VCloud_API_QueryResultOrgVdcResourcePoolRelationRecordType',
            'MediaInsertOrEjectParamsType'=>'VMware_VCloud_API_MediaInsertOrEjectParamsType',
            'GatewayInterfaceType'=>'VMware_VCloud_API_GatewayInterfaceType',
            'Section_Type'=>'VMware_VCloud_API_OVFENV_Section_Type',
            'MediaReference'=>'VMware_VCloud_API_ReferenceType',
            'OrgSettingsType'=>'VMware_VCloud_API_OrgSettingsType',
            'CustomizationSectionType'=>'VMware_VCloud_API_CustomizationSectionType',
            'TrustStoreUploadSocket'=>'VMware_VCloud_API_TrustStoreUploadSocketType',
            'References'=>'VMware_VCloud_API_ReferencesType',
            'NetworkMapping'=>'VMware_VCloud_API_NetworkMappingType',
            'NetworkType'=>'VMware_VCloud_API_NetworkType',
            'SnapshotSectionType'=>'VMware_VCloud_API_SnapshotSectionType',
            'IdentifiableResourceType'=>'VMware_VCloud_API_IdentifiableResourceType',
            'AutomaticStartupActionSequenceNumber'=>'VMware_VCloud_API_OVF_cimUnsignedShort',
            'VSphereWebClientUrlType'=>'VMware_VCloud_API_Extension_VSphereWebClientUrlType',
            'AutomaticAllocation'=>'VMware_VCloud_API_OVF_cimBoolean',
            'NetworkRecord'=>'VMware_VCloud_API_QueryResultNetworkRecordType',
            'ResourceClassActionType'=>'VMware_VCloud_API_Extension_ResourceClassActionType',
            'References_Type'=>'VMware_VCloud_API_OVF_References_Type',
            'QueryResultMediaRecordType'=>'VMware_VCloud_API_QueryResultMediaRecordType',
            'VmObjectRefType'=>'VMware_VCloud_API_Extension_VmObjectRefType',
            'OrgFederationSettingsType'=>'VMware_VCloud_API_OrgFederationSettingsType',
            'VAppOrgNetworkRelationRecord'=>'VMware_VCloud_API_QueryResultVAppOrgNetworkRelationRecordType',
            'QueryResultOrgVdcNetworkRecordType'=>'VMware_VCloud_API_QueryResultOrgVdcNetworkRecordType',
            'QueryResultOrgVdcStorageProfileRecordType'=>'VMware_VCloud_API_QueryResultOrgVdcStorageProfileRecordType',
            'RegisterVimServerParamsType'=>'VMware_VCloud_API_Extension_RegisterVimServerParamsType',
            'CopyOrMoveCatalogItemParams'=>'VMware_VCloud_API_CopyOrMoveCatalogItemParamsType',
            'VirtualSystemCollection'=>'VMware_VCloud_API_OVF_VirtualSystemCollection_Type',
            'NetworkPoolRecord'=>'VMware_VCloud_API_QueryResultNetworkPoolRecordType',
            'FileDescriptorType'=>'VMware_VCloud_API_FileDescriptorType',
            'NatServiceType'=>'VMware_VCloud_API_NatServiceType',
            'StaticRoutingServiceType'=>'VMware_VCloud_API_StaticRoutingServiceType',
            'ServiceReferences'=>'VMware_VCloud_API_ReferencesType',
            'QueryResultAdminEventRecordType'=>'VMware_VCloud_API_QueryResultAdminEventRecordType',
            'SyslogServerSettingsType'=>'VMware_VCloud_API_SyslogServerSettingsType',
            'TaskRequestBaseType'=>'VMware_VCloud_API_TaskRequestBaseType',
            'ServiceOfferingAssociateParams'=>'VMware_VCloud_API_Extension_ServiceOfferingAssociateParamsType',
            'InstantiateOvfParams'=>'VMware_VCloud_API_InstantiateOvfParamsType',
            'QueryResultAdminCatalogItemRecordType'=>'VMware_VCloud_API_QueryResultAdminCatalogItemRecordType',
            'AdminFileDescriptorReferences'=>'VMware_VCloud_API_ReferencesType',
            'ServiceLinks'=>'VMware_VCloud_API_Extension_AdminServiceLinksType',
            'ComponentManagerSettings'=>'VMware_VCloud_API_Extension_ComponentManagerSettingsType',
            'HostReferences'=>'VMware_VCloud_API_ReferencesType',
            'ResourceReferenceType'=>'VMware_VCloud_API_ResourceReferenceType',
            'OrgVdcReference'=>'VMware_VCloud_API_ReferenceType',
            'ApiDefinitionType'=>'VMware_VCloud_API_ApiDefinitionType',
            'AdminDiskReference'=>'VMware_VCloud_API_ReferenceType',
            'AdminEventRecord'=>'VMware_VCloud_API_QueryResultAdminEventRecordType',
            'QueryResultAdminCatalogRecordType'=>'VMware_VCloud_API_QueryResultAdminCatalogRecordType',
            'AclRuleRecord'=>'VMware_VCloud_API_QueryResultAclRuleRecordType',
            'AdminAllocatedExternalAddressRecord'=>'VMware_VCloud_API_QueryResultAdminAllocatedExternalAddressRecordType',
            'StrandedItemVimObjectsType'=>'VMware_VCloud_API_Extension_StrandedItemVimObjectsType',
            'OrgsType'=>'VMware_VCloud_API_OrgsType',
            'ApiFilterReference'=>'VMware_VCloud_API_ReferenceType',
            'QueryResultExternalLocalizationRecordType'=>'VMware_VCloud_API_QueryResultExternalLocalizationRecordType',
            'Caption'=>'VMware_VCloud_API_OVF_Caption',
            'CbmDataType'=>'VMware_VCloud_API_Extension_CbmDataType',
            'ReferenceType'=>'VMware_VCloud_API_ReferenceType',
            'AdminTaskRecord'=>'VMware_VCloud_API_QueryResultAdminTaskRecordType',
            'IpsecVpnUnmanagedPeerType'=>'VMware_VCloud_API_IpsecVpnUnmanagedPeerType',
            'RoleReferences'=>'VMware_VCloud_API_ReferencesType',
            'VMWProviderVdcStorageProfile'=>'VMware_VCloud_API_Extension_VMWProviderVdcStorageProfileType',
            'AdminCatalog'=>'VMware_VCloud_API_AdminCatalogType',
            'VAppNetworkRecord'=>'VMware_VCloud_API_QueryResultVAppNetworkRecordType',
            'TrustStoreUpdateParams'=>'VMware_VCloud_API_TrustStoreUpdateParamsType',
            'ServiceResourceRecord'=>'VMware_VCloud_API_QueryResultServiceResourceRecordType',
            'RoleRecord'=>'VMware_VCloud_API_QueryResultRoleRecordType',
            'OrgType'=>'VMware_VCloud_API_OrgType',
            'Sample'=>'VMware_VCloud_API_Extension_LicensingReportSampleType',
            'IpsecVpnThirdPartyPeerType'=>'VMware_VCloud_API_IpsecVpnThirdPartyPeerType',
            'ProviderVdcStorageProfilesType'=>'VMware_VCloud_API_ProviderVdcStorageProfilesType',
            'PropertyType'=>'VMware_VCloud_API_PropertyType',
            'AdminServiceOfferingInstanceRecord'=>'VMware_VCloud_API_QueryResultAdminServiceOfferingInstanceRecordType',
            'VmPendingQuestion'=>'VMware_VCloud_API_VmPendingQuestionType',
            'InstantiateVmParams'=>'VMware_VCloud_API_InstantiateVmParamsType',
            'RuntimeInfoSectionType'=>'VMware_VCloud_API_RuntimeInfoSectionType',
            'RASD_Type'=>'VMware_VCloud_API_OVF_RASD_Type',
            'Vms'=>'VMware_VCloud_API_VmsType',
            'SerialPortConfigType'=>'VMware_VCloud_API_Extension_SerialPortConfigType',
            'KerberosSettingsType'=>'VMware_VCloud_API_Extension_KerberosSettingsType',
            'QueryResultVMWProviderVdcRecordType'=>'VMware_VCloud_API_QueryResultVMWProviderVdcRecordType',
            'ResourceClassActionReference'=>'VMware_VCloud_API_ReferenceType',
            'ResourceType'=>'VMware_VCloud_API_ResourceType',
            'RightsType'=>'VMware_VCloud_API_Extension_RightsType',
            'QueryResultAdminOrgNetworkRecordType'=>'VMware_VCloud_API_QueryResultAdminOrgNetworkRecordType',
            'IpsecVpnService'=>'VMware_VCloud_API_IpsecVpnServiceType',
            'ResourcePoolList'=>'VMware_VCloud_API_Extension_ResourcePoolListType',
            'DeploymentOptionSection_Type'=>'VMware_VCloud_API_OVF_DeploymentOptionSection_Type',
            'DiskType'=>'VMware_VCloud_API_DiskType',
            'CIM_VirtualSystemSettingData_Type'=>'VMware_VCloud_API_OVF_CIM_VirtualSystemSettingData_Type',
            'VMWProviderVdcResourcePoolSet'=>'VMware_VCloud_API_Extension_VMWProviderVdcResourcePoolSetType',
            'ApiExtensibility'=>'VMware_VCloud_API_ApiExtensibilityType',
            'Role'=>'VMware_VCloud_API_RoleType',
            'UpdateResourcePoolSetParamsType'=>'VMware_VCloud_API_Extension_UpdateResourcePoolSetParamsType',
            'MetadataEntryType'=>'VMware_VCloud_API_MetadataEntryType',
            'FirewallRuleType'=>'VMware_VCloud_API_FirewallRuleType',
            'AccessSettingType'=>'VMware_VCloud_API_AccessSettingType',
            'ServiceExtensionRecord'=>'VMware_VCloud_API_QueryResultServiceExtensionRecordType',
            'DiskAttachOrDetachParamsType'=>'VMware_VCloud_API_DiskAttachOrDetachParamsType',
            'LookupServiceSettingsType'=>'VMware_VCloud_API_Extension_LookupServiceSettingsType',
            'VAppOrgNetworkRelationReferences'=>'VMware_VCloud_API_ReferencesType',
            'Service'=>'VMware_VCloud_API_Extension_AdminServiceType',
            'PropertySection'=>'VMware_VCloud_API_OVFENV_PropertySection_Type',
            'CatalogStorageProfilesType'=>'VMware_VCloud_API_CatalogStorageProfilesType',
            'OwnerType'=>'VMware_VCloud_API_OwnerType',
            'MetadataDateTimeValue'=>'VMware_VCloud_API_MetadataDateTimeValue',
            'CatalogItemType'=>'VMware_VCloud_API_CatalogItemType',
            'File_Type'=>'VMware_VCloud_API_OVF_File_Type',
            'Link'=>'VMware_VCloud_API_LinkType',
            'ComplianceResultType'=>'VMware_VCloud_API_ComplianceResultType',
            'VCloudExtensionType'=>'VMware_VCloud_API_VCloudExtensionType',
            'AdminApiDefinitionsType'=>'VMware_VCloud_API_Extension_AdminApiDefinitionsType',
            'OrgEmailSettings'=>'VMware_VCloud_API_OrgEmailSettingsType',
            'QueryResultAdminDiskRecordType'=>'VMware_VCloud_API_QueryResultAdminDiskRecordType',
            'CapacityType'=>'VMware_VCloud_API_CapacityType',
            'Notes'=>'VMware_VCloud_API_OVF_cimString',
            'ConditionRecord'=>'VMware_VCloud_API_QueryResultConditionRecordType',
            'ServiceOfferingDisassociateParamsType'=>'VMware_VCloud_API_Extension_ServiceOfferingDisassociateParamsType',
            'EdgeGatewayReferences'=>'VMware_VCloud_API_ReferencesType',
            'ProductSectionListType'=>'VMware_VCloud_API_ProductSectionListType',
            'OperatingSystemSection'=>'VMware_VCloud_API_OVF_OperatingSystemSection_Type',
            'QueryResultVAppNetworkRecordType'=>'VMware_VCloud_API_QueryResultVAppNetworkRecordType',
            'qualifierString'=>'VMware_VCloud_API_OVF_qualifierString',
            'SspiKeytabUploadSocket'=>'VMware_VCloud_API_SspiKeytabUploadSocketType',
            'NetworkPoolReferencesType'=>'VMware_VCloud_API_NetworkPoolReferencesType',
            'AdminVdc'=>'VMware_VCloud_API_AdminVdcType',
            'GroupType'=>'VMware_VCloud_API_GroupType',
            'CapabilitiesType'=>'VMware_VCloud_API_CapabilitiesType',
            'Right'=>'VMware_VCloud_API_RightType',
            'ChangeableType'=>'VMware_VCloud_API_OVF_ChangeableType',
            'IpAssignmentSection'=>'VMware_VCloud_API_IpAssignmentSection_Type',
            'VmServiceOfferingInstanceRecord'=>'VMware_VCloud_API_QueryResultVmServiceOfferingInstanceRecordType',
            'PublishExternalCatalogParams'=>'VMware_VCloud_API_PublishExternalCatalogParamsType',
            'CertificateUploadSocketType'=>'VMware_VCloud_API_CertificateUploadSocketType',
            'NetworkMappingType'=>'VMware_VCloud_API_NetworkMappingType',
            'BlockingTaskUpdateProgressParamsType'=>'VMware_VCloud_API_Extension_BlockingTaskUpdateProgressParamsType',
            'SnapshotType'=>'VMware_VCloud_API_SnapshotType',
            'IpsecVpnPeer'=>'VMware_VCloud_API_IpsecVpnPeerType',
            'UpdateProviderVdcStorageProfilesParamsType'=>'VMware_VCloud_API_Extension_UpdateProviderVdcStorageProfilesParamsType',
            'ExternalCatalogSubscriptionParams'=>'VMware_VCloud_API_ExternalCatalogSubscriptionParamsType',
            'QueryResultAdminEventCBMRecordType'=>'VMware_VCloud_API_QueryResultAdminEventCBMRecordType',
            'VMWStorageProfilesType'=>'VMware_VCloud_API_Extension_VMWStorageProfilesType',
            'ErrorType'=>'VMware_VCloud_API_ErrorType',
            'ServiceReference'=>'VMware_VCloud_API_ReferenceType',
            'QueryResultVmServiceOfferingInstanceRecordType'=>'VMware_VCloud_API_QueryResultVmServiceOfferingInstanceRecordType',
            'ConfigKeyValue_Type'=>'VMware_VCloud_API_ConfigKeyValue_Type',
            'AdminServiceExtensionType'=>'VMware_VCloud_API_Extension_AdminServiceExtensionType',
            'RoleReference'=>'VMware_VCloud_API_ReferenceType',
            'LicensingManagedServerType'=>'VMware_VCloud_API_Extension_LicensingManagedServerType',
            'OrgLdapSettingsType'=>'VMware_VCloud_API_OrgLdapSettingsType',
            'VCloud'=>'VMware_VCloud_API_VCloudType',
            'NatService'=>'VMware_VCloud_API_NatServiceType',
            'VirtualMachineMetrics'=>'VMware_VCloud_API_VirtualMachineMetrics',
            'QueryResultBlockingTaskRecordType'=>'VMware_VCloud_API_QueryResultBlockingTaskRecordType',
            'OrgVAppTemplateLeaseSettingsType'=>'VMware_VCloud_API_OrgVAppTemplateLeaseSettingsType',
            'VmPendingQuestionType'=>'VMware_VCloud_API_VmPendingQuestionType',
            'LookupServiceParamsType'=>'VMware_VCloud_API_Extension_LookupServiceParamsType',
            'VMWVimServerReferences'=>'VMware_VCloud_API_Extension_VMWVimServerReferencesType',
            'DeployVAppParams'=>'VMware_VCloud_API_DeployVAppParamsType',
            'VimObjectRefType'=>'VMware_VCloud_API_Extension_VimObjectRefType',
            'ApiFiltersType'=>'VMware_VCloud_API_Extension_ApiFiltersType',
            'NotificationType'=>'VMware_VCloud_API_Extension_NotificationType',
            'LicensingReport'=>'VMware_VCloud_API_Extension_LicensingReportType',
            'ServiceOfferingReferences'=>'VMware_VCloud_API_ReferencesType',
            'AdminOrg'=>'VMware_VCloud_API_AdminOrgType',
            'AmqpSettingsTest'=>'VMware_VCloud_API_Extension_AmqpSettingsTestType',
            'ApiFilterReferences'=>'VMware_VCloud_API_ReferencesType',
            'ServiceResourceType'=>'VMware_VCloud_API_Extension_ServiceResourceType',
            'QueryResultRecordsType'=>'VMware_VCloud_API_QueryResultRecordsType',
            'VMReferences'=>'VMware_VCloud_API_ReferencesType',
            'SourcePortRange'=>'VMware_VCloud_API_string',
            'RoleType'=>'VMware_VCloud_API_RoleType',
            'PlatformSection'=>'VMware_VCloud_API_OVFENV_PlatformSection_Type',
            'CertificateUpdateParamsType'=>'VMware_VCloud_API_CertificateUpdateParamsType',
            'LBPoolServicePortType'=>'VMware_VCloud_API_LBPoolServicePortType',
            'IpsecVpnManagedPeerType'=>'VMware_VCloud_API_IpsecVpnManagedPeerType',
            'PropertySection_Type'=>'VMware_VCloud_API_OVFENV_PropertySection_Type',
            'DiskAttachOrDetachParams'=>'VMware_VCloud_API_DiskAttachOrDetachParamsType',
            'ExtensionServices'=>'VMware_VCloud_API_Extension_ExtensionServicesType',
            'VCloudType'=>'VMware_VCloud_API_VCloudType',
            'OrgPasswordPolicySettings'=>'VMware_VCloud_API_OrgPasswordPolicySettingsType',
            'QueryResultAdminOrgVdcStorageProfileRecordType'=>'VMware_VCloud_API_QueryResultAdminOrgVdcStorageProfileRecordType',
            'IpsecVpnPeerType'=>'VMware_VCloud_API_IpsecVpnPeerType',
            'DatastoreType'=>'VMware_VCloud_API_Extension_DatastoreType',
            'Orgs'=>'VMware_VCloud_API_OrgsType',
            'OrgOperationLimitsSettings'=>'VMware_VCloud_API_OrgOperationLimitsSettingsType',
            'AclRuleType'=>'VMware_VCloud_API_Extension_AclRuleType',
            'VirtualCenterReference'=>'VMware_VCloud_API_ReferenceType',
            'ResourceClassRecord'=>'VMware_VCloud_API_QueryResultResourceClassRecordType',
            'NotificationsSettingsType'=>'VMware_VCloud_API_Extension_NotificationsSettingsType',
            'TasksList'=>'VMware_VCloud_API_TasksListType',
            'QueryResultServiceOfferingInstanceRecordType'=>'VMware_VCloud_API_QueryResultServiceOfferingInstanceRecordType',
            'ResourceClassActionReferences'=>'VMware_VCloud_API_ReferencesType',
            'ServiceOfferingInstanceReferences'=>'VMware_VCloud_API_ReferencesType',
            'NetworkConnectionSection'=>'VMware_VCloud_API_NetworkConnectionSectionType',
            'ResourceClassType'=>'VMware_VCloud_API_Extension_ResourceClassType',
            'AuthorizationCheckResponseType'=>'VMware_VCloud_API_Extension_AuthorizationCheckResponseType',
            'VAppTemplateReferences'=>'VMware_VCloud_API_ReferencesType',
            'ProviderVdcStorageProfileReferences'=>'VMware_VCloud_API_ReferencesType',
            'QueryResultUserRecordType'=>'VMware_VCloud_API_QueryResultUserRecordType',
            'UpdateRightsParamsType'=>'VMware_VCloud_API_Extension_UpdateRightsParamsType',
            'ApiFilterType'=>'VMware_VCloud_API_Extension_ApiFilterType',
            'AdminApiDefinitionReference'=>'VMware_VCloud_API_ReferenceType',
            'VmQuestionAnswer'=>'VMware_VCloud_API_VmQuestionAnswerType',
            'ShadowVMReferences'=>'VMware_VCloud_API_ReferencesType',
            'SourcedCompositionItemParamType'=>'VMware_VCloud_API_SourcedCompositionItemParamType',
            'EdgeGatewayServiceConfiguration'=>'VMware_VCloud_API_GatewayFeaturesType',
            'IpAssignmentSection_Type'=>'VMware_VCloud_API_IpAssignmentSection_Type',
            'ServiceOfferingParamMetaInfoType'=>'VMware_VCloud_API_Extension_ServiceOfferingParamMetaInfoType',
            'AdminCatalogRecord'=>'VMware_VCloud_API_QueryResultAdminCatalogRecordType',
            'QueryResultVAppTemplateRecordType'=>'VMware_VCloud_API_QueryResultVAppTemplateRecordType',
            'RightReferences'=>'VMware_VCloud_API_ReferencesType',
            'VMWExternalNetwork'=>'VMware_VCloud_API_Extension_VMWExternalNetworkType',
            'CpuCompatibilitySection'=>'VMware_VCloud_API_CpuCompatibilitySection_Type',
            'QueryResultDiskRecordType'=>'VMware_VCloud_API_QueryResultDiskRecordType',
            'LocalityParamsType'=>'VMware_VCloud_API_LocalityParamsType',
            'VimObjectRefsType'=>'VMware_VCloud_API_Extension_VimObjectRefsType',
            'BundleUploadParams'=>'VMware_VCloud_API_Extension_BundleUploadParamsType',
            'QueryResultLicensingReportSampleRecordType'=>'VMware_VCloud_API_QueryResultLicensingReportSampleRecordType',
            'VMWProviderVdcParamsType'=>'VMware_VCloud_API_Extension_VMWProviderVdcParamsType',
            'QueryResultEdgeGatewayRecordType'=>'VMware_VCloud_API_QueryResultEdgeGatewayRecordType',
            'InstantiateVAppTemplateParamsType'=>'VMware_VCloud_API_InstantiateVAppTemplateParamsType',
            'RightReferencesType'=>'VMware_VCloud_API_RightReferencesType',
            'GatewayType'=>'VMware_VCloud_API_GatewayType',
            'ServiceRecord'=>'VMware_VCloud_API_QueryResultServiceRecordType',
            'StaticRouteType'=>'VMware_VCloud_API_StaticRouteType',
            'CoresPerSocket_Type'=>'VMware_VCloud_API_CoresPerSocket_Type',
            'SwapFileDataRoot'=>'VMware_VCloud_API_OVF_cimString',
            'VirtualQuantity'=>'VMware_VCloud_API_OVF_cimUnsignedLong',
            'AdminApiDefinitionType'=>'VMware_VCloud_API_Extension_AdminApiDefinitionType',
            'RelocateParamsType'=>'VMware_VCloud_API_RelocateParamsType',
            'LicensingReportSampleType'=>'VMware_VCloud_API_Extension_LicensingReportSampleType',
            'ImportVmAsVAppTemplateParamsType'=>'VMware_VCloud_API_Extension_ImportVmAsVAppTemplateParamsType',
            'CatalogRecord'=>'VMware_VCloud_API_QueryResultCatalogRecordType',
            'ProviderVdcMergeParamsType'=>'VMware_VCloud_API_Extension_ProviderVdcMergeParamsType',
            'ControlAccessParamsType'=>'VMware_VCloud_API_ControlAccessParamsType',
            'ResourcePoolListType'=>'VMware_VCloud_API_Extension_ResourcePoolListType',
            'TrustStoreUploadSocketType'=>'VMware_VCloud_API_TrustStoreUploadSocketType',
            'VSphereWebClientUrl'=>'VMware_VCloud_API_Extension_VSphereWebClientUrlType',
            'AdminEventCBMRecord'=>'VMware_VCloud_API_QueryResultAdminEventCBMRecordType',
            'GatewayDhcpService'=>'VMware_VCloud_API_GatewayDhcpServiceType',
            'LBVirtualServerServiceProfileType'=>'VMware_VCloud_API_LBVirtualServerServiceProfileType',
            'ApiFilterRecord'=>'VMware_VCloud_API_QueryResultApiFilterRecordType',
            'EntityReferences'=>'VMware_VCloud_API_Extension_EntityReferencesType',
            'cimUnsignedShort'=>'VMware_VCloud_API_OVF_cimUnsignedShort',
            'NetworkConnection'=>'VMware_VCloud_API_NetworkConnectionType',
            'NetworkConfigSection'=>'VMware_VCloud_API_NetworkConfigSectionType',
            'QueryResultServiceLinkRecordType'=>'VMware_VCloud_API_QueryResultServiceLinkRecordType',
            'BundleUploadSocket'=>'VMware_VCloud_API_Extension_BundleUploadSocketType',
            'SubnetParticipationType'=>'VMware_VCloud_API_SubnetParticipationType',
            'NetworkReferences'=>'VMware_VCloud_API_ReferencesType',
            'RequestOperationParamsType'=>'VMware_VCloud_API_RequestOperationParamsType',
            'ResourcePoolRecord'=>'VMware_VCloud_API_QueryResultResourcePoolRecordType',
            'QueryResultServiceResourceRecordType'=>'VMware_VCloud_API_QueryResultServiceResourceRecordType',
            'cimLong'=>'VMware_VCloud_API_OVF_cimLong',
            'CatalogItemRecord'=>'VMware_VCloud_API_QueryResultCatalogItemRecordType',
            'cimReference'=>'VMware_VCloud_API_OVF_cimReference',
            'ServiceOfferingDisassociateParams'=>'VMware_VCloud_API_Extension_ServiceOfferingDisassociateParamsType',
            'CatalogItem'=>'VMware_VCloud_API_CatalogItemType',
            'OrgNetworkReferences'=>'VMware_VCloud_API_ReferencesType',
            'ServiceOfferingInstanceUpdateParamsType'=>'VMware_VCloud_API_Extension_ServiceOfferingInstanceUpdateParamsType',
            'ServiceOfferingInstanceParam'=>'VMware_VCloud_API_Extension_ServiceOfferingInstanceParamType',
            'AdminVmDiskRelationRecord'=>'VMware_VCloud_API_QueryResultAdminVmDiskRelationRecordType',
            'ShieldManager'=>'VMware_VCloud_API_Extension_ShieldManagerType',
            'ServiceExtensionReference'=>'VMware_VCloud_API_ReferenceType',
            'RightRefs'=>'VMware_VCloud_API_Extension_RightRefsType',
            'DiskReference'=>'VMware_VCloud_API_ReferenceType',
            'NatOneToOneVmRuleType'=>'VMware_VCloud_API_NatOneToOneVmRuleType',
            'cimUnsignedLong'=>'VMware_VCloud_API_OVF_cimUnsignedLong',
            'LicenseMetricsInfoType'=>'VMware_VCloud_API_Extension_LicenseMetricsInfoType',
            'NatVmRuleType'=>'VMware_VCloud_API_NatVmRuleType',
            'VMWProviderVdcReferences'=>'VMware_VCloud_API_Extension_VMWProviderVdcReferencesType',
            'Content'=>'VMware_VCloud_API_OVF_Content_Type',
            'AdminOrgNetworkRecord'=>'VMware_VCloud_API_QueryResultAdminOrgNetworkRecordType',
            'GroupReference'=>'VMware_VCloud_API_ReferenceType',
            'AclAccessType'=>'VMware_VCloud_API_Extension_AclAccessType',
            'AdminOrgVdcStorageProfileRecord'=>'VMware_VCloud_API_QueryResultAdminOrgVdcStorageProfileRecordType',
            'TrustStoreUpdateParamsType'=>'VMware_VCloud_API_TrustStoreUpdateParamsType',
            'SmtpServerSettingsType'=>'VMware_VCloud_API_SmtpServerSettingsType',
            'QueryResultAdminShadowVMRecordType'=>'VMware_VCloud_API_QueryResultAdminShadowVMRecordType',
            'ResourceEntityType'=>'VMware_VCloud_API_ResourceEntityType',
            'VMWNetworkPoolReferencesType'=>'VMware_VCloud_API_Extension_VMWNetworkPoolReferencesType',
            'QueryResultHostRecordType'=>'VMware_VCloud_API_QueryResultHostRecordType',
            'ServiceOfferingInstanceRecord'=>'VMware_VCloud_API_QueryResultServiceOfferingInstanceRecordType',
            'Msg_Type'=>'VMware_VCloud_API_OVF_Msg_Type',
            'EntityReferencesType'=>'VMware_VCloud_API_Extension_EntityReferencesType',
            'cimBase64Binary'=>'VMware_VCloud_API_OVF_cimBase64Binary',
            'EntityType'=>'VMware_VCloud_API_EntityType',
            'LdapGroupAttributesType'=>'VMware_VCloud_API_Extension_LdapGroupAttributesType',
            'BrandingSettingsType'=>'VMware_VCloud_API_Extension_BrandingSettingsType',
            'AdminFileDescriptorReference'=>'VMware_VCloud_API_ReferenceType',
            'ServiceResourcesType'=>'VMware_VCloud_API_Extension_ServiceResourcesType',
            'ServiceOfferingInstanceType'=>'VMware_VCloud_API_Extension_ServiceOfferingInstanceType',
            'StrandedItemReferences'=>'VMware_VCloud_API_ReferencesType',
            'Session'=>'VMware_VCloud_API_SessionType',
            'Address'=>'VMware_VCloud_API_OVF_cimString',
            'ServiceOffering'=>'VMware_VCloud_API_Extension_ServiceOfferingType',
            'VirtualQuantityUnits'=>'VMware_VCloud_API_OVF_cimString',
            'VimObjectRefList'=>'VMware_VCloud_API_Extension_VimObjectRefListType',
            'VmQuestionAnswerChoiceType'=>'VMware_VCloud_API_VmQuestionAnswerChoiceType',
            'EulaSection'=>'VMware_VCloud_API_OVF_EulaSection_Type',
            'cimByte'=>'VMware_VCloud_API_OVF_cimByte',
            'LeaseSettingsSectionType'=>'VMware_VCloud_API_LeaseSettingsSectionType',
            'CIM_ResourceAllocationSettingData'=>'VMware_VCloud_API_CIM_ResourceAllocationSettingData_Type',
            'AdminCatalogItemRecord'=>'VMware_VCloud_API_QueryResultAdminCatalogItemRecordType',
            'UberAdminSettings'=>'VMware_VCloud_API_Extension_UberAdminSettingsType',
            'FileType'=>'VMware_VCloud_API_FileType',
            'ServiceLinkRecord'=>'VMware_VCloud_API_QueryResultServiceLinkRecordType',
            'ProviderVdcStorageProfileType'=>'VMware_VCloud_API_ProviderVdcStorageProfileType',
            'Item'=>'VMware_VCloud_API_OVF_RASD_Type',
            'BlockingTaskType'=>'VMware_VCloud_API_Extension_BlockingTaskType',
            'FileUploadParamsType'=>'VMware_VCloud_API_FileUploadParamsType',
            'IpsecVpnServiceType'=>'VMware_VCloud_API_IpsecVpnServiceType',
            'QueryResultAdminFileDescriptorRecordType'=>'VMware_VCloud_API_QueryResultAdminFileDescriptorRecordType',
            'NetworkConnectionSectionType'=>'VMware_VCloud_API_NetworkConnectionSectionType',
            'DefaultStorageProfileSection'=>'VMware_VCloud_API_DefaultStorageProfileSection_Type',
            'ResourceClassReferences'=>'VMware_VCloud_API_ReferencesType',
            'QueryResultDatastoreProviderVdcRelationRecordType'=>'VMware_VCloud_API_QueryResultDatastoreProviderVdcRelationRecordType',
            'ServiceOfferingInstanceDisassociateParams'=>'VMware_VCloud_API_Extension_ServiceOfferingInstanceDisassociateParamsType',
            'NetworkReference'=>'VMware_VCloud_API_ReferenceType',
            'GatewayFeaturesType'=>'VMware_VCloud_API_GatewayFeaturesType',
            'CloneMediaParamsType'=>'VMware_VCloud_API_CloneMediaParamsType',
            'QueryResultResourceClassActionRecordType'=>'VMware_VCloud_API_QueryResultResourceClassActionRecordType',
            'Vm'=>'VMware_VCloud_API_VmType',
            'ServiceExtensionReferences'=>'VMware_VCloud_API_ReferencesType',
            'BlockingTaskSettingsType'=>'VMware_VCloud_API_Extension_BlockingTaskSettingsType',
            'LicensingReports'=>'VMware_VCloud_API_Extension_LicensingReportListType',
            'VAppReferences'=>'VMware_VCloud_API_ReferencesType',
            'QueryResultVMRecordType'=>'VMware_VCloud_API_QueryResultVMRecordType',
            'VAppNetworkReference'=>'VMware_VCloud_API_ReferenceType',
            'QueryResultDvSwitchRecordType'=>'VMware_VCloud_API_QueryResultDvSwitchRecordType',
            'Limit'=>'VMware_VCloud_API_OVF_cimUnsignedLong',
            'QueryResultLicensingVirtualMachineRecordType'=>'VMware_VCloud_API_QueryResultLicensingVirtualMachineRecordType',
            'ResourceAllocationSection_Type'=>'VMware_VCloud_API_OVF_ResourceAllocationSection_Type',
            'Port'=>'VMware_VCloud_API_int',
            'ProviderVdcStorageProfileRecord'=>'VMware_VCloud_API_QueryResultProviderVdcStorageProfileRecordType',
            'RecoveryFile'=>'VMware_VCloud_API_OVF_cimString',
            'BlockingTaskUpdateProgressParams'=>'VMware_VCloud_API_Extension_BlockingTaskUpdateProgressParamsType',
            'ProviderVdcStorageProfileReference'=>'VMware_VCloud_API_ReferenceType',
            'NetworkServiceType'=>'VMware_VCloud_API_NetworkServiceType',
            'VdcStorageProfile'=>'VMware_VCloud_API_VdcStorageProfileType',
            'VimObjectRef'=>'VMware_VCloud_API_Extension_VimObjectRefType',
            'QueryResultAdminVAppNetworkRecordType'=>'VMware_VCloud_API_QueryResultAdminVAppNetworkRecordType',
            'EntityReferenceType'=>'VMware_VCloud_API_EntityReferenceType',
            'LoadBalancerService'=>'VMware_VCloud_API_LoadBalancerServiceType',
            'AvailableNetworksType'=>'VMware_VCloud_API_AvailableNetworksType',
            'OrgRecord'=>'VMware_VCloud_API_QueryResultOrgRecordType',
            'UploadVAppTemplateParamsType'=>'VMware_VCloud_API_UploadVAppTemplateParamsType',
            'SupportedVersions'=>'VMware_VCloud_API_Version_SupportedVersionsType',
            'HostResource'=>'VMware_VCloud_API_OVF_cimString',
            'OperatingSystemInfoType'=>'VMware_VCloud_API_OperatingSystemInfoType',
            'ExtensionObjectRefType'=>'VMware_VCloud_API_Extension_ExtensionObjectRefType',
            'VmsType'=>'VMware_VCloud_API_VmsType',
            'AdminApiDefinitionReferences'=>'VMware_VCloud_API_ReferencesType',
            'EulaSection_Type'=>'VMware_VCloud_API_OVF_EulaSection_Type',
            'UploadVAppTemplateParams'=>'VMware_VCloud_API_UploadVAppTemplateParamsType',
            'ServiceOfferingInstanceParams'=>'VMware_VCloud_API_Extension_ServiceOfferingInstanceParamsType',
            'QueryResultNetworkPoolRecordType'=>'VMware_VCloud_API_QueryResultNetworkPoolRecordType',
            'OrgGeneralSettingsType'=>'VMware_VCloud_API_OrgGeneralSettingsType',
            'QueryResultRoleRecordType'=>'VMware_VCloud_API_QueryResultRoleRecordType',
            'AuthorizationCheckParams'=>'VMware_VCloud_API_Extension_AuthorizationCheckParamsType',
            'QueryResultServiceExtensionRecordType'=>'VMware_VCloud_API_QueryResultServiceExtensionRecordType',
            'BlockingTaskReferences'=>'VMware_VCloud_API_ReferencesType',
            'CaptureVAppParams'=>'VMware_VCloud_API_CaptureVAppParamsType',
            'RecomposeVAppParams'=>'VMware_VCloud_API_RecomposeVAppParamsType',
            'cimUnsignedByte'=>'VMware_VCloud_API_OVF_cimUnsignedByte',
            'OrgVdcNetworkType'=>'VMware_VCloud_API_OrgVdcNetworkType',
            'OvfToVdcNetworkMapType'=>'VMware_VCloud_API_OvfToVdcNetworkMapType',
            'AdminServiceType'=>'VMware_VCloud_API_Extension_AdminServiceType',
            'IpsecVpnRemotePeer'=>'VMware_VCloud_API_IpsecVpnRemotePeerType',
            'HostObjectRefsType'=>'VMware_VCloud_API_Extension_HostObjectRefsType',
            'QueryResultType'=>'VMware_VCloud_API_QueryResultType',
            'OrgLdapSettings'=>'VMware_VCloud_API_OrgLdapSettingsType',
            'ServiceResource'=>'VMware_VCloud_API_Extension_ServiceResourceType',
            'QueryResultAdminVAppRecordType'=>'VMware_VCloud_API_QueryResultAdminVAppRecordType',
            'AdminMediaRecord'=>'VMware_VCloud_API_QueryResultAdminMediaRecordType',
            'QueryResultVAppOrgVdcNetworkRelationRecordType'=>'VMware_VCloud_API_QueryResultVAppOrgVdcNetworkRelationRecordType',
            'CatalogType'=>'VMware_VCloud_API_CatalogType',
            'VMWProviderVdcType'=>'VMware_VCloud_API_Extension_VMWProviderVdcType',
            'VMWNetworkPoolReferences'=>'VMware_VCloud_API_Extension_VMWNetworkPoolReferencesType',
            'StrandedItemRecord'=>'VMware_VCloud_API_QueryResultStrandedItemRecordType',
            'ResourceClassActionRecord'=>'VMware_VCloud_API_QueryResultResourceClassActionRecordType',
            'InstantiateOvfParamsType'=>'VMware_VCloud_API_InstantiateOvfParamsType',
            'StrandedUserRecord'=>'VMware_VCloud_API_QueryResultStrandedUserRecordType',
            'DestinationPortRange'=>'VMware_VCloud_API_string',
            'ComponentManagerSettingsType'=>'VMware_VCloud_API_Extension_ComponentManagerSettingsType',
            'VirtualSystem_Type'=>'VMware_VCloud_API_OVF_VirtualSystem_Type',
            'MetadataBooleanValue'=>'VMware_VCloud_API_MetadataBooleanValue',
            'InstantiateVmHardwareCustomizationParamsType'=>'VMware_VCloud_API_InstantiateVmHardwareCustomizationParamsType',
            'VAppChildrenType'=>'VMware_VCloud_API_VAppChildrenType',
            'ComputeCapacityType'=>'VMware_VCloud_API_ComputeCapacityType',
            'Environment_Type'=>'VMware_VCloud_API_OVFENV_Environment_Type',
            'NetworkConnectionType'=>'VMware_VCloud_API_NetworkConnectionType',
            'VdcStorageProfiles'=>'VMware_VCloud_API_VdcStorageProfilesType',
            'StrandedItemType'=>'VMware_VCloud_API_Extension_StrandedItemType',
            'AdminApiDefinitionRecord'=>'VMware_VCloud_API_QueryResultAdminApiDefinitionRecordType',
            'AdminGroupRecord'=>'VMware_VCloud_API_QueryResultAdminGroupRecordType',
            'Connection'=>'VMware_VCloud_API_OVF_cimString',
            'VdcReferencesType'=>'VMware_VCloud_API_VdcReferencesType',
            'UpdateProviderVdcStorageProfiles'=>'VMware_VCloud_API_Extension_UpdateProviderVdcStorageProfilesParamsType',
            'ResourceClassReference'=>'VMware_VCloud_API_ReferenceType',
            'QueryResultResourcePoolVMRecordType'=>'VMware_VCloud_API_QueryResultResourcePoolVMRecordType',
            'CatalogItemReferences'=>'VMware_VCloud_API_ReferencesType',
            'MediaInsertOrEjectParams'=>'VMware_VCloud_API_MediaInsertOrEjectParamsType',
            'CatalogSettings'=>'VMware_VCloud_API_Extension_CatalogSettingsType',
            'CellRecord'=>'VMware_VCloud_API_QueryResultCellRecordType',
            'VdcStorageProfileType'=>'VMware_VCloud_API_VdcStorageProfileType',
            'AdminServiceReferences'=>'VMware_VCloud_API_ReferencesType',
            'ServiceLinkReference'=>'VMware_VCloud_API_ReferenceType',
            'ShieldManagerType'=>'VMware_VCloud_API_Extension_ShieldManagerType',
            'ExternalCatalogSubscriptionParamsType'=>'VMware_VCloud_API_ExternalCatalogSubscriptionParamsType',
            'ServiceOfferingInstanceUpdateParams'=>'VMware_VCloud_API_Extension_ServiceOfferingInstanceUpdateParamsType',
            'CertificateUploadSocket'=>'VMware_VCloud_API_CertificateUploadSocketType',
            'EdgeGatewayReference'=>'VMware_VCloud_API_ReferenceType',
            'AccessSettingsType'=>'VMware_VCloud_API_AccessSettingsType',
            'Section'=>'VMware_VCloud_API_OVFENV_Section_Type',
            'HostType'=>'VMware_VCloud_API_Extension_HostType',
            'QueryResultOrgRecordType'=>'VMware_VCloud_API_QueryResultOrgRecordType',
            'VimServer'=>'VMware_VCloud_API_Extension_VimServerType',
            'OrganizationReferenceType'=>'VMware_VCloud_API_OrganizationReferenceType',
            'cimAnySimpleType'=>'VMware_VCloud_API_OVF_cimAnySimpleType',
            'TasksInProgressType'=>'VMware_VCloud_API_TasksInProgressType',
            'QueryResultLicensingReportRecordType'=>'VMware_VCloud_API_QueryResultLicensingReportRecordType',
            'VMWProviderVdcRecord'=>'VMware_VCloud_API_QueryResultVMWProviderVdcRecordType',
            'IpsecVpnTunnelType'=>'VMware_VCloud_API_IpsecVpnTunnelType',
            'QueryResultResourcePoolRecordType'=>'VMware_VCloud_API_QueryResultResourcePoolRecordType',
            'ProductSection'=>'VMware_VCloud_API_OVF_ProductSection_Type',
            'EntityRightsType'=>'VMware_VCloud_API_Extension_EntityRightsType',
            'MediaTypeMappingType'=>'VMware_VCloud_API_Version_MediaTypeMappingType',
            'ParamsType'=>'VMware_VCloud_API_ParamsType',
            'VAppReference'=>'VMware_VCloud_API_ReferenceType',
            'AutomaticDeallocation'=>'VMware_VCloud_API_OVF_cimBoolean',
            'QueryResultAdminVMRecordType'=>'VMware_VCloud_API_QueryResultAdminVMRecordType',
            'QueryResultRightRecordType'=>'VMware_VCloud_API_QueryResultRightRecordType',
            'ServiceResourceResourceReference'=>'VMware_VCloud_API_ReferenceType',
            'PropertyConfigurationValue_Type'=>'VMware_VCloud_API_OVF_PropertyConfigurationValue_Type',
            'TaskOperationListType'=>'VMware_VCloud_API_TaskOperationListType',
            'GroupReferences'=>'VMware_VCloud_API_ReferencesType',
            'AutomaticRecoveryAction'=>'VMware_VCloud_API_OVF_AutomaticRecoveryAction',
            'RightRecord'=>'VMware_VCloud_API_QueryResultRightRecordType',
            'EventRecord'=>'VMware_VCloud_API_QueryResultEventRecordType',
            'VAppRecord'=>'VMware_VCloud_API_QueryResultVAppRecordType',
            'AdminCatalogType'=>'VMware_VCloud_API_AdminCatalogType',
            'MetadataDomainTagType'=>'VMware_VCloud_API_MetadataDomainTagType',
            'QueryResultAdminVmDiskRelationRecordType'=>'VMware_VCloud_API_QueryResultAdminVmDiskRelationRecordType',
            'StrandedItemReference'=>'VMware_VCloud_API_ReferenceType',
            'MediaType'=>'VMware_VCloud_API_MediaType',
            'LicensingReportSampleRecord'=>'VMware_VCloud_API_QueryResultLicensingReportSampleRecordType',
            'VdcStorageProfilesType'=>'VMware_VCloud_API_VdcStorageProfilesType',
            'AdminFileDescriptorRecord'=>'VMware_VCloud_API_QueryResultAdminFileDescriptorRecordType',
            'OrgLdapGroupAttributesType'=>'VMware_VCloud_API_OrgLdapGroupAttributesType',
            'OrgReferences'=>'VMware_VCloud_API_ReferencesType',
            'UpdateVdcStorageProfiles'=>'VMware_VCloud_API_UpdateVdcStorageProfilesType',
            'ExternalNetworkType'=>'VMware_VCloud_API_ExternalNetworkType',
            'InstantiateVAppTemplateParams'=>'VMware_VCloud_API_InstantiateVAppTemplateParamsType',
            'LicenseType'=>'VMware_VCloud_API_Extension_LicenseType',
            'Datastore'=>'VMware_VCloud_API_Extension_DatastoreType',
            'QueryResultAdminTaskRecordType'=>'VMware_VCloud_API_QueryResultAdminTaskRecordType',
            'FilesListType'=>'VMware_VCloud_API_FilesListType',
            'ProviderVdcReferencesType'=>'VMware_VCloud_API_ProviderVdcReferencesType',
            'CustomizationSection'=>'VMware_VCloud_API_CustomizationSectionType',
            'Weight'=>'VMware_VCloud_API_OVF_cimUnsignedInt',
            'Generation'=>'VMware_VCloud_API_OVF_cimUnsignedLong',
            'BlockingTaskOperationParamsType'=>'VMware_VCloud_API_Extension_BlockingTaskOperationParamsType',
            'ExtraConfig'=>'VMware_VCloud_API_ExtraConfig_Type',
            'ApiDefinitions'=>'VMware_VCloud_API_Extension_AdminApiDefinitionsType',
            'AdminVAppNetworkRecord'=>'VMware_VCloud_API_QueryResultAdminVAppNetworkRecordType',
            'UsersListType'=>'VMware_VCloud_API_UsersListType',
            'ExternalLocalizationRecord'=>'VMware_VCloud_API_QueryResultExternalLocalizationRecordType',
            'VAppCreationParamsType'=>'VMware_VCloud_API_VAppCreationParamsType',
            'GuestCustomizationSectionType'=>'VMware_VCloud_API_GuestCustomizationSectionType',
            'ServiceOfferingInstanceCreateParamsType'=>'VMware_VCloud_API_Extension_ServiceOfferingInstanceCreateParamsType',
            'NetworkServiceInsertionType'=>'VMware_VCloud_API_NetworkServiceInsertionType',
            'ResourceEntity'=>'VMware_VCloud_API_ResourceEntityType',
            'VMWStorageProfile'=>'VMware_VCloud_API_Extension_VMWStorageProfileType',
            'IpsecVpnLocalPeer'=>'VMware_VCloud_API_IpsecVpnLocalPeerType',
            'VmObjectRefsList'=>'VMware_VCloud_API_Extension_VmObjectRefsListType',
            'AbstractVAppType'=>'VMware_VCloud_API_AbstractVAppType',
            'AdminFileDescriptorsType'=>'VMware_VCloud_API_Extension_AdminFileDescriptorsType',
            'AllocatedExternalAddressRecord'=>'VMware_VCloud_API_QueryResultAllocatedExternalAddressRecordType',
            'VcTrustStoreUploadSocket'=>'VMware_VCloud_API_Extension_VcTrustStoreUploadSocketType',
            'QueryResultGroupRecordType'=>'VMware_VCloud_API_QueryResultGroupRecordType',
            'ApiDefinitionReference'=>'VMware_VCloud_API_ReferenceType',
            'UpdateResourcePoolSetParams'=>'VMware_VCloud_API_Extension_UpdateResourcePoolSetParamsType',
            'QueryList'=>'VMware_VCloud_API_QueryListType',
            'Environment'=>'VMware_VCloud_API_OVFENV_Environment_Type',
            'IpScopeType'=>'VMware_VCloud_API_IpScopeType',
            'CloneVAppTemplateParamsType'=>'VMware_VCloud_API_CloneVAppTemplateParamsType',
            'Config'=>'VMware_VCloud_API_Config_Type',
            'VdcType'=>'VMware_VCloud_API_VdcType',
            'ComposeVAppParams'=>'VMware_VCloud_API_ComposeVAppParamsType',
            'LicensingReportListType'=>'VMware_VCloud_API_Extension_LicensingReportListType',
            'ElementName'=>'VMware_VCloud_API_OVF_cimString',
            'OrgNetwork'=>'VMware_VCloud_API_OrgNetworkType',
            'QueryResultOrgVdcRecordType'=>'VMware_VCloud_API_QueryResultOrgVdcRecordType',
            'AutomaticStartupAction'=>'VMware_VCloud_API_OVF_AutomaticStartupAction',
            'RouterInfoType'=>'VMware_VCloud_API_RouterInfoType',
            'QueryResultVAppOrgNetworkRelationRecordType'=>'VMware_VCloud_API_QueryResultVAppOrgNetworkRelationRecordType',
            'EnableLogging'=>'VMware_VCloud_API_boolean',
            'AdminVAppRecord'=>'VMware_VCloud_API_QueryResultAdminVAppRecordType',
            'LdapUserAttributesType'=>'VMware_VCloud_API_Extension_LdapUserAttributesType',
            'qualifierBoolean'=>'VMware_VCloud_API_OVF_qualifierBoolean',
            'DhcpServiceType'=>'VMware_VCloud_API_DhcpServiceType',
            'ExtensionServicesType'=>'VMware_VCloud_API_Extension_ExtensionServicesType',
            'LicensingVirtualMachineRecord'=>'VMware_VCloud_API_QueryResultLicensingVirtualMachineRecordType',
            'User'=>'VMware_VCloud_API_UserType',
            'AdminOrgVdcStorageProfileReferences'=>'VMware_VCloud_API_ReferencesType',
            'QueryResultAdminGroupRecordType'=>'VMware_VCloud_API_QueryResultAdminGroupRecordType',
            'CloneVAppParamsType'=>'VMware_VCloud_API_CloneVAppParamsType',
            'VMRecord'=>'VMware_VCloud_API_QueryResultVMRecordType',
            'VAppTemplateType'=>'VMware_VCloud_API_VAppTemplateType',
            'VirtualHardwareSection_Type'=>'VMware_VCloud_API_OVF_VirtualHardwareSection_Type',
            'AdminServiceOfferingInstanceReference'=>'VMware_VCloud_API_ReferenceType',
            'qualifierUInt32'=>'VMware_VCloud_API_OVF_qualifierUInt32',
            'QueryResultRecordType'=>'VMware_VCloud_API_QueryResultRecordType',
            'Vdc'=>'VMware_VCloud_API_VdcType',
            'SupportedVersionsType'=>'VMware_VCloud_API_Version_SupportedVersionsType',
            'AmqpSettings'=>'VMware_VCloud_API_Extension_AmqpSettingsType',
            'Error'=>'VMware_VCloud_API_ErrorType',
            'AdminVdcStorageProfileType'=>'VMware_VCloud_API_AdminVdcStorageProfileType',
            'QueryResultVdcServiceOfferingRecordType'=>'VMware_VCloud_API_QueryResultVdcServiceOfferingRecordType',
            'CIM_VirtualSystemSettingData'=>'VMware_VCloud_API_CIM_VirtualSystemSettingData_Type',
            'GatewayIpsecVpnService'=>'VMware_VCloud_API_GatewayIpsecVpnServiceType',
            'QueryListType'=>'VMware_VCloud_API_QueryListType',
            'BundleUploadSocketType'=>'VMware_VCloud_API_Extension_BundleUploadSocketType',
            'VcTrustStoreUpdateParams'=>'VMware_VCloud_API_Extension_VcTrustStoreUpdateParamsType',
            'Entity_Type'=>'VMware_VCloud_API_OVFENV_Entity_Type',
            'OrgList'=>'VMware_VCloud_API_OrgListType',
            'BrandingSettings'=>'VMware_VCloud_API_Extension_BrandingSettingsType',
            'ProviderVdc'=>'VMware_VCloud_API_ProviderVdcType',
            'VAppNetworkType'=>'VMware_VCloud_API_VAppNetworkType',
            'QueryResultEventRecordType'=>'VMware_VCloud_API_QueryResultEventRecordType',
            'VMWExternalNetworkType'=>'VMware_VCloud_API_Extension_VMWExternalNetworkType',
            'DeployVAppParamsType'=>'VMware_VCloud_API_DeployVAppParamsType',
            'OrgReference'=>'VMware_VCloud_API_ReferenceType',
            'VMWExternalNetworkReferencesType'=>'VMware_VCloud_API_Extension_VMWExternalNetworkReferencesType',
            'ServiceOfferingInstanceAssociateParamsType'=>'VMware_VCloud_API_Extension_ServiceOfferingInstanceAssociateParamsType',
            'ServiceOfferingInstanceParamType'=>'VMware_VCloud_API_Extension_ServiceOfferingInstanceParamType',
            'SupportedOperatingSystemsInfo'=>'VMware_VCloud_API_SupportedOperatingSystemsInfoType',
            'BlockingTaskSettings'=>'VMware_VCloud_API_Extension_BlockingTaskSettingsType',
            'InstallSection_Type'=>'VMware_VCloud_API_OVF_InstallSection_Type',
            'VMWHostReferencesType'=>'VMware_VCloud_API_Extension_VMWHostReferencesType',
            'InstanceID'=>'VMware_VCloud_API_OVF_cimString',
            'ImportVmAsVAppParamsType'=>'VMware_VCloud_API_Extension_ImportVmAsVAppParamsType',
            'EmailSettings'=>'VMware_VCloud_API_Extension_EmailSettingsType',
            'ExtraConfig_Type'=>'VMware_VCloud_API_ExtraConfig_Type',
            'ProviderVdcCapacityType'=>'VMware_VCloud_API_ProviderVdcCapacityType',
            'DefaultStorageProfileSection_Type'=>'VMware_VCloud_API_DefaultStorageProfileSection_Type',
            'QueryResultAdminServiceRecordType'=>'VMware_VCloud_API_QueryResultAdminServiceRecordType',
            'NatPortForwardingRuleType'=>'VMware_VCloud_API_NatPortForwardingRuleType',
            'BlockingTaskReference'=>'VMware_VCloud_API_ReferenceType',
            'ImportVmIntoExistingVAppParams'=>'VMware_VCloud_API_Extension_ImportVmIntoExistingVAppParamsType',
            'VAppOrgVdcNetworkRelationReferences'=>'VMware_VCloud_API_ReferencesType',
            'VmCapabilities'=>'VMware_VCloud_API_VmCapabilitiesType',
            'Description'=>'VMware_VCloud_API_OVF_cimString',
            'VmCapabilitiesType'=>'VMware_VCloud_API_VmCapabilitiesType',
            'VMWExternalNetworkReferences'=>'VMware_VCloud_API_Extension_VMWExternalNetworkReferencesType',
            'ApiDefinitionReferences'=>'VMware_VCloud_API_ReferencesType',
            'SystemConfigurationSettingValueType'=>'VMware_VCloud_API_Extension_SystemConfigurationSettingValueType',
            'Envelope'=>'VMware_VCloud_API_OVF_EnvelopeType',
            'ImportVmIntoExistingVAppParamsType'=>'VMware_VCloud_API_Extension_ImportVmIntoExistingVAppParamsType',
            'OrganizationReferencesType'=>'VMware_VCloud_API_OrganizationReferencesType',
            'BlockingTaskOperations'=>'VMware_VCloud_API_TaskOperationListType',
            'DiskReferences'=>'VMware_VCloud_API_ReferencesType',
            'LoadBalancerPoolType'=>'VMware_VCloud_API_LoadBalancerPoolType',
            'ProviderVdcStorageProfile'=>'VMware_VCloud_API_ProviderVdcStorageProfileType',
            'SupportedOperatingSystemsInfoType'=>'VMware_VCloud_API_SupportedOperatingSystemsInfoType',
            'AdminShadowVMRecord'=>'VMware_VCloud_API_QueryResultAdminShadowVMRecordType',
            'CatalogSettingsType'=>'VMware_VCloud_API_Extension_CatalogSettingsType',
            'NotificationsSettings'=>'VMware_VCloud_API_Extension_NotificationsSettingsType',
            'DefaultValue'=>'VMware_VCloud_API_anySimpleType',
            'AdminVdcReference'=>'VMware_VCloud_API_ReferenceType',
            'AclRulesType'=>'VMware_VCloud_API_Extension_AclRulesType',
            'GatewayIpsecVpnTunnelType'=>'VMware_VCloud_API_GatewayIpsecVpnTunnelType',
            'MediaRecord'=>'VMware_VCloud_API_QueryResultMediaRecordType',
            'SubAllocationType'=>'VMware_VCloud_API_SubAllocationType',
            'VSSD_Type'=>'VMware_VCloud_API_OVF_VSSD_Type',
            'OrgNetworkRecord'=>'VMware_VCloud_API_QueryResultOrgNetworkRecordType',
            'VcTrustStoreUploadSocketType'=>'VMware_VCloud_API_Extension_VcTrustStoreUploadSocketType',
            'QueryResultLicensingManagedServerRecordType'=>'VMware_VCloud_API_QueryResultLicensingManagedServerRecordType',
            'ProviderVdcType'=>'VMware_VCloud_API_ProviderVdcType',
            'VCloudExtensibleType'=>'VMware_VCloud_API_VCloudExtensibleType',
            'VmObjectRefsListType'=>'VMware_VCloud_API_Extension_VmObjectRefsListType',
            'QueryResultCellRecordType'=>'VMware_VCloud_API_QueryResultCellRecordType',
            'MksTicket'=>'VMware_VCloud_API_MksTicketType',
            'PublishCatalogParams'=>'VMware_VCloud_API_PublishCatalogParamsType',
            'HostObjectRefType'=>'VMware_VCloud_API_Extension_HostObjectRefType',
            'Host'=>'VMware_VCloud_API_Extension_HostType',
            'OrgGuestPersonalizationSettingsType'=>'VMware_VCloud_API_OrgGuestPersonalizationSettingsType',
            'VersionInfoType'=>'VMware_VCloud_API_Version_VersionInfoType',
            'VirtualSystemIdentifier'=>'VMware_VCloud_API_OVF_cimString',
            'VdcServiceOfferingRecord'=>'VMware_VCloud_API_QueryResultVdcServiceOfferingRecordType',
            'RightRefsType'=>'VMware_VCloud_API_Extension_RightRefsType',
            'ConsumerVisibility'=>'VMware_VCloud_API_OVF_ConsumerVisibility',
            'ResourceClassActionsType'=>'VMware_VCloud_API_Extension_ResourceClassActionsType',
            'NetworkAssignment'=>'VMware_VCloud_API_NetworkAssignmentType',
            'VMWExtension'=>'VMware_VCloud_API_Extension_VMWExtensionType',
            'BootOrderSection_Type'=>'VMware_VCloud_API_BootOrderSection_Type',
            'ResourceAllocationSection'=>'VMware_VCloud_API_OVF_ResourceAllocationSection_Type',
            'VMWProviderVdc'=>'VMware_VCloud_API_Extension_VMWProviderVdcType',
            'QueryResultStrandedUserRecordType'=>'VMware_VCloud_API_QueryResultStrandedUserRecordType',
            'PlatformSection_Type'=>'VMware_VCloud_API_OVFENV_PlatformSection_Type',
            'OrganizationResourcePoolSet'=>'VMware_VCloud_API_Extension_OrganizationResourcePoolSetType',
            'cimDateTime'=>'VMware_VCloud_API_OVF_cimDateTime',
        );
        if (strpos($tagname, ':') > 0) {
            $names = explode(':', $tagname);
            $tagname = $names[1];
        }
        if (array_key_exists($tagname, $nameClassMap)) {
            $type = $nameClassMap[$tagname];
        }
        return $type;
    }

    public static function getNsid($namespace) {
        $nsid = '';
        $namespaceNsidMap = array(
                'http://www.vmware.com/vcloud/v1.5'=>'vcloud',
                'http://schemas.dmtf.org/ovf/environment/1'=>'ovfenv',
                'http://www.vmware.com/vcloud/versions'=>'version',
                'http://www.vmware.com/schema/ovf'=>'vmw',
                'http://schemas.dmtf.org/wbem/wscim/1/cim-schema/2/CIM_ResourceAllocationSettingData'=>'rasd',
                'http://schemas.dmtf.org/ovf/envelope/1'=>'ovf',
                'http://schemas.dmtf.org/wbem/wscim/1/cim-schema/2/CIM_VirtualSystemSettingData'=>'vssd',
                'http://www.vmware.com/vcloud/extension/v1.5'=>'vmext',
                'http://schemas.dmtf.org/wbem/wscim/1/common'=>'cim',
        );
        if (array_key_exists($namespace, $namespaceNsidMap)) {
            $nsid = $namespaceNsidMap[$namespace];
        }
        return $nsid;
    }
}