<?php
class VMware_VCloud_API_ComplianceResultType extends VMware_VCloud_API_VCloudExtensibleType {
    protected $ComplianceStatus = null;
    protected $ComplianceStatusMessage = null;
    protected $ComplianceCheckTime = null;
    protected $namespace = array();
    protected $namespacedef = null;
    protected $tagName = null;
    public static $defaultNS = 'http://www.vmware.com/vcloud/v1.5';

   /**
    * @param array $VCloudExtension - [optional] an array of VMware_VCloud_API_VCloudExtensionType objects
    * @param string $ComplianceStatus - [required] 
    * @param string $ComplianceStatusMessage - [optional] 
    * @param string $ComplianceCheckTime - [optional] 
    */
    public function __construct($VCloudExtension=null, $ComplianceStatus=null, $ComplianceStatusMessage=null, $ComplianceCheckTime=null) {
        parent::__construct($VCloudExtension);
        $this->ComplianceStatus = $ComplianceStatus;
        $this->ComplianceStatusMessage = $ComplianceStatusMessage;
        $this->ComplianceCheckTime = $ComplianceCheckTime;
        $this->tagName = 'ComplianceResult';
        $this->namespacedef = ' xmlns:vcloud="http://www.vmware.com/vcloud/v1.5" xmlns:ns12="http://www.vmware.com/vcloud/v1.5" xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1" xmlns:ovfenv="http://schemas.dmtf.org/ovf/environment/1" xmlns:vmext="http://www.vmware.com/vcloud/extension/v1.5" xmlns:cim="http://schemas.dmtf.org/wbem/wscim/1/common" xmlns:rasd="http://schemas.dmtf.org/wbem/wscim/1/cim-schema/2/CIM_ResourceAllocationSettingData" xmlns:vssd="http://schemas.dmtf.org/wbem/wscim/1/cim-schema/2/CIM_VirtualSystemSettingData" xmlns:vmw="http://www.vmware.com/schema/ovf" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"';
    }
    public function getComplianceStatus() {
        return $this->ComplianceStatus;
    }
    public function setComplianceStatus($ComplianceStatus) { 
        $this->ComplianceStatus = $ComplianceStatus;
    }
    public function getComplianceStatusMessage() {
        return $this->ComplianceStatusMessage;
    }
    public function setComplianceStatusMessage($ComplianceStatusMessage) { 
        $this->ComplianceStatusMessage = $ComplianceStatusMessage;
    }
    public function getComplianceCheckTime() {
        return $this->ComplianceCheckTime;
    }
    public function setComplianceCheckTime($ComplianceCheckTime) { 
        $this->ComplianceCheckTime = $ComplianceCheckTime;
    }
    public function get_tagName() { return $this->tagName; }
    public function set_tagName($tagName) { $this->tagName = $tagName; }
    public function export($name=null, $out='', $level=0, $namespacedef=null, $namespace=null, $rootNS=null) {
        if (!isset($name)) {
            $name = $this->tagName;
        }
        $out = VMware_VCloud_API_Helper::showIndent($out, $level);
        if (is_null($namespace)) {
            $namespace = self::$defaultNS;
        }
        if (is_null($rootNS)) {
            $rootNS = self::$defaultNS;
        }
        if (NULL === $namespacedef) {
            $namespacedef = $this->namespacedef;
            if (0 >= strpos($namespacedef, 'xmlns=')) {
                $namespacedef = ' xmlns="' . self::$defaultNS . '"' . $namespacedef;
            }
        }
        $ns = VMware_VCloud_API_Helper::getNamespaceTag($this->namespace, $name, self::$defaultNS, $namespace, $rootNS);
        $out = VMware_VCloud_API_Helper::addString($out, '<' . $ns . $name . $namespacedef);
        $out = $this->exportAttributes($out, $level, $name, $namespacedef, $namespace, $rootNS);
        if ($this->hasContent()) {
            $out = VMware_VCloud_API_Helper::addString($out, ">\n");
            $out = $this->exportChildren($out, $level + 1, $name, $namespace, $rootNS);
            $out = VMware_VCloud_API_Helper::showIndent($out, $level);
            $out = VMware_VCloud_API_Helper::addString($out, "</" . $ns . $name . ">\n");
        } else {
            $out = VMware_VCloud_API_Helper::addString($out, "/>\n");
        }
        return $out;
    }
    protected function exportAttributes($out, $level, $name, $namespace, $rootNS) {
        $namespace = self::$defaultNS;
        $out = parent::exportAttributes($out, $level, $name, $namespace, $rootNS);
        return $out;
    }
    protected function exportChildren($out, $level, $name, $namespace, $rootNS) {
        $namespace = self::$defaultNS;
        $out = parent::exportChildren($out, $level, $name, $namespace, $rootNS);
        if (!is_null($this->ComplianceStatus)) {
            $out = VMware_VCloud_API_Helper::showIndent($out, $level);
            $ns = VMware_VCloud_API_Helper::getNamespaceTag($this->namespace, 'ComplianceStatus', self::$defaultNS, $namespace, $rootNS);
            $out = VMware_VCloud_API_Helper::addString($out, "<" . $ns . "ComplianceStatus>" . VMware_VCloud_API_Helper::quote_xml(VMware_VCloud_API_Helper::format_string(mb_convert_encoding($this->ComplianceStatus, VMware_VCloud_API_Helper::$ExternalEncoding, "auto"), $input_name='ComplianceStatus')) . "</" . $ns . "ComplianceStatus>\n");
        }
        if (!is_null($this->ComplianceStatusMessage)) {
            $out = VMware_VCloud_API_Helper::showIndent($out, $level);
            $ns = VMware_VCloud_API_Helper::getNamespaceTag($this->namespace, 'ComplianceStatusMessage', self::$defaultNS, $namespace, $rootNS);
            $out = VMware_VCloud_API_Helper::addString($out, "<" . $ns . "ComplianceStatusMessage>" . VMware_VCloud_API_Helper::quote_xml(VMware_VCloud_API_Helper::format_string(mb_convert_encoding($this->ComplianceStatusMessage, VMware_VCloud_API_Helper::$ExternalEncoding, "auto"), $input_name='ComplianceStatusMessage')) . "</" . $ns . "ComplianceStatusMessage>\n");
        }
        if (!is_null($this->ComplianceCheckTime)) {
            $out = VMware_VCloud_API_Helper::showIndent($out, $level);
            $ns = VMware_VCloud_API_Helper::getNamespaceTag($this->namespace, 'ComplianceCheckTime', self::$defaultNS, $namespace, $rootNS);
            $out = VMware_VCloud_API_Helper::addString($out, "<" . $ns . "ComplianceCheckTime>" . VMware_VCloud_API_Helper::quote_xml(VMware_VCloud_API_Helper::format_string(mb_convert_encoding($this->ComplianceCheckTime, VMware_VCloud_API_Helper::$ExternalEncoding, "auto"), $input_name='ComplianceCheckTime')) . "</" . $ns . "ComplianceCheckTime>\n");
        }
        return $out;
    }
    protected function hasContent() {
        if (
            !is_null($this->ComplianceStatus) ||
            !is_null($this->ComplianceStatusMessage) ||
            !is_null($this->ComplianceCheckTime) ||
            parent::hasContent()
            ) {
            return true;
        } else {
            return false;
        }
    }
    public function build($node, $namespaces='') {
        $tagName = $node->tagName;
        $this->tagName = $tagName;
        if (strpos($tagName, ':') > 0) {
            list($namespace, $tagName) = explode(':', $tagName);
            $this->tagName = $tagName;
            $this->namespace[$tagName] = $namespace;
        }
        $this->buildAttributes($node, $namespaces);
        $children = $node->childNodes;
        foreach ($children as $child) {
            if ($child->nodeType == XML_ELEMENT_NODE || $child->nodeType == XML_TEXT_NODE) {
                $namespace = '';
                $nodeName = $child->nodeName;
                if (strpos($nodeName, ':') > 0) {
                    list($namespace, $nodeName) = explode(':', $nodeName);
                }
                $this->buildChildren($child, $nodeName, $namespace);
            }
        }
    }
    protected function buildAttributes($node, $namespaces='') {
        $attrs = $node->attributes;
        if (!empty($namespaces)) {
            $this->namespacedef = VMware_VCloud_API_Helper::constructNS($attrs, $namespaces, $this->namespacedef) . $this->namespacedef;
        }
        $nsUri = self::$defaultNS;
        parent::buildAttributes($node, $namespaces);
    }
    protected function buildChildren($child, $nodeName, $namespace='') {
        if ($child->nodeType == XML_ELEMENT_NODE && $nodeName == 'ComplianceStatus') {
            $sval = $child->nodeValue;
            $this->ComplianceStatus = $sval;
            if (!empty($namespace)) {
                $this->namespace['ComplianceStatus'] = $namespace;
            }
        }
        elseif ($child->nodeType == XML_ELEMENT_NODE && $nodeName == 'ComplianceStatusMessage') {
            $sval = $child->nodeValue;
            $this->ComplianceStatusMessage = $sval;
            if (!empty($namespace)) {
                $this->namespace['ComplianceStatusMessage'] = $namespace;
            }
        }
        elseif ($child->nodeType == XML_ELEMENT_NODE && $nodeName == 'ComplianceCheckTime') {
            $sval = $child->nodeValue;
            $this->ComplianceCheckTime = $sval;
            if (!empty($namespace)) {
                $this->namespace['ComplianceCheckTime'] = $namespace;
            }
        }
        parent::buildChildren($child, $nodeName, $namespace);
    }
}