<?php
class VMware_VCloud_API_InstantiateVmHardwareCustomizationParamsType extends VMware_VCloud_API_VCloudExtensibleType {
    protected $NumberOfCpus = null;
    protected $CoresPerSocket = null;
    protected $MemorySize = null;
    protected $Disk = array();
    protected $namespace = array();
    protected $namespacedef = null;
    protected $tagName = null;
    public static $defaultNS = 'http://www.vmware.com/vcloud/v1.5';

   /**
    * @param array $VCloudExtension - [optional] an array of VMware_VCloud_API_VCloudExtensionType objects
    * @param int $NumberOfCpus - [optional] 
    * @param int $CoresPerSocket - [optional] 
    * @param int $MemorySize - [optional] 
    * @param array $Disk - [optional] an array of VMware_VCloud_API_DiskType objects
    */
    public function __construct($VCloudExtension=null, $NumberOfCpus=null, $CoresPerSocket=null, $MemorySize=null, $Disk=null) {
        parent::__construct($VCloudExtension);
        $this->NumberOfCpus = $NumberOfCpus;
        $this->CoresPerSocket = $CoresPerSocket;
        $this->MemorySize = $MemorySize;
        if (!is_null($Disk)) {
            $this->Disk = $Disk;
        }
        $this->tagName = 'HardwareCustomization';
        $this->namespacedef = ' xmlns:vcloud="http://www.vmware.com/vcloud/v1.5" xmlns:ns12="http://www.vmware.com/vcloud/v1.5" xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1" xmlns:ovfenv="http://schemas.dmtf.org/ovf/environment/1" xmlns:vmext="http://www.vmware.com/vcloud/extension/v1.5" xmlns:cim="http://schemas.dmtf.org/wbem/wscim/1/common" xmlns:rasd="http://schemas.dmtf.org/wbem/wscim/1/cim-schema/2/CIM_ResourceAllocationSettingData" xmlns:vssd="http://schemas.dmtf.org/wbem/wscim/1/cim-schema/2/CIM_VirtualSystemSettingData" xmlns:vmw="http://www.vmware.com/schema/ovf" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"';
    }
    public function getNumberOfCpus() {
        return $this->NumberOfCpus;
    }
    public function setNumberOfCpus($NumberOfCpus) { 
        $this->NumberOfCpus = $NumberOfCpus;
    }
    public function getCoresPerSocket() {
        return $this->CoresPerSocket;
    }
    public function setCoresPerSocket($CoresPerSocket) { 
        $this->CoresPerSocket = $CoresPerSocket;
    }
    public function getMemorySize() {
        return $this->MemorySize;
    }
    public function setMemorySize($MemorySize) { 
        $this->MemorySize = $MemorySize;
    }
    public function getDisk() {
        return $this->Disk;
    }
    public function setDisk($Disk) { 
        $this->Disk = $Disk;
    }
    public function addDisk($value) { array_push($this->Disk, $value); }
    public function get_tagName() { return $this->tagName; }
    public function set_tagName($tagName) { $this->tagName = $tagName; }
    public function export($name=null, $out='', $level=0, $namespacedef=null, $namespace=null, $rootNS=null) {
        if (!isset($name)) {
            $name = $this->tagName;
        }
        $out = VMware_VCloud_API_Helper::showIndent($out, $level);
        if (is_null($namespace)) {
            $namespace = self::$defaultNS;
        }
        if (is_null($rootNS)) {
            $rootNS = self::$defaultNS;
        }
        if (NULL === $namespacedef) {
            $namespacedef = $this->namespacedef;
            if (0 >= strpos($namespacedef, 'xmlns=')) {
                $namespacedef = ' xmlns="' . self::$defaultNS . '"' . $namespacedef;
            }
        }
        $ns = VMware_VCloud_API_Helper::getNamespaceTag($this->namespace, $name, self::$defaultNS, $namespace, $rootNS);
        $out = VMware_VCloud_API_Helper::addString($out, '<' . $ns . $name . $namespacedef);
        $out = $this->exportAttributes($out, $level, $name, $namespacedef, $namespace, $rootNS);
        if ($this->hasContent()) {
            $out = VMware_VCloud_API_Helper::addString($out, ">\n");
            $out = $this->exportChildren($out, $level + 1, $name, $namespace, $rootNS);
            $out = VMware_VCloud_API_Helper::showIndent($out, $level);
            $out = VMware_VCloud_API_Helper::addString($out, "</" . $ns . $name . ">\n");
        } else {
            $out = VMware_VCloud_API_Helper::addString($out, "/>\n");
        }
        return $out;
    }
    protected function exportAttributes($out, $level, $name, $namespace, $rootNS) {
        $namespace = self::$defaultNS;
        $out = parent::exportAttributes($out, $level, $name, $namespace, $rootNS);
        return $out;
    }
    protected function exportChildren($out, $level, $name, $namespace, $rootNS) {
        $namespace = self::$defaultNS;
        $out = parent::exportChildren($out, $level, $name, $namespace, $rootNS);
        if (!is_null($this->NumberOfCpus)) {
            $out = VMware_VCloud_API_Helper::showIndent($out, $level);
            $ns = VMware_VCloud_API_Helper::getNamespaceTag($this->namespace, 'NumberOfCpus', self::$defaultNS, $namespace, $rootNS);
            $out = VMware_VCloud_API_Helper::addString($out, "<" . $ns . "NumberOfCpus>" . VMware_VCloud_API_Helper::format_integer($this->NumberOfCpus, $input_name='NumberOfCpus') . "</" . $ns . "NumberOfCpus>\n");
        }
        if (!is_null($this->CoresPerSocket)) {
            $out = VMware_VCloud_API_Helper::showIndent($out, $level);
            $ns = VMware_VCloud_API_Helper::getNamespaceTag($this->namespace, 'CoresPerSocket', self::$defaultNS, $namespace, $rootNS);
            $out = VMware_VCloud_API_Helper::addString($out, "<" . $ns . "CoresPerSocket>" . VMware_VCloud_API_Helper::format_integer($this->CoresPerSocket, $input_name='CoresPerSocket') . "</" . $ns . "CoresPerSocket>\n");
        }
        if (!is_null($this->MemorySize)) {
            $out = VMware_VCloud_API_Helper::showIndent($out, $level);
            $ns = VMware_VCloud_API_Helper::getNamespaceTag($this->namespace, 'MemorySize', self::$defaultNS, $namespace, $rootNS);
            $out = VMware_VCloud_API_Helper::addString($out, "<" . $ns . "MemorySize>" . VMware_VCloud_API_Helper::format_integer($this->MemorySize, $input_name='MemorySize') . "</" . $ns . "MemorySize>\n");
        }
        if (isset($this->Disk)) {
            foreach ($this->Disk as $Disk) {
                $out = $Disk->export('Disk', $out, $level, '', $namespace, $rootNS);
            }
        }
        return $out;
    }
    protected function hasContent() {
        if (
            !is_null($this->NumberOfCpus) ||
            !is_null($this->CoresPerSocket) ||
            !is_null($this->MemorySize) ||
            !empty($this->Disk) ||
            parent::hasContent()
            ) {
            return true;
        } else {
            return false;
        }
    }
    public function build($node, $namespaces='') {
        $tagName = $node->tagName;
        $this->tagName = $tagName;
        if (strpos($tagName, ':') > 0) {
            list($namespace, $tagName) = explode(':', $tagName);
            $this->tagName = $tagName;
            $this->namespace[$tagName] = $namespace;
        }
        $this->buildAttributes($node, $namespaces);
        $children = $node->childNodes;
        foreach ($children as $child) {
            if ($child->nodeType == XML_ELEMENT_NODE || $child->nodeType == XML_TEXT_NODE) {
                $namespace = '';
                $nodeName = $child->nodeName;
                if (strpos($nodeName, ':') > 0) {
                    list($namespace, $nodeName) = explode(':', $nodeName);
                }
                $this->buildChildren($child, $nodeName, $namespace);
            }
        }
    }
    protected function buildAttributes($node, $namespaces='') {
        $attrs = $node->attributes;
        if (!empty($namespaces)) {
            $this->namespacedef = VMware_VCloud_API_Helper::constructNS($attrs, $namespaces, $this->namespacedef) . $this->namespacedef;
        }
        $nsUri = self::$defaultNS;
        parent::buildAttributes($node, $namespaces);
    }
    protected function buildChildren($child, $nodeName, $namespace='') {
        if ($child->nodeType == XML_ELEMENT_NODE && $nodeName == 'NumberOfCpus') {
            $sval = $child->nodeValue;
            $this->NumberOfCpus = $sval;
            if (!empty($namespace)) {
                $this->namespace['NumberOfCpus'] = $namespace;
            }
        }
        elseif ($child->nodeType == XML_ELEMENT_NODE && $nodeName == 'CoresPerSocket') {
            $sval = $child->nodeValue;
            $this->CoresPerSocket = $sval;
            if (!empty($namespace)) {
                $this->namespace['CoresPerSocket'] = $namespace;
            }
        }
        elseif ($child->nodeType == XML_ELEMENT_NODE && $nodeName == 'MemorySize') {
            $sval = $child->nodeValue;
            $this->MemorySize = $sval;
            if (!empty($namespace)) {
                $this->namespace['MemorySize'] = $namespace;
            }
        }
        elseif ($child->nodeType == XML_ELEMENT_NODE && $nodeName == 'Disk') {
            $obj = new VMware_VCloud_API_DiskType();
            $obj->build($child);
            $obj->set_tagName('Disk');
            array_push($this->Disk, $obj);
            if (!empty($namespace)) {
                $this->namespace['Disk'] = $namespace;
            }
        }
        parent::buildChildren($child, $nodeName, $namespace);
    }
}