<?php
namespace Filanco\Whois\Exception;

use Exception;

class WhoisServerForTldNotFoundException extends Exception
{
    /**
     * WhoisServerForTldNotFoundException constructor.
     * @param string $tld
     * @param int $code
     * @param Exception|null $previous
     */
    public function __construct($tld, $code = 0, Exception $previous = null)
    {
        $message = 'Не найден сервер whois для доменной зоны ' . $tld . '!';
        parent::__construct($message, $code, $previous);
    }
}
