<?php namespace Halk\Core;
/**
 * Mailer class.
 *
 * @category   PHP
 * @package    Halk
 * @subpackage Core
 * @author     Kolombet Ivan <i.kolombet@hoster.ru>
 * @copyright  2011 Filanco
 * @license    Proprietary http://www.filanco.ru
 * @version    Release: 2.0
 * @link       http://halk.filanco.ru
 */

require_once("Mail.php");
require_once("Mail/mime.php");

//use Mail;
//use Mail_mime;

class Mailer extends Registry {


    protected $_to;
    protected $_body;
    protected $_headers;
    protected $_crlf = "\n";
    protected $_attachments = array();
    private $__mime;

    public function __construct($charset = 'UTF-8')
    {

        $this->__mime = new \Mail_mime(array(
                'eol' => $this->_crlf,
                'head_encoding' => $charset,
                'text_encoding' => $charset,
                'html_encoding' => $charset,
                'head_charset' => $charset,
                'text_charset' => $charset,
                'html_charset' => $charset,
            )
        );

        $this->_headers = array(
            'From' => Config::getInstance()->getValue('mail_default_from'),
            'Subject' => 'Тема письма',
            'Content-Type' => 'text/plain; charset="UTF-8"'
        );
    }

    public function send($to)
    {
        $body = $this->__mime->get();
        $hdrs = $this->__mime->headers($this->_headers);
        /** @noinspection PhpUndefinedClassInspection */
        $mail = \Mail::factory('mail');
        $mail->send($to, $hdrs, $body);
        return true;
    }

    public function addAttachment(
        $file,
        $c_type = 'application/octet-stream',
        $name = '',
        $isfile = true,
        $encoding = 'base64',
        $disposition = 'attachment',
        $charset = '',
        $language = '',
        $location = '',
        $n_encoding = null,
        $f_encoding = null,
        $description = '',
        $h_charset = null
    ) {
        $this->__mime->addAttachment(
            $file,
            $c_type,
            $name,
            $isfile,
            $encoding,
            $disposition,
            $charset,
            $language,
            $location,
            $n_encoding,
            $f_encoding,
            $description,
            $h_charset
        );
    }

    public function setTxtBody($data, $isfile = false)
    {

        $this->__mime->setTxtBody($data, $isfile);
        return $this;
    }

    public function setHTMLBody($data, $isfile = false)
    {
        $this->__mime->setHTMLBody($data, $isfile);
        return $this;
    }

    public function setHeader($key, $value)
    {
        $this->_headers[$key] = $value;
        return $this;
    }
    

}//end class
