<?php namespace Halk\Core\Cache;

/**
 * Class CacheAdapter
 * @package Halk\Core\Cache
 */
class CacheAdapter implements Cacheable
{
    protected $driver;

    public function __construct(Cacheable $driver)
    {
        $this->driver = $driver;
    }

    public function set($key, $value, $expire = 0)
    {
        return $this->driver->set($key, $value, $expire);
    }

    public function get($key)
    {
        return $this->driver->get($key);
    }

    public function delete($key)
    {
        $this->driver->delete($key);
    }

    public function disconnect()
    {
        $this->driver->disconnect();
    }

    public function isConnected()
    {
        return $this->driver->isConnected();
    }

    public function exists($key)
    {
        return $this->driver->exists($key);
    }
}