<?php namespace Halk\Core;

use Halk\Core\Exception\CoreException;

/**
 * Container class.
 *
 * @category   PHP
 * @package    Halk
 * @subpackage Core
 * @author     Kolombet Ivan <i.kolombet@hoster.ru>
 * @copyright  2011 Filanco
 * @license    Proprietary http://www.filanco.ru
 * @version    Release: 2.0
 * @link       http://halk.filanco.ru
 */
abstract class Pool extends Registry implements PoolInterface {

    /**
     * Name of class to store
     * @var string
     */
    public $entity = null;

    /**
     * Array of stored objects
     * @var array
     */
    private $_pool = array();

    /**
     * Constructor.
     */
    public function __construct() {

        $this->load();
    }//end __construct()

    /**
     * Fetch object by ID.
     *
     * @param string $id identifier
     *
     * @return object
     * @throws CoreException if ID does not exist
     */
    public function get($id) {

        if(!isset($this->_pool[$id])) {
            throw new CoreException(sprintf('%s with id %s does not exist.', $this->entity, $id));
        }

        return $this->_pool[$id];
    }//end get()

    /**
     * Add new object to container and assign it a certain ID.
     * Id must be unique.
     *
     * @param string          $id     identifier
     * @param PoolElement $object object instance
     *
     * @see PoolElement
     *
     * @return void
     * @throws CoreException if wrong object or not unique ID
     */
    public function add($id, PoolElement $object) {

        if(!($object instanceof $this->entity)) {
            throw new CoreException(sprintf('Cannot add object of type %s to %s. %s expected.',
                    get_class($object), get_called_class(), $this->entity));
        }

        if(isset($this->_pool[$id])) {
            throw new CoreException(sprintf('%s with id %s already exists', $this->entity, $id));
        }

        $this->_pool[$id] = $object;
    }//end add()

    /**
     * @param $id
     *
     * @return bool
     */
    public function contains ($id) {
       return isset($this->_pool[$id]);
    }
}//end class
