<?php namespace Halk\Core;

use Halk\Core\Exception\InputException;

/**
 * Request object.
 *
 * позволяет получить переменные из $_REQUEST
 *
 * PHP version 5.4
 *
 * @category   PHP
 * @package    Halk
 * @subpackage Core
 * @author     Kolombet Ivan <i.kolombet@hoster.ru>
 * @copyright  2011 Filanco
 * @license    Proprietary http://www.filanco.ru
 * @version    SVN: $Id: RequestData.php 10709 2012-03-28 13:25:43Z i.kolombet $
 * @link       http://halk.filanco.ru
 */
class RequestData extends Registry
{

    /**
     * @param string $name
     * @return array|mixed|string
     * @throws \Halk\Core\Exception\InputException
     */
    public function __get($name)
    {

        if (!isset($_REQUEST[$name])) {
            throw new InputException(sprintf('Обязательный параметр `%s` не задан', $name));
        }

        $value = $_REQUEST[$name];

        if (is_array($value)) {

            array_walk($value, function($x) {
                return $this->halk_request_process_var($x);
            });

        } else {

            $value = $this->halk_request_process_var($value);
        }

        return $value;
    }

    /**
     * @param string $name
     * @param mixed $value
     */
    public function __set($name, $value)
    {

        $_REQUEST[$name] = $value;
    }

    /**
     * @param $name
     * @param null $default
     * @param bool $allow_null
     * @param null $name_for_error
     * @return null
     * @throws \Halk\Core\Exception\InputException
     */
    public static function ob($name, $default = null, $allow_null = false, $name_for_error = null)
    {

        if (!isset($_REQUEST[$name])) {
            if (!is_null($default)) {
                return $default;
            } else {
                if ($allow_null) {
                    return null;
                }
            }
        } else {
            if ($_REQUEST[$name] == '' && is_null($default) && $allow_null) {
                return null;
            } else {
                return $_REQUEST[$name];
            }
        }

        throw new InputException(sprintf(
            'Обязательный параметр `%s` не задан',
            $name_for_error ? $name_for_error : $name
        ));
    }

    protected function halk_request_process_var($x)
    {
        $x = trim($x);

        return $x;
    }
}
