<?php

/**
 * Halk running in CLI (command line) mode
 */
define('HALK_MODE_CLI', 1);

/**
 * Halk running in WWW mode
 */
define('HALK_MODE_WWW', 2);

/**
 * Config file
 */
define('HALK_DEFAULT_CONF', HALK_APP_ROOT .'/'.HALK_APPLICATION_NAME.'.ini');

/**
 * DOCUMENT_ROOT (место расположения файла index.php)
 */
define('HALK_DOCUMENT_ROOT', HALK_APP_ROOT . '/../html/vendor');

/**
 * Каталог с *.mo файлами
 */
define('HALK_LOCALE_PATH', HALK_APP_ROOT . '/locale/');

/**
 * Autodetected mode
 */
define('HALK_RUNNING_MODE', PHP_SAPI == 'cli' ? HALK_MODE_CLI : HALK_MODE_WWW);

/**
 * Время начала обработки запроса
 */
define('HALK_STARTUP_TIME', microtime(true));

/**
 * Версия приложения (без точек!!!)
 */
define('HALK_VERSION', 'halk-1_0_27');

/**
 * Кодировка приложения
 */
define('HALK_INTERNAL_ENCODING', 'UTF-8');

/**
 * Дефолтный root элемент XML-файлов
 */
define('HALK_DEFAULT_XML_ROOT_ELEMENT', 'root');

/**
 * Левый разделитель Smarty
 */
define('HALK_SMARTY_LEFT_DELIMITER', '{');

/**
 * Правый разделитель Smarty
 */
define('HALK_SMARTY_RIGHT_DELIMITER', '}');

/**
 * Суффикс файлов шаблонов
 */
define('HALK_SMARTY_TEMPLATE_POSTFIX', '.tpl');

/**
 * Дефолтный контроллер, используется если запрошенный контроллер не найден
 */
define('HALK_CONTROLLER_DEFAULT_NAME', '\\'.HALK_APPLICATION_NAME.'\Module\Index\Controller\Index');

/**
 * Дефолтный контроллер, используется для статических страниц
 */
define('HALK_CONTROLLER_DEFAULT_STATIC_PAGE', '\\'.HALK_APPLICATION_NAME.'\Module\Core\Controller\Staticpage');

/**
 * Дефолтный метод контроллеров, используется если метод не указан
 */
define('HALK_CONTROLLER_DEFAULT_METHOD_NAME', 'index');

/**
 * Дефолтные параметры методов контроллера, если не указаны
 */
define('HALK_CONTROLLER_DEFAULT_METHOD_PARAMS', null);

/**
 * Дефолтный файл шаблона
 */
define('HALK_CONTROLLER_DEFAULT_TEMPLATE_NAME', 'index/index');

/**
 * Префикс маршрутизируемых методов контроллера
 */
define('HALK_CONTROLLER_ACTION_PREFIX', 'action_');

/**
 * Имя сессии
 */
define('HALK_SESSION_NAME', 'session_' . HALK_VERSION);

/**
 * Соль паролей
 */
define('HALK_PASSWORD_SALT', 'letshopeforthebest');

/**
 * Дефолтный идентификатор подключения к БД
 */
define('HALK_DEFAULT_CONNECTION_ID', 'main');

/**
 * Требуемая минимальная версия PHP
 */
define('HALK_SYSREQ_PHP_VERSION', '5.4.0');

/**
 * Максимальное количество объектов, выводимое за раз
 */
define('HALK_PER_PAGE_LIMIT', 25);

define('HALK_MAX_PER_PAGE_LIMIT', 100);

define('HALK_MASK_LENGTH', 1024);

define('HALK_ROOT_MASK', str_repeat('1', HALK_MASK_LENGTH));

define('HALK_INTERNAL_ERROR_MSG', _('Internal error, sorry.'));