<?php
use Halk\Core\ActiveRecord;
use Halk\Core\ConnectionPool;

require_once __DIR__ . '/../../vendor/autoload.php';

const HALK_DEFAULT_CONF = __DIR__ . '/../Halk.ini';
const HALK_DEFAULT_CONNECTION_ID = 'main';

ConnectionPool::getInstance()->load();

/**
 * Class Project
 *
 * @property int $id
 * @property string $title
 * @property string $system_name
 * @property int $currency_id
 * @property int $parent_id
 * @property int $region_id
 */
class Project extends ActiveRecord
{
    /**
     * @var string
     */
    public static $table = 'public.projects';

    public static $title_field = 'title';
    /**
     * @var array
     */
    public static $fields = array(
        'title' => array(
            'type' => 'varchar(64)',
            'not_null' => true,
            'not_empty' => true,
            'unique' => true,
            'title' => 'Проект'
        ),
        'system_name' => array('type' => 'varchar(64)', 'not_null' => true, 'not_empty' => true, 'unique' => true),
        'currency_id' => array('type' => 'integer',),
        'parent_id' => array('type' => 'integer'),
        'region_id' => array('type' => 'integer'),
    );
}

$projects = Project::getByParams(['parent_id' => '123']);
