<?php
/**
 * User: r.mubarakzjanov
 * Date: 04.06.15
 * Time: 9:51
 */

namespace Halk\Core\Helper;

class Phone
{
    /**
     * Приводит параметр $phone к числовому виду и форматирует его
     * @param $phone
     * @return string номер телефона в формате +7.1234567890
     */
    public static function getEnomFormat($phone)
    {
        $phone = preg_replace('/[^0-9]*/', '', $phone);
        return '+' . substr($phone, 0, 1) . '.' . str_replace(' ', '', substr($phone, 1));
    }

    public static function sanitize($phone)
    {
        $phone = preg_replace('/[^0-9]*/', '', $phone);
        return $phone;
    }
}
