<?php namespace Halk\Core\Exception;

/**
 * Assert exception
 *
 * PHP version 5.4
 *
 * @category   PHP
 * @package    Halk
 * @subpackage Exceptions
 * @author     Kolombet Ivan <i.kolombet@hoster.ru>
 * @copyright  2012 Filanco
 * @license    Proprietary http://www.filanco.ru
 * @version    SVN: $Id: Halk_Core_AssertException.php 10906 2012-04-03 14:44:19Z i.kolombet $
 * @link       http://halk.filanco.ru
 */

class AssertException extends CoreException {

    /**
     * @param string    $message
     * @param int       $code
     * @param \Exception $previous
     */
    public function __construct($message, $code = 0, \Exception $previous = null) {

        $message = sprintf('Assertion failed: %s', $message);

        parent::__construct($message, $code, $previous);
    }
}
