<?php
namespace Halk\Core;

use Doctrine\DBAL\Connection;
use PDO;

abstract class Repository
{
    public static $connection_id = HALK_DEFAULT_CONNECTION_ID;

    /**
     * @param string $query
     * @param array $params
     * @return static[]
     */
    public function getByQuery($query, array $params = [])
    {
        $dbo = $this->getDBO()->getPDO();
        $result = [];
        $query = $dbo->prepare($query);
        $query->execute($params);
        while ($row = $query->fetch(PDO::FETCH_ASSOC)) {
            /** @var LoadInterface $object */
            $template_object = $this->getTemplateObject();
            $object = clone $template_object;
            $object->loadFromData($row);
            $result[] = $object;
        }

        return $result;
    }

    /**
     * @param string $query
     * @param array $params
     * @return static|null
     */
    public function getOneByQuery($query, array $params = [])
    {
        $result = $this->getByQuery($query, $params);
        if ($result) {
            $result = $result[0];
        } else {
            $result = null;
        }
        return $result;
    }

    /**
     * @return mixed
     */
    abstract protected function getTemplateObject();

    /**
     * @return DBO
     */
    protected function getDBO()
    {
        return ConnectionPool::getInstance()->get(static::$connection_id);
    }

    /**
     * @return Connection
     */
    protected function getDBAL()
    {
        return $this->getDBO()->getDBAL();
    }
}
