<?php namespace Halk\Core\Helper;

/**
 * Array2XML class.
 *
 * @category  PHP
 * @package   Common
 * @author    Kolombet Ivan <i.kolombet@hoster.ru>
 * @copyright 2011 Filanco
 * @license   Proprietary http://www.filanco.ru
 * @version   Release: 2.0
 * @link      http://halk.filanco.ru
 */
class Array2XML {

    /**
     *
     * @var \XMLWriter
     */
    private $writer;

    /**
     *
     * @var string
     */
    private $version = '1.0';

    /**
     *
     * @var string
     */
    private $encoding = 'UTF-8';

    /**
     *
     * @var string
     */
    private $rootName = 'root';

    /**
     * Constructor.
     *
     * @param string $root root element
     * @param string $encoding encoding
     *
     * @return Array2XML
     */
    function __construct($root, $encoding) {
        $this->writer = new \XMLWriter();
        $this->encoding = $encoding;
        $this->root = $root;
    }//end __construct()

    /**
     * Convert to xml.
     *
     * @param mixed $data data
     *
     * @return string
     */
    public function convert($data) {
        $this->writer->openMemory();
        $this->writer->startDocument($this->version, $this->encoding);
        $this->writer->startElement($this->rootName);
        if (is_array($data)) {
            $this->getXML($data);
        }
        $this->writer->endElement();
        return $this->writer->outputMemory();
    }//end convert()

    /**
     * Get XML from array
     *
     * @param array $data data
     *
     * @return void
     */
    private function getXML(array $data) {
        foreach ($data as $key => $val) {
            if (is_numeric($key)) {
                $key = 'key'.$key;
            }
            if (is_array($val)) {
                $this->writer->startElement($key);
                $this->getXML($val);
                $this->writer->endElement();
            }
            else {
                $this->writer->writeElement($key, $val);
            }
        }
    }//end getXML()

    /**
     * Convert XML to array.
     *
     * @param \SimpleXMLElement $xml xml element
     *
     * @return array
     */
    public static function xml2array(\SimpleXMLElement $xml) {

        $json = json_encode($xml);
        return json_decode($json, true);
    }//end xml2array()
}//end class
